/*
 * Decompiled with CFR 0.152.
 */
package rdm.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import rdm.state.StateCollector;
import rdm.state.StateCollectorImplKt;
import rdm.state.Wave;
import rdm.state.entities.AggregateState;
import rdm.state.entities.EnemyState;
import rdm.state.entities.InstantState;
import rdm.state.entities.SelfState;
import rdm.state.entities.State;
import rdm.state.entities.WorldState;
import rdm.state.utils.MinMaxCollector;
import rdm.state.utils.MovingAverage;
import rdm.state.utils.VisitCountStats;
import robocode.util.Utils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0015H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00042\u0006\u0010)\u001a\u00020*H\u0002J&\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00042\u0006\u0010&\u001a\u00020\u00152\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020.H\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020.0\u00042\u0006\u00102\u001a\u00020.H\u0002J\b\u00103\u001a\u00020(H\u0016J\b\u00104\u001a\u00020(H\u0016J\u0010\u00105\u001a\u00020(2\u0006\u0010&\u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lrdm/state/StateCollectorImpl;", "Lrdm/state/StateCollector;", "()V", "accelerationAverages", "", "Lrdm/state/utils/MovingAverage;", "advancingVelocityAverages", "distanceAverages", "enemyRangeX", "Lrdm/state/utils/MinMaxCollector;", "enemyRangeXAverage", "enemyRangeY", "enemyRangeYAverage", "headingChangeAverages", "lateralVelocityAverages", "linearPredictionAverages", "normalCenterDistanceAverages", "normalWallDistanceAverages", "normalXAverages", "normalYAverages", "previousInstant", "Lrdm/state/entities/InstantState;", "relativeEnemyHeadingAverages", "timeSinceAcceleration", "", "timeSinceAccelerationAverages", "timeSinceDeceleration", "timeSinceDecelerationAverages", "timeSinceMove", "timeSinceMoveAverages", "velocityAverages", "visitCountStats", "Lrdm/state/utils/VisitCountStats;", "waves", "", "Lrdm/state/Wave;", "collect", "Lrdm/state/entities/State;", "instant", "collectEnemyPosition", "", "enemy", "Lrdm/state/entities/EnemyState;", "extractBooleans", "", "extractFloats", "", "enemyHeadingChange", "enemyAcceleration", "extractRanges", "worldArea", "onRoundStart", "onRoundStop", "processWaves", "Commons"})
public final class StateCollectorImpl
implements StateCollector {
    private static final List<MovingAverage> velocityAverages;
    private static final List<MovingAverage> distanceAverages;
    private static final List<MovingAverage> lateralVelocityAverages;
    private static final List<MovingAverage> advancingVelocityAverages;
    private static final List<MovingAverage> normalXAverages;
    private static final List<MovingAverage> normalYAverages;
    private static final List<MovingAverage> normalCenterDistanceAverages;
    private static final List<MovingAverage> normalWallDistanceAverages;
    private static final List<MovingAverage> headingChangeAverages;
    private static final List<MovingAverage> accelerationAverages;
    private static final List<MovingAverage> relativeEnemyHeadingAverages;
    private static final List<MovingAverage> linearPredictionAverages;
    private static List<MovingAverage> timeSinceMoveAverages;
    private static List<MovingAverage> timeSinceAccelerationAverages;
    private static List<MovingAverage> timeSinceDecelerationAverages;
    private static final MinMaxCollector enemyRangeX;
    private static final MinMaxCollector enemyRangeY;
    private static final MovingAverage enemyRangeXAverage;
    private static final MovingAverage enemyRangeYAverage;
    private static final List<Wave> waves;
    private static final VisitCountStats visitCountStats;
    private static InstantState previousInstant;
    private static int timeSinceMove;
    private static int timeSinceDeceleration;
    private static int timeSinceAcceleration;
    public static final StateCollectorImpl INSTANCE;

    @Override
    public void onRoundStart() {
        double d = enemyRangeX.getRange();
        if (!Double.isNaN(d)) {
            enemyRangeXAverage.add(enemyRangeX.getRange());
        }
        if (!Double.isNaN(d = enemyRangeY.getRange())) {
            enemyRangeYAverage.add(enemyRangeY.getRange());
        }
        enemyRangeX.clear();
        enemyRangeY.clear();
    }

    @Override
    public void onRoundStop() {
        enemyRangeXAverage.add(enemyRangeX.getRange());
        enemyRangeYAverage.add(enemyRangeY.getRange());
        timeSinceMove = 0;
        timeSinceAcceleration = 0;
        timeSinceDeceleration = 0;
        waves.clear();
        previousInstant = null;
    }

    @Override
    @NotNull
    public State collect(@NotNull InstantState instant) {
        MovingAverage it;
        double enemyAcceleration;
        double enemyHeadingChange;
        Intrinsics.checkParameterIsNotNull(instant, "instant");
        InstantState instantState = instant;
        EnemyState enemy = instantState.component3();
        InstantState finalPreviousInstant = previousInstant;
        if (finalPreviousInstant != null) {
            enemyHeadingChange = enemy.getHeading() - finalPreviousInstant.getEnemy().getHeading();
            enemyAcceleration = enemy.getVelocity() - finalPreviousInstant.getEnemy().getVelocity();
        } else {
            enemyHeadingChange = 0.0;
            enemyAcceleration = 0.0;
        }
        Iterable $receiver$iv = headingChangeAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemyHeadingChange);
        }
        $receiver$iv = accelerationAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemyAcceleration);
        }
        timeSinceMove = Utils.isNear((double)0.0, (double)enemy.getVelocity()) ? 0 : timeSinceMove + 1;
        timeSinceAcceleration = enemyAcceleration > 0.0 ? 0 : timeSinceAcceleration + 1;
        timeSinceDeceleration = enemyAcceleration < 0.0 ? 0 : timeSinceDeceleration + 1;
        $receiver$iv = timeSinceMoveAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(timeSinceMove);
        }
        $receiver$iv = timeSinceAccelerationAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(timeSinceAcceleration);
        }
        $receiver$iv = timeSinceDecelerationAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(timeSinceDeceleration);
        }
        $receiver$iv = velocityAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getVelocity());
        }
        $receiver$iv = distanceAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getDistance());
        }
        $receiver$iv = lateralVelocityAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getLateralVelocity());
        }
        $receiver$iv = advancingVelocityAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getAdvancingVelocity());
        }
        $receiver$iv = normalXAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getNormalPositionX());
        }
        $receiver$iv = normalYAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getNormalPositionY());
        }
        $receiver$iv = normalCenterDistanceAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getNormalDistanceFromCenter());
        }
        $receiver$iv = normalWallDistanceAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(enemy.getNormalDistanceFromWall());
        }
        $receiver$iv = relativeEnemyHeadingAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(instant.getRelativeEnemyHeading());
        }
        $receiver$iv = linearPredictionAverages;
        for (Object element$iv : $receiver$iv) {
            it = (MovingAverage)element$iv;
            it.add(instant.calculateLinearPredictionRadians(3.0, enemy.getVelocity()));
        }
        this.processWaves(instant);
        this.collectEnemyPosition(enemy);
        List<Boolean> booleans = this.extractBooleans(enemy);
        List<Double> floats = this.extractFloats(instant, enemyHeadingChange, enemyAcceleration);
        previousInstant = instant;
        return new State(instant, new AggregateState(booleans, floats, visitCountStats.getStats()));
    }

    private final List<Boolean> extractBooleans(EnemyState enemy) {
        List list = new ArrayList();
        list.add(enemy.getEnergy() == 0.0);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Double> extractFloats(InstantState instant, double enemyHeadingChange, double enemyAcceleration) {
        void world;
        Double d;
        MovingAverage it;
        Collection<Double> collection;
        Object item$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv;
        InstantState instantState = instant;
        WorldState worldState = instantState.component1();
        EnemyState enemy = instantState.component3();
        List list = new ArrayList();
        list.add(enemyHeadingChange);
        list.add(enemyAcceleration);
        list.add(Double.valueOf(timeSinceMove));
        list.add(Double.valueOf(timeSinceAcceleration));
        list.add(Double.valueOf(timeSinceDeceleration));
        Iterable iterable = timeSinceMoveAverages;
        List list2 = list;
        void var10_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            MovingAverage movingAverage = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll((Collection)collection);
        $receiver$iv = timeSinceAccelerationAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = timeSinceDecelerationAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        list.add(instant.getRelativeEnemyHeading());
        list.add(instant.calculateLinearPredictionRadians(3.0, enemy.getVelocity()));
        list.add(instant.calculateCircularPrediction(3.0, instant.getEnemy().getVelocity(), enemyHeadingChange));
        list.add(instant.getDistanceToWallBehindEnemy());
        list.add(instant.getDistanceToWallToLeftOfEnemy());
        list.add(instant.getDistanceToWallToRightOfEnemy());
        list.add(instant.getForwardWallDistance());
        list.add(instant.getReverseWallDistance());
        list.add(enemy.getDistance());
        list.add(enemy.getVelocity());
        list.add(enemy.getLateralVelocity());
        list.add(enemy.getAdvancingVelocity());
        list.add(enemy.getNormalDistanceFromCenter());
        list.add(enemy.getNormalDistanceFromWall());
        $receiver$iv = headingChangeAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = accelerationAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = velocityAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = distanceAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = lateralVelocityAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = advancingVelocityAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = normalCenterDistanceAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = normalWallDistanceAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = relativeEnemyHeadingAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = linearPredictionAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = it.getAverage();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = velocityAverages;
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (MovingAverage)item$iv$iv;
            collection = destination$iv$iv;
            d = instant.calculateLinearPredictionRadians(3.0, it.getAverage());
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        $receiver$iv = visitCountStats.getStats();
        list2 = list;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(((Object)$receiver$iv).length);
        int n = ((Object)$receiver$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it2;
            Object item$iv$iv2;
            Object $i$a$14$map = item$iv$iv2 = $receiver$iv$iv[i];
            collection = destination$iv$iv;
            d = (double)it2 / (double)visitCountStats.getMaxVisits();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        list.addAll((Collection)this.extractRanges(world.getWidth() * world.getHeight()));
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void processWaves(InstantState instant) {
        void self;
        void world;
        InstantState instantState = instant;
        WorldState worldState = instantState.component1();
        SelfState selfState = instantState.component2();
        EnemyState enemy = instantState.component3();
        Iterator<Wave> iterator2 = waves.iterator();
        while (iterator2.hasNext()) {
            Wave wave = iterator2.next();
            Integer index = wave.getHitSegmentIndex(enemy.getPosition(), world.getTime(), visitCountStats.getCount());
            if (index != null) {
                visitCountStats.addVisit(index);
                iterator2.remove();
                continue;
            }
            if (!wave.isOutOfWorld(world.getMaxSize(), world.getTime())) continue;
            iterator2.remove();
        }
        waves.add(new Wave(self.getBody().getPosition(), instant.getAbsoluteBearingRadians(), 3.0, enemy.getDirection(), world.getTime()));
    }

    private final void collectEnemyPosition(EnemyState enemy) {
        enemyRangeX.add(enemy.getPosition().getX());
        if (enemyRangeXAverage.isEmpty()) {
            enemyRangeXAverage.add(enemyRangeX.getRange());
        }
        enemyRangeY.add(enemy.getPosition().getY());
        if (enemyRangeYAverage.isEmpty()) {
            enemyRangeYAverage.add(enemyRangeY.getRange());
        }
    }

    private final List<Double> extractRanges(double worldArea) {
        return CollectionsKt.listOf(new Double[]{enemyRangeX.getRange(), enemyRangeY.getRange(), enemyRangeXAverage.getAverage(), enemyRangeYAverage.getAverage(), enemyRangeX.getRange() * enemyRangeY.getRange() / worldArea, enemyRangeXAverage.getAverage() * enemyRangeYAverage.getAverage() / worldArea});
    }

    private StateCollectorImpl() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        MovingAverage movingAverage;
        int it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        StateCollectorImpl stateCollectorImpl;
        INSTANCE = stateCollectorImpl = new StateCollectorImpl();
        Iterable iterable = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        velocityAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        distanceAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        lateralVelocityAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        advancingVelocityAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        normalXAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        normalYAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        normalCenterDistanceAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        normalWallDistanceAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        headingChangeAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        accelerationAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        relativeEnemyHeadingAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        linearPredictionAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        timeSinceMoveAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        timeSinceAccelerationAverages = CollectionsKt.toList((List)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv = (Iterable)StateCollectorImplKt.access$getRANGES$p();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            movingAverage = new MovingAverage(it);
            collection.add(movingAverage);
        }
        timeSinceDecelerationAverages = CollectionsKt.toList((List)var3_3);
        enemyRangeX = new MinMaxCollector();
        enemyRangeY = new MinMaxCollector();
        enemyRangeXAverage = new MovingAverage(35);
        enemyRangeYAverage = new MovingAverage(35);
        waves = new ArrayList();
        visitCountStats = new VisitCountStats(31);
    }
}

