/*
 * Decompiled with CFR 0.152.
 */
package Lo_Ian;

import java.awt.Color;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Gandalf_V4
extends AdvancedRobot {
    int wallCount;
    double xForce = 0.0;
    double yForce = 0.0;
    double xTarget;
    double yTarget;
    int counter = 0;
    double hTarget;
    double xTotalForce;
    double yTotalForce;
    boolean trouble = false;
    ArrayList<Enemy> enemies = new ArrayList();
    int remainingRobots = 0;
    boolean grondMode = false;
    int direction = 1;
    boolean inBorder = false;

    public void run() {
        this.setColors(Color.WHITE, Color.WHITE, Color.WHITE);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.xTarget = this.getX();
        this.yTarget = this.getY();
        this.hTarget = this.getHeading();
        this.remainingRobots = this.getOthers();
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        this.execute();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy enemy = new Enemy();
        enemy.update(e);
        this.updateEnemiesList(enemy);
        if (this.remainingRobots != this.getOthers()) {
            if (this.getClosestEnemy().distance > 50.0 && this.getClosestEnemy().energy < this.getEnergy()) {
                this.grondMode = false;
            }
            this.enemies = new ArrayList();
            this.remainingRobots = this.getOthers();
        }
        if (this.getOthers() != 1) {
            this.myGrav(e);
            if (e.getEnergy() == 0.0) {
                double angle = this.getHeading() + e.getBearing() - this.getGunHeading();
                this.setTurnGunRight(this.normalRelativeAngle(angle));
                if (Math.abs(angle) < 5.0) {
                    this.setFire(0.1);
                }
                this.execute();
            } else {
                Enemy closestEnemy = this.getClosestEnemy();
                if (closestEnemy != null) {
                    if (this.grondMode) {
                        this.GRONDGRONDGROND(closestEnemy);
                    }
                    closestEnemy.predictNextAngle(this.getShotPower(closestEnemy));
                }
            }
        } else {
            this.setTurnRadarLeft(this.normalRelativeAngle(this.getRadarHeading() - e.getBearing() - this.getHeading()));
            this.getClosestEnemy().predictNextAngle(this.getShotPower(this.getClosestEnemy()));
            if (this.direction == 1) {
                this.setTurnRight(this.normalRelativeAngle(e.getBearing() + 75.0));
            } else {
                this.setTurnRight(this.normalRelativeAngle(e.getBearing() + 105.0));
            }
            this.setAhead(Double.POSITIVE_INFINITY * (double)this.direction);
            double border = 200.0;
            if (this.getX() < border || this.getY() < border || this.getBattleFieldWidth() - this.getX() < border || this.getBattleFieldHeight() - this.getY() < border) {
                if (!this.inBorder) {
                    this.direction *= -1;
                    this.inBorder = true;
                }
            } else {
                this.inBorder = false;
            }
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.direction *= -1;
        this.inBorder = true;
    }

    public void onHitRobot(HitRobotEvent e) {
        if (Math.abs(e.getBearing()) < 45.0 && e.getEnergy() < this.getEnergy() && this.getEnergy() > 30.0 && e.isMyFault()) {
            this.grondMode = true;
        }
    }

    public void myGrav(ScannedRobotEvent e) {
        double myXForce = 0.0;
        double myYForce = 0.0;
        for (Enemy en : this.enemies) {
            myXForce -= 1.0 / en.xDistanceFromEnemy;
            myYForce -= 1.0 / en.yDistanceFromEnemy;
        }
        double wallStrength = 5 * this.getOthers();
        myXForce = this.getX() < this.getBattleFieldWidth() / 2.0 ? (myXForce += wallStrength / this.getX()) : (myXForce -= wallStrength / (this.getBattleFieldWidth() - this.getX()));
        myYForce = this.getY() < this.getBattleFieldHeight() / 2.0 ? (myYForce += wallStrength / this.getY()) : (myYForce -= wallStrength / (this.getBattleFieldHeight() - this.getY()));
        double finalHeading = Math.atan2(myXForce, myYForce);
        double turnDegrees = Math.toDegrees(Utils.normalRelativeAngle((double)(finalHeading - this.getHeadingRadians())));
        if (Math.abs(turnDegrees) > 20.0) {
            this.setTurnRightRadians(turnDegrees);
        } else {
            this.setTurnRight(0.0);
        }
        this.setAhead(Double.POSITIVE_INFINITY);
    }

    public Enemy getClosestEnemy() {
        if (this.enemies.size() > 0) {
            double closestD = Double.POSITIVE_INFINITY;
            Enemy closest = new Enemy();
            for (Enemy e : this.enemies) {
                if (!(e.distance < closestD)) continue;
                closestD = e.distance;
                closest = e;
            }
            return closest;
        }
        return null;
    }

    public void updateEnemiesList(Enemy e) {
        boolean robotKnown = false;
        int i = 0;
        while (i < this.enemies.size()) {
            if (this.enemies.get((int)i).name.equals(e.name)) {
                this.enemies.remove(i);
                this.enemies.add(i, e);
                robotKnown = true;
            }
            ++i;
        }
        if (!robotKnown) {
            this.enemies.add(e);
        }
    }

    public double normalRelativeAngle(double d) {
        while (d > 180.0) {
            d -= 360.0;
        }
        while (d < -180.0) {
            d += 360.0;
        }
        return d;
    }

    public void GRONDGRONDGROND(Enemy e) {
        if (e.distance > 200.0 || this.getEnergy() < 30.0) {
            this.grondMode = false;
        }
        double absBearing = Math.toDegrees(this.getHeadingRadians() + e.bearingRadians);
        double forceAbsBearing = Math.toDegrees(e.bearingRadians + this.getHeadingRadians() + 1.5707963267948966);
        this.normalRelativeAngle(forceAbsBearing);
        double targetX = Math.sin(Math.toRadians(absBearing));
        double targetY = Math.cos(Math.toRadians(absBearing));
        this.xTotalForce = targetX;
        this.yTotalForce = targetY;
        double wallStrength = 10.0;
        this.xTotalForce = this.getX() < this.getBattleFieldWidth() / 2.0 ? (this.xTotalForce += wallStrength / this.getX()) : (this.xTotalForce -= wallStrength / (this.getBattleFieldWidth() - this.getX()));
        this.yTotalForce = this.getY() < this.getBattleFieldHeight() / 2.0 ? (this.yTotalForce += wallStrength / this.getY()) : (this.yTotalForce -= wallStrength / (this.getBattleFieldHeight() - this.getY()));
        double finalHeading = Math.atan2(this.xTotalForce, this.yTotalForce);
        double turnDegrees = Math.toDegrees(Utils.normalRelativeAngle((double)(finalHeading - this.getHeadingRadians())));
        if (Math.abs(turnDegrees) > 20.0) {
            this.setTurnRight(turnDegrees);
        } else {
            this.setTurnRight(0.0);
        }
        this.setAhead(Double.POSITIVE_INFINITY);
    }

    public double getShotPower(Enemy e) {
        double power;
        if (e.energy > 16.0) {
            power = 3.0;
        } else {
            power = (e.energy / 2.0 + 1.0) / 3.0;
            if (power < 1.0) {
                power = e.energy / 4.0;
            }
        }
        if (power < this.getEnergy()) {
            return power;
        }
        return 0.0;
    }

    public class Enemy {
        double distance;
        double headingRadians;
        double bearingRadians;
        double velocity;
        double energy;
        double x;
        double y;
        double xDistanceFromEnemy;
        double yDistanceFromEnemy;
        double enemyAbsBearingRadians;
        String name;

        public void update(ScannedRobotEvent e) {
            this.distance = e.getDistance();
            this.bearingRadians = e.getBearingRadians();
            this.velocity = e.getVelocity();
            this.headingRadians = e.getHeadingRadians();
            this.energy = e.getEnergy();
            this.name = e.getName();
            this.enemyAbsBearingRadians = this.bearingRadians + Gandalf_V4.this.getHeadingRadians();
            this.xDistanceFromEnemy = this.distance * Math.sin(this.enemyAbsBearingRadians);
            this.yDistanceFromEnemy = this.distance * Math.cos(this.enemyAbsBearingRadians);
            this.x = Gandalf_V4.this.getX() + this.xDistanceFromEnemy;
            this.y = Gandalf_V4.this.getY() + this.yDistanceFromEnemy;
        }

        public double predictNextAngle(double shotPower) {
            double a = Math.pow(20.0 - 3.0 * shotPower, 2.0) - Math.pow(this.velocity, 2.0);
            double b = -2.0 * this.velocity * Math.sin(this.headingRadians) * (this.x - Gandalf_V4.this.getX()) - 2.0 * this.velocity * Math.cos(this.headingRadians) * (this.y - Gandalf_V4.this.getY());
            double c = (Math.pow(this.x - Gandalf_V4.this.getX(), 2.0) + Math.pow(this.y - Gandalf_V4.this.getY(), 2.0)) * -1.0;
            double t1 = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            double t3 = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            if (t1 < 0.0) {
                t1 = t3;
            }
            double xDistanceFromFutureEnemy = this.velocity * t1 * Math.sin(this.headingRadians) + this.xDistanceFromEnemy;
            double yDistanceFromFutureEnemy = this.velocity * t1 * Math.cos(this.headingRadians) + this.yDistanceFromEnemy;
            double finalBearing = Math.toDegrees(Math.atan2(xDistanceFromFutureEnemy, yDistanceFromFutureEnemy)) - Gandalf_V4.this.getGunHeading();
            if (this.yDistanceFromEnemy > 0.0 && this.xDistanceFromEnemy < 0.0 || yDistanceFromFutureEnemy > 0.0 && xDistanceFromFutureEnemy < 0.0) {
                finalBearing += 360.0;
            }
            finalBearing = Gandalf_V4.this.normalRelativeAngle(finalBearing);
            if (xDistanceFromFutureEnemy + Gandalf_V4.this.getX() < Gandalf_V4.this.getBattleFieldWidth() && Gandalf_V4.this.getX() + xDistanceFromFutureEnemy > 0.0 && yDistanceFromFutureEnemy + Gandalf_V4.this.getY() < Gandalf_V4.this.getBattleFieldHeight() && Gandalf_V4.this.getY() + yDistanceFromFutureEnemy > 0.0) {
                finalBearing = Gandalf_V4.this.normalRelativeAngle(finalBearing);
                Gandalf_V4.this.setTurnGunRight(finalBearing);
                System.out.println(finalBearing);
                if (Gandalf_V4.this.getEnergy() > shotPower && Math.abs(finalBearing) < 5.0 && (this.velocity < 1.0 || this.velocity > 4.0)) {
                    Gandalf_V4.this.setFire(shotPower);
                }
            }
            return finalBearing;
        }
    }
}

