/*
 * Decompiled with CFR 0.152.
 */
package eem.bot;

import eem.bot.InfoBot;
import eem.bot.botStatPoint;
import eem.core.botProxy;
import eem.core.nullProxy;
import eem.core.realBotProxy;
import eem.event.botListener;
import eem.event.waveListener;
import eem.gameInfo.gameInfo;
import eem.gun.baseGun;
import eem.gun.firingSolution;
import eem.gun.headOnGun;
import eem.gun.linearGun;
import eem.misc.graphics;
import eem.misc.logger;
import eem.motion.basicMotion;
import eem.motion.dangerMapMotion;
import eem.radar.baseRadar;
import eem.radar.nullRadar;
import eem.radar.universalRadar;
import eem.wave.wave;
import eem.wave.waveWithBullets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.LinkedList;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class fighterBot
implements waveListener,
botListener {
    protected InfoBot fBot;
    protected gameInfo _gameinfo;
    protected baseRadar _radar;
    protected basicMotion _motion;
    public botProxy proxy;
    public LinkedList<waveWithBullets> enemyWaves = new LinkedList();
    public LinkedList<waveWithBullets> myWaves = new LinkedList();
    public HashMap<String, fighterBot> enemyBots = new HashMap();

    public fighterBot(InfoBot infoBot, gameInfo gameInfo2) {
        this.fBot = infoBot;
        this._gameinfo = gameInfo2;
        this._gameinfo._wavesManager.addWaveListener(this);
        this._gameinfo._botsmanager.addBotListener(this);
        if (this.isItMasterBotDriver()) {
            this.proxy = new realBotProxy(this._gameinfo.getMasterBot());
            this._radar = new universalRadar(this);
            this._motion = new dangerMapMotion(this);
        } else {
            this.proxy = new nullProxy(this._gameinfo.getMasterBot());
            this._radar = new nullRadar(this);
            this._motion = new basicMotion(this);
        }
    }

    public boolean isItMasterBotDriver() {
        return this.getName().equals(this._gameinfo.getMasterBot().getName());
    }

    public String getName() {
        return this.fBot.getName();
    }

    public long getTime() {
        return this._gameinfo.getTime();
    }

    public double getDanger(long l, Point2D.Double double_) {
        double d = 1.0;
        double d2 = 100.0;
        double d3 = 0.0;
        double d4 = 0.0;
        d4 = double_.distance(this.getPositionClosestToTime(l));
        return d3 += d * Math.exp(-d4 / d2);
    }

    public Point2D.Double getPosition() {
        return this.fBot.getPosition();
    }

    public Point2D.Double getPositionClosestToTime(long l) {
        return this.fBot.getPositionClosestToTime(l);
    }

    public botStatPoint getStatClosestToTime(long l) {
        return this.fBot.getStatClosestToTime(l);
    }

    public double getHeadingDegrees() {
        return this.fBot.getHeadingDegrees();
    }

    public int getNumEnemyAlive() {
        return this._gameinfo.getNumEnemyAlive();
    }

    public gameInfo getGameInfo() {
        return this._gameinfo;
    }

    public LinkedList<fighterBot> getEnemyBots() {
        return new LinkedList<fighterBot>(this.enemyBots.values());
    }

    public LinkedList<waveWithBullets> getEnemyWaves() {
        return this.enemyWaves;
    }

    public LinkedList<waveWithBullets> geMyWaves() {
        return this.myWaves;
    }

    public void initTic() {
    }

    public void manage() {
        this._radar.manage();
        this._motion.manage();
    }

    public LinkedList<firingSolution> getFiringSolutions(InfoBot infoBot, long l, double d) {
        LinkedList<firingSolution> linkedList = new LinkedList<firingSolution>();
        LinkedList<firingSolution> linkedList2 = null;
        baseGun baseGun2 = new headOnGun();
        linkedList2 = baseGun2.getFiringSolutions(this.fBot, infoBot, l, d);
        linkedList.addAll(linkedList2);
        baseGun2 = new linearGun();
        linkedList2 = baseGun2.getFiringSolutions(this.fBot, infoBot, l, d);
        linkedList.addAll(linkedList2);
        return linkedList;
    }

    public boolean isItMyWave(wave wave2) {
        return this.fBot.getName().equals(wave2.firedBot.getName());
    }

    @Override
    public void waveAdded(wave wave2) {
        if (!this.isItMyWave(wave2)) {
            String string = wave2.firedBot.getName();
            fighterBot fighterBot2 = this.enemyBots.get(string);
            logger.noise("bot " + this.fBot.getName() + " added enemy wave from " + string);
            waveWithBullets waveWithBullets2 = new waveWithBullets(wave2);
            LinkedList<firingSolution> linkedList = fighterBot2.getFiringSolutions(this.fBot, wave2.getFiredTime(), wave2.getBulletEnergy());
            for (firingSolution firingSolution2 : linkedList) {
                waveWithBullets2.addFiringSolution(firingSolution2);
            }
            this.enemyWaves.add(waveWithBullets2);
        }
    }

    @Override
    public void waveRemoved(wave wave2) {
        if (!this.isItMyWave(wave2)) {
            for (waveWithBullets waveWithBullets2 : this.enemyWaves) {
                if (!waveWithBullets2.equals(wave2)) continue;
                this.enemyWaves.remove(waveWithBullets2);
                logger.noise(this.fBot.getName() + ": Enemy( " + waveWithBullets2.getFiredBot().getName() + ")  wave is removed");
                break;
            }
        } else {
            for (waveWithBullets waveWithBullets3 : this.myWaves) {
                if (!waveWithBullets3.equals(wave2)) continue;
                this.myWaves.remove(waveWithBullets3);
                logger.noise(this.fBot.getName() + ": my wave is removed");
                break;
            }
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this._radar.onScannedRobot(scannedRobotEvent);
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        this._radar.onRobotDeath(robotDeathEvent);
    }

    @Override
    public void onScannedRobot(InfoBot infoBot) {
        if (!this.getName().equals(infoBot.getName())) {
            logger.noise("Fighter bot " + this.getName() + " scanned " + infoBot.getName());
            this.enemyBots.put(infoBot.getName(), gameInfo.liveBots.get(infoBot.getName()));
        }
    }

    @Override
    public void onRobotDeath(InfoBot infoBot) {
        this.enemyBots.remove(infoBot.getName());
    }

    public void drawThisBot(Graphics2D graphics2D, long l) {
        double d = 40.0;
        Point2D.Double double_ = this.fBot.getPositionClosestToTime(l);
        if (double_ != null) {
            graphics2D.setColor(new Color(0, 0, 255, 128));
            graphics.drawSquare(graphics2D, double_, d);
        }
    }

    public void drawEnemyBot(Graphics2D graphics2D, long l, fighterBot fighterBot2) {
        double d = 40.0;
        Point2D.Double double_ = fighterBot2.fBot.getPositionClosestToTime(l);
        if (double_ != null) {
            graphics2D.setColor(new Color(255, 0, 0, 128));
            graphics.drawSquare(graphics2D, double_, d);
        }
    }

    public void onPaint(Graphics2D graphics2D, long l) {
        if (this.isItMasterBotDriver()) {
            this.drawThisBot(graphics2D, l);
            for (waveWithBullets object : this.enemyWaves) {
                object.onPaint(graphics2D, l);
            }
            for (fighterBot fighterBot2 : this.getEnemyBots()) {
                this.drawEnemyBot(graphics2D, l, fighterBot2);
            }
            this._motion.onPaint(graphics2D);
        }
    }
}

