/*
 * Decompiled with CFR 0.152.
 */
package kid.data.pattern;

import java.util.HashMap;
import java.util.ListIterator;
import kid.data.Drawable;
import kid.data.pattern.FoldedLinkedList;
import kid.data.pattern.Pattern;
import kid.data.pattern.PatternFactory;
import kid.data.pattern.Polar;
import kid.graphics.Colors;
import kid.graphics.DrawMenu;
import kid.graphics.RGraphics;
import kid.management.RobotManager;
import kid.robot.RobotData;
import kid.utils.Utils;
import robocode.DeathEvent;
import robocode.Event;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class RobotRecorder<E extends Pattern>
implements Drawable {
    private Robot robot;
    private RobotManager robots;
    private PatternFactory<E> factory;
    private HashMap<String, FoldedLinkedList<E>> movies = null;

    public RobotRecorder(Robot myRobot, PatternFactory<E> factory) {
        this.robot = myRobot;
        this.factory = factory;
        this.robots = new RobotManager(myRobot);
        if (this.movies == null) {
            this.movies = new HashMap(this.robot.getOthers());
        }
    }

    public FoldedLinkedList<E> get(String name) {
        return this.movies.get(name);
    }

    public void inEvent(Event e) {
        this.robots.inEvent(e);
        if (e instanceof ScannedRobotEvent) {
            this.handleScannedRobot((ScannedRobotEvent)e);
        }
        if (e instanceof RobotDeathEvent) {
            this.handleRobotDeath((RobotDeathEvent)e);
        }
        if (e instanceof DeathEvent) {
            this.handleDeath((DeathEvent)e);
        }
    }

    private void handleScannedRobot(ScannedRobotEvent event) {
        if (!this.movies.containsKey(event.getName())) {
            this.movies.put(event.getName(), new FoldedLinkedList());
        }
        RobotData r = this.robots.getRobot(event.getName());
        this.movies.get(r.getName()).add(this.factory.getPattern(r, this.robot));
    }

    private void handleRobotDeath(RobotDeathEvent event) {
        if (this.movies.containsKey(event.getName())) {
            this.movies.get(event.getName()).add(this.factory.getNullPattern());
        }
    }

    private void handleDeath(DeathEvent event) {
        RobotData[] robotDataArray = this.robots.getRobots();
        int n = robotDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            RobotData r = robotDataArray[n2];
            this.movies.get(r.getName()).add(this.factory.getNullPattern());
            ++n2;
        }
    }

    @Override
    public void draw(RGraphics grid) {
        if (!DrawMenu.getValue("Recorder", "Movie")) {
            return;
        }
        grid.setColor(Colors.BLUE);
        RobotData[] robotDataArray = this.robots.getRobots();
        int n = robotDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            RobotData r = robotDataArray[n2];
            FoldedLinkedList<E> list = this.movies.get(r.getName());
            if (!r.isDead() && list != null && list.size() > 0 && list.getFirst() instanceof Polar) {
                Polar p;
                ListIterator<E> iterator = list.listIterator(list.size());
                double x = r.getX();
                double y = r.getY();
                double h = r.getHeading();
                int i = 0;
                while (iterator.hasPrevious() && (p = (Polar)iterator.previous()) != Polar.DUMMY_PATTERN && i < 100) {
                    grid.fillOvalCenter(x -= p.getVelocity() * Utils.sin(h -= p.getDeltaHeading()), y -= p.getVelocity() * Utils.cos(h), 2.0, 2.0);
                    ++i;
                }
            }
            ++n2;
        }
    }
}

