/*
 * Decompiled with CFR 0.152.
 */
package wcsv.PowerHouse.Movement;

import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.ListIterator;
import wcsv.PowerHouse.Movement.Movement;
import wcsv.PowerHouse.Movement.MovementPredictor;
import wcsv.PowerHouse.Utilities.ForceVector;
import wcsv.PowerHouse.Utilities.SegmentationDimension;
import wcsv.PowerHouse.Utilities.Target;
import wcsv.PowerHouse.Utilities.Utilities;
import wcsv.PowerHouse.Utilities.Wave;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WaveSurfingMovement
implements Movement {
    public static final double[] offsets;
    public static final int countIndex;
    private static final int fwd = 0;
    private static final int rev = 1;
    private static final int stop = 2;
    private static int missedWaves;
    public static final int accelSegs = 3;
    private SurfPath[] paths;
    private int lastPath;
    private int nonStop;
    private double minDistance;
    private double minDistanceDelta;
    private double diveBearing;
    public Wave wave;
    public Point2D.Double loc;
    SegmentationDimension bftSegs;
    SegmentationDimension bftSegsFast;
    SegmentationDimension velocitySegs;
    SegmentationDimension velocitySegsFast;
    SegmentationDimension wallSegs;
    SegmentationDimension wallSegsFast;
    SegmentationDimension wallSegsRev;
    SegmentationDimension wallSegsRevFast;
    public double[][][][][][] buffer1;
    public double[][][][][][] buffer2;
    public double[][][] buffer3;
    public double[][][][][] buffer4;
    public double[] buffer1Data;
    public double[] buffer2Data;
    public double[] buffer3Data;
    public double[] buffer4Data;
    public double[] noSegData;

    public void setSegments(Target t, Wave w) {
        int bft = SegmentationDimension.getIndex(this.bftSegs, t.distance / w.velocity);
        int bftFast = SegmentationDimension.getIndex(this.bftSegsFast, t.distance / w.velocity);
        int vel = SegmentationDimension.getIndex(this.velocitySegs, Math.abs(t.lateralVelocity));
        int velFast = SegmentationDimension.getIndex(this.velocitySegsFast, Math.abs(t.lateralVelocity));
        int wall = SegmentationDimension.wallIndex(w, this.wallSegs);
        int wallFast = SegmentationDimension.wallIndex(w, this.wallSegsFast);
        int revWall = SegmentationDimension.wallIndex(w, this.wallSegsRev);
        int revWallFast = SegmentationDimension.wallIndex(w, this.wallSegsRevFast);
        int accel = Utilities.getAccelIndex(t);
        this.buffer1Data = this.buffer1[bft][accel][vel][wall][revWall];
        this.buffer2Data = this.buffer2[bftFast][accel][velFast][wallFast][revWallFast];
        this.buffer3Data = this.buffer3[bft][vel];
        this.buffer4Data = this.buffer4[bftFast][velFast][wallFast][revWallFast];
    }

    public double[] getBuffer(Target t, Wave w) {
        this.setSegments(t, w);
        double[] sumBuffer = new double[offsets.length];
        int i = 0;
        while (i < sumBuffer.length) {
            int n = i;
            sumBuffer[n] = sumBuffer[n] + this.buffer1Data[i] / Math.max(this.buffer1Data[offsets.length], 1.0);
            int n2 = i;
            sumBuffer[n2] = sumBuffer[n2] + this.buffer2Data[i] / Math.max(this.buffer2Data[offsets.length], 1.0);
            int n3 = i;
            sumBuffer[n3] = sumBuffer[n3] + this.buffer3Data[i] / Math.max(this.buffer3Data[offsets.length], 1.0);
            int n4 = i;
            sumBuffer[n4] = sumBuffer[n4] + this.buffer4Data[i] / Math.max(this.buffer4Data[offsets.length], 1.0);
            int n5 = i;
            sumBuffer[n5] = sumBuffer[n5] + this.noSegData[i] / Math.max(this.noSegData[offsets.length], 1.0);
            ++i;
        }
        return sumBuffer;
    }

    public void update(Target enemy, Target newData, Point2D.Double hitLocation, Wave w) {
        if (w == null) {
            System.out.println("No Matching Wave: Distance = " + Utilities.distance(hitLocation, enemy.location));
            ++missedWaves;
            return;
        }
        this.setSegments(w.targetRobot, w);
        double bearingChange = w.computeCentralBearingChange(hitLocation) * (double)w.targetRobot.orbitDir;
        double maxEscapeAngle = Utilities.maxEscapeAngle_Velocity(w.velocity);
        int index = Utilities.getSegment(bearingChange / maxEscapeAngle, offsets);
        int i = 0;
        while (i < offsets.length) {
            double value = 1.0 / (Math.pow(Math.abs(index - i), 1.5) + 1.0);
            this.buffer1Data[i] = Utilities.rollingAvg(this.buffer1Data[i], value, this.buffer1Data[countIndex], 1.0);
            this.buffer2Data[i] = Utilities.rollingAvg(this.buffer2Data[i], value, this.buffer2Data[countIndex], 1.0);
            this.buffer3Data[i] = Utilities.rollingAvg(this.buffer3Data[i], value, this.buffer3Data[countIndex], 1.0);
            this.buffer4Data[i] = Utilities.rollingAvg(this.buffer4Data[i], value, this.buffer4Data[countIndex], 1.0);
            this.noSegData[i] = Utilities.rollingAvg(this.noSegData[i], value, this.noSegData[countIndex], 0.8);
            ++i;
        }
        int n = countIndex;
        this.buffer1Data[n] = this.buffer1Data[n] + 1.0;
        int n2 = countIndex;
        this.buffer2Data[n2] = this.buffer2Data[n2] + 1.0;
        int n3 = countIndex;
        this.buffer3Data[n3] = this.buffer3Data[n3] + 1.0;
        int n4 = countIndex;
        this.buffer4Data[n4] = this.buffer4Data[n4] + 1.0;
        int n5 = countIndex;
        this.noSegData[n5] = this.noSegData[n5] + (double)3;
    }

    public ForceVector computeNextMove(Target enemy, Target me, LinkedList waves) {
        boolean rDive;
        if (!waves.isEmpty()) {
            Wave w = Wave.getClosestWave(me.location, waves);
            double bearingOffset = 1.5707963267948966 * (Utilities.distance(me.location, w.sourceRobot.location) / this.minDistance);
            this.paths[0] = new SurfPath(100.0, Utilities.absoluteAngle(Utilities.absoluteAngleToPoint(w.sourceRobot.location, me.location) + bearingOffset * (double)me.orbitDir), 8.0, me, enemy, w, me.orbitDir);
            this.paths[1] = new SurfPath(100.0, Utilities.absoluteAngle(Utilities.absoluteAngleToPoint(w.sourceRobot.location, me.location) + bearingOffset * (double)(-me.orbitDir)), 8.0, me, enemy, w, -me.orbitDir);
            this.paths[2] = new SurfPath(0.0, me.heading, 0.0, me, enemy, w, this.paths[this.lastPath].orbital);
            ListIterator it = waves.listIterator();
            while (it.hasNext()) {
                w = (Wave)it.next();
                double[] buff = this.getBuffer(w.targetRobot, w);
                this.paths[0].addDanger(w, me, enemy, buff);
                this.paths[1].addDanger(w, me, enemy, buff);
                this.paths[2].addDanger(w, me, enemy, buff);
            }
        } else {
            double bearingOffset = 1.5707963267948966 * (enemy.distance / this.minDistance);
            this.paths[0] = new SurfPath(100.0, Utilities.absoluteAngle(Utilities.absoluteAngleToPoint(enemy.location, me.location) + bearingOffset * (double)me.orbitDir), 8.0, me, enemy, me.orbitDir);
            this.paths[1] = new SurfPath(100.0, Utilities.absoluteAngle(Utilities.absoluteAngleToPoint(enemy.location, me.location) + bearingOffset * (double)(-me.orbitDir)), 8.0, me, enemy, -me.orbitDir);
            this.paths[2] = new SurfPath(0.0, this.paths[this.lastPath].path.bearing, 0.0, me, enemy, this.paths[this.lastPath].orbital);
        }
        boolean bl = false;
        if (this.paths[0].diveDanger > 0.0) {
            bl = true;
        }
        boolean fDive = bl;
        boolean bl2 = false;
        if (this.paths[1].diveDanger > 0.0) {
            bl2 = rDive = true;
        }
        if (enemy.distance <= 200.0) {
            this.paths[2].diveDanger = Double.MAX_VALUE;
            this.paths[2].danger = Double.MAX_VALUE;
        }
        if (fDive && rDive) {
            this.lastPath = this.lastPath == 0 ? (this.paths[0].diveDanger <= this.paths[1].diveDanger ? 0 : 1) : (this.paths[0].diveDanger < this.paths[1].diveDanger ? 0 : 1);
        } else if (fDive && !rDive) {
            this.lastPath = this.paths[1].danger <= this.paths[2].danger ? 1 : 2;
            this.nonStop = 1;
        } else if (!fDive && rDive) {
            this.lastPath = this.paths[0].danger <= this.paths[2].danger ? 0 : 2;
            this.nonStop = 0;
        } else {
            this.lastPath = this.getBestPath(this.lastPath);
        }
        if (this.lastPath != 2) {
            this.nonStop = this.lastPath;
        }
        return this.paths[this.lastPath].path;
    }

    public int getBestPath(int last) {
        int best = last;
        int i = 0;
        while (i < this.paths.length) {
            if (this.paths[i].danger < this.paths[best].danger) {
                best = i;
            }
            ++i;
        }
        return best;
    }

    public double getDiveDanger(double moveBearing, double enemyBearing) {
        double d = 0.0;
        double dive = Math.abs(Utilities.relativeAngle(enemyBearing - moveBearing));
        if ((dive = Math.max(dive, 0.01)) < this.diveBearing) {
            d += this.diveBearing / dive;
        }
        return d;
    }

    public void reset(double enemyDamagePerRound) {
        int n = 0;
        if (Math.random() < 0.5) {
            n = 1;
        }
        this.lastPath = this.nonStop = 1 - n;
        System.out.println("Total Missed Waves: " + missedWaves);
        this.minDistance = enemyDamagePerRound > 50.0 ? 800.0 : (enemyDamagePerRound > 35.0 ? 600.0 : (enemyDamagePerRound > 20.0 ? 500.0 : 400.0));
    }

    private final /* synthetic */ void this() {
        this.lastPath = 0;
        this.nonStop = 0;
        this.minDistance = 500.0;
        this.minDistanceDelta = 30.0;
        this.diveBearing = Math.toRadians(40.0);
        this.wave = null;
        this.loc = null;
        this.bftSegs = new SegmentationDimension(15.0, 55.0, 3);
        this.bftSegsFast = new SegmentationDimension(20.0, 40.0, 1);
        this.velocitySegs = new SegmentationDimension(0.0, 6.4, 4);
        this.velocitySegsFast = new SegmentationDimension(2, 6.0, 1);
        this.wallSegs = new SegmentationDimension(Math.toRadians(5), Math.toRadians(45.0), 4);
        this.wallSegsFast = new SegmentationDimension(Math.toRadians(10.0), Math.toRadians(30.0), 2);
        this.wallSegsRev = new SegmentationDimension(-Math.toRadians(10.0), -Math.toRadians(30.0), 2);
        this.wallSegsRevFast = new SegmentationDimension(-Math.toRadians(15.0), -Math.toRadians(30.0), 1);
        this.buffer1 = new double[this.bftSegs.segments + 1][3][this.velocitySegs.segments + 1][this.wallSegs.segments + 1][this.wallSegsRev.segments + 1][offsets.length + 1];
        this.buffer2 = new double[this.bftSegsFast.segments + 1][3][this.velocitySegsFast.segments + 1][this.wallSegsFast.segments + 1][this.wallSegsRevFast.segments + 1][offsets.length + 1];
        this.buffer3 = new double[this.bftSegs.segments + 1][this.velocitySegs.segments + 1][offsets.length + 1];
        this.buffer4 = new double[this.bftSegsFast.segments + 1][this.velocitySegsFast.segments + 1][this.wallSegsFast.segments + 1][this.wallSegsRevFast.segments + 1][offsets.length + 1];
        this.noSegData = new double[offsets.length + 1];
    }

    public WaveSurfingMovement() {
        this.this();
        this.paths = new SurfPath[3];
    }

    static {
        double[] dArray = new double[41];
        dArray[0] = -1.0;
        dArray[1] = -0.95;
        dArray[2] = -0.9;
        dArray[3] = -0.85;
        dArray[4] = -0.8;
        dArray[5] = -0.75;
        dArray[6] = -0.7;
        dArray[7] = -0.65;
        dArray[8] = -0.6;
        dArray[9] = -0.55;
        dArray[10] = -0.5;
        dArray[11] = -0.45;
        dArray[12] = -0.4;
        dArray[13] = -0.35;
        dArray[14] = -0.3;
        dArray[15] = -0.25;
        dArray[16] = -0.2;
        dArray[17] = -0.15;
        dArray[18] = -0.1;
        dArray[19] = -0.05;
        dArray[21] = 0.05;
        dArray[22] = 0.1;
        dArray[23] = 0.15;
        dArray[24] = 0.2;
        dArray[25] = 0.25;
        dArray[26] = 0.3;
        dArray[27] = 0.35;
        dArray[28] = 0.4;
        dArray[29] = 0.45;
        dArray[30] = 0.5;
        dArray[31] = 0.55;
        dArray[32] = 0.6;
        dArray[33] = 0.65;
        dArray[34] = 0.7;
        dArray[35] = 0.75;
        dArray[36] = 0.8;
        dArray[37] = 0.85;
        dArray[38] = 0.9;
        dArray[39] = 0.95;
        dArray[40] = 1.0;
        offsets = dArray;
        countIndex = offsets.length;
        missedWaves = 0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SurfPath {
        public ForceVector path;
        public Point2D.Double destination;
        public double diveDanger;
        public double danger;
        public double orbital;
        public int bin;

        public void addDanger(Wave w, Target me, Target enemy, double[] buffer) {
            this.destination = MovementPredictor.projectLocation(w, me, enemy, this.orbital, WaveSurfingMovement.this.minDistance, this.path.velocity);
            this.bin = Math.min(Utilities.getSegment(w.computeCentralBearingChange(this.destination) * (double)w.targetRobot.orbitDir / Utilities.maxEscapeAngle_Velocity(w.velocity), offsets), offsets.length - 1);
            this.danger += buffer[this.bin] / Utilities.square(w.distanceToPoint(me.location));
        }

        private final /* synthetic */ void this() {
            this.orbital = 1.0;
        }

        public SurfPath(double dist, double bearing, double velocity, Target me, Target enemy, Wave w, double orbit) {
            this.this();
            this.path = new ForceVector(dist, MovementPredictor.wallCorrectedAngle(bearing, me.location, orbit), velocity);
            this.danger = 0.0;
            this.diveDanger = this.path.bearing != bearing ? WaveSurfingMovement.this.getDiveDanger(this.path.bearing, enemy.absoluteBearing) : 0.0;
            this.orbital = orbit;
        }

        public SurfPath(double dist, double bearing, double velocity, Target me, Target enemy, double orbit) {
            this.this();
            this.path = new ForceVector(dist, MovementPredictor.wallCorrectedAngle(bearing, me.location, orbit), velocity);
            this.destination = Utilities.projectPoint(me.location, this.path.bearing, velocity);
            this.danger = this.diveDanger = 1.0 / Utilities.distance(this.destination, enemy.location);
            this.orbital = orbit;
        }
    }
}

