/*
 * Decompiled with CFR 0.152.
 */
package dcs;

public class Stampede_TargetData {
    public String name;
    public double heading;
    public double speed;
    public double energy;
    public double distance;
    public double uncorrectedBearing;
    public double bearing;
    public double x;
    public double y;
    public double tr;
    public boolean refresh;
    public double headingOld;
    public long thisScanTime;
    public long lastScanTime;
    public double oldEnergy;
    public double oldSpeed;
    public double averageX;
    public double averageY;
    public double averageSpeed;
    public double averageTR;
    private int readings;

    public void refreshData(double h, double s, double e, double d, double b, double x1, double y1, long time, double x2, double y2) {
        this.distance = d;
        this.uncorrectedBearing = b;
        this.bearing = Stampede_TargetData.absbearing(x2, y2, x1, y1);
        this.x = x1;
        this.y = y1;
        this.refresh = false;
        this.headingOld = this.heading;
        this.heading = h;
        this.lastScanTime = this.thisScanTime;
        this.thisScanTime = time;
        this.oldEnergy = this.energy;
        this.energy = e;
        this.tr = this.turnRate();
        this.oldSpeed = this.speed;
        this.speed = s;
        this.averageX = Stampede_TargetData.rollingAvg(this.averageX, this.x, this.readings, time);
        this.averageY = Stampede_TargetData.rollingAvg(this.averageY, this.y, this.readings, time);
        this.averageSpeed = Stampede_TargetData.rollingAvg(this.averageSpeed, this.speed, this.readings, time);
        this.averageTR = Stampede_TargetData.rollingAvg(this.averageTR, this.tr, this.readings, time);
        if (this.readings <= 30) {
            ++this.readings;
        }
    }

    public static double calcX(double x1, double bearing, double distance) {
        return x1 + Math.sin(Math.toRadians(bearing)) * distance;
    }

    public static double calcY(double y1, double bearing, double distance) {
        return y1 + Math.cos(Math.toRadians(bearing)) * distance;
    }

    public static double calcDistance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public double calcTime(double firePower) {
        return this.distance / (20.0 - (double)3 * firePower);
    }

    public double calcTime(double firePower, double x, double y, double nx, double ny) {
        return Stampede_TargetData.calcDistance(x, y, nx, ny) / (20.0 - (double)3 * firePower);
    }

    public double calcNextX_Linear(double time, int direction) {
        return this.x + Math.sin(Math.toRadians(this.heading)) * this.speed * (double)direction * time;
    }

    public double calcNextY_Linear(double time, int direction) {
        return this.y + Math.cos(Math.toRadians(this.heading)) * this.speed * (double)direction * time;
    }

    public double calcNextX_LinearCircular(double time, int direction) {
        if (this.tr == 0.0) {
            return this.calcNextX_Linear(time, direction);
        }
        double radius = this.speed / this.tr;
        return this.x - radius * (Math.cos(Math.toRadians(this.heading) + time * this.tr) - Math.cos(Math.toRadians(this.heading))) * (double)direction;
    }

    public double calcNextY_LinearCircular(double time, int direction) {
        if (this.tr == 0.0) {
            return this.calcNextY_Linear(time, direction);
        }
        double radius = this.speed / this.tr;
        return this.y + radius * (Math.sin(Math.toRadians(this.heading) + time * this.tr) - Math.sin(Math.toRadians(this.heading))) * (double)direction;
    }

    public double calcNextX_Linear(double s, double time, int direction) {
        return this.x + Math.sin(Math.toRadians(this.heading)) * s * (double)direction * time;
    }

    public double calcNextY_Linear(double s, double time, int direction) {
        return this.y + Math.cos(Math.toRadians(this.heading)) * s * (double)direction * time;
    }

    public double calcNextX_LinearCircular(double s, double time, int direction, double turn) {
        if (Math.abs(turn) < 0.1) {
            return this.calcNextX_Linear(s, time, direction);
        }
        double radius = s / turn;
        return this.x - radius * (Math.cos(Math.toRadians(this.heading) + time * this.tr) - Math.cos(Math.toRadians(this.heading))) * (double)direction;
    }

    public double calcNextY_LinearCircular(double s, double time, int direction, double turn) {
        if (Math.abs(turn) < 0.1) {
            return this.calcNextY_Linear(s, time, direction);
        }
        double radius = s / turn;
        return this.y + radius * (Math.sin(Math.toRadians(this.heading) + time * this.tr) - Math.sin(Math.toRadians(this.heading))) * (double)direction;
    }

    public static double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public static double normalAbsoluteAngle(double angle) {
        if (angle >= 0.0 && angle < 360.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle >= 360.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public static double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        if (xo > 0.0 && yo > 0.0) {
            return Math.toDegrees(Math.asin(xo / h));
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.toDegrees(Math.PI - Math.asin(xo / h));
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.toDegrees(Math.PI + Math.asin(-xo / h));
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.toDegrees(Math.PI * 2 - Math.asin(-xo / h));
        }
        return 0.0;
    }

    public double turnRate() {
        if (this.thisScanTime - this.lastScanTime == 0L) {
            return 0.0;
        }
        return Math.toRadians(this.heading - this.headingOld) / (double)(this.thisScanTime - this.lastScanTime);
    }

    public static double rollingAvg(double value, double newEntry, double n, long weighting) {
        return (value * n + newEntry * (double)weighting) / (n + (double)weighting);
    }

    public double lateralVelocity(double s) {
        return s * Math.sin(Math.toRadians(this.heading) - Math.toRadians(this.bearing));
    }

    public double advancingVelocity(double s) {
        return -Math.cos(Math.toRadians(this.heading) - Math.toRadians(this.bearing)) * s;
    }

    public double calcAcceleration() {
        return (this.speed - this.oldSpeed) / (double)(this.thisScanTime - this.lastScanTime);
    }

    public Stampede_TargetData(String n, double h, double s, double e, double d, double b, double x1, double y1, long time, double x2, double y2) {
        this.name = n;
        this.heading = this.headingOld = h;
        this.speed = this.oldSpeed = s;
        this.energy = e;
        this.distance = d;
        this.uncorrectedBearing = b;
        this.bearing = Stampede_TargetData.absbearing(x2, y2, x1, y1);
        this.x = x1;
        this.y = y1;
        this.refresh = false;
        this.thisScanTime = this.lastScanTime = time;
        this.oldEnergy = this.energy = e;
        this.averageX = this.x;
        this.averageY = this.y;
        this.averageSpeed = this.speed;
        this.readings = 1;
        this.tr = 0.0;
    }
}

