/*
 * Decompiled with CFR 0.152.
 */
package kronenthaler.common;

import java.awt.geom.Point2D;
import kronenthaler.common.Util;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class MyAdvancedRobot
extends AdvancedRobot {
    private double oldEnemyHeading;

    public void goTo(double x, double y) {
        this.setTurnRightRadians(Util.calculateBearingToXYRadians(this.getX(), this.getY(), this.getHeadingRadians(), x, y));
        this.setAhead(Util.distance(this.getX(), this.getY(), x, y));
    }

    public void goTo(double x, double y, double direction) {
        this.setTurnRightRadians(Util.calculateBearingToXYRadians(this.getX(), this.getY(), this.getHeadingRadians(), x, y));
        this.setAhead(direction);
    }

    public void linearTargeting(double myX, double myY, double bulletPower, double enemyX, double enemyY, double enemyHeading, double enemyVelocity) {
        double predictedY;
        double predictedX;
        block1: {
            double deltaTime = 0.0;
            double battleFieldHeight = this.getBattleFieldHeight();
            double battleFieldWidth = this.getBattleFieldWidth();
            predictedX = enemyX;
            predictedY = enemyY;
            do {
                double d;
                deltaTime += 1.0;
                if (!(d * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY))) break block1;
                predictedY += Math.cos(enemyHeading) * enemyVelocity;
            } while (!((predictedX += Math.sin(enemyHeading) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0));
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getX(), predictedY - this.getY()));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
        this.fire(bulletPower);
    }

    public void circularTargeting(double myX, double myY, double bulletPower, double enemyX, double enemyY, double enemyHeading, double enemyVelocity) {
        double predictedY;
        double predictedX;
        block1: {
            double enemyHeadingChange = enemyHeading - this.oldEnemyHeading;
            this.oldEnemyHeading = enemyHeading;
            double deltaTime = 0.0;
            double battleFieldHeight = this.getBattleFieldHeight();
            double battleFieldWidth = this.getBattleFieldWidth();
            predictedX = enemyX;
            predictedY = enemyY;
            do {
                double d;
                deltaTime += 1.0;
                if (!(d * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY))) break block1;
                predictedY += Math.cos(enemyHeading) * enemyVelocity;
            } while (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0));
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getX(), predictedY - this.getY()));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
        this.fire(bulletPower);
    }
}

