/*
 * Enemy.java
 *
 * Created on 15 maart 2004, 11:19
 */

package vic;

/**
 *
 * @author  vic
 */
public class Enemy extends WaveManager
{
    public GuessFactory log;
    public Situation lastSituation, currentSituation;
    public double currentAim, lastAim, lastMeX, lastMeY;
    public double FX,FY,RX,RY;  //blind man's sticks
    double Category;

    Enemy()
    {
        log = new GuessFactory();
        log.setBins(75);
    }

    void postRound()
    {
        log.reorder();
    }
    
    void clear()
    {
        super.clear();
    }
    
    void fired(double Power, double meX, double meY)
    {
        lastSituation   = currentSituation;
        lastAim         = currentAim;
        lastMeX         = meX;
        lastMeY         = meY;
    }
    
    void fireWave(double Power, double meX, double meY)
    {
        //blind mans sticks:
        double maxEscapeAngle = Math.asin(8/(20.0D - 3.0D * Power));
        double Distance = getDistance(meX, meY, enemyX, enemyY);
        double StickDistance = Distance * (maxEscapeAngle / (Math.toRadians(90) - maxEscapeAngle));
        double StickTime;
        //front stick:
        StickTime = (StickDistance - (((8.0D - currentVelocity)/2.0D)*(8.0D - currentVelocity))) / 8.0D;
        FX = enemyX + (Math.sin(currentHeading) * 8.0D * StickTime);
        FY = enemyY + (Math.cos(currentHeading) * 8.0D * StickTime);
        
        double FWX,FWY,RWX,RWY;
        double Xmin=18, Xmax=getBattlefieldWidth()-18;
        double Ymin=18, Ymax=getBattlefieldHeight()-18;

        //calculate where front stick hits the wall.
        double X=99999,Y=99999;
        if(FX < Xmin) X=Xmin;
        else if(FX > Xmax) X=Xmax;
        if(X!=99999)
        {
            Y=enemyY + ((FY-enemyY) * ((X-enemyX)/(FX-enemyX)));
            if(Y < Ymin | Y > Ymax)X=Y=99999;
        }
        if(X==99999)
        {
            if(FY < Ymin) Y=Ymin;
            else if(FY > Ymax) Y=Ymax;
            if(Y!=99999)
            {
                X=enemyX + ((FX-enemyX) * ((Y-enemyY)/(FY-enemyY)));
                if(X < Xmin | X > Xmax) X=Y=99999;
            }
        }
        FWX=X;
        FWY=Y;
        //System.out.println("X=" + X + " Y=" + Y);
        //System.out.println("angle=" + maxEscapeAngle + " D=" + Distance + " DR=" + StickDistance + " Time=" + StickTime);
        //rear stick:
        StickTime = (StickDistance - Math.pow((currentVelocity/2.0D),2) - 32) / 8.0D;
        RX = enemyX + (Math.sin(reverseHeading(currentHeading)) * 8.0D * StickTime);
        RY = enemyY + (Math.cos(reverseHeading(currentHeading)) * 8.0D * StickTime);
        //System.out.println(" FX=" + FX + " FY=" + FY + " RX=" + FR + " RY=" + RY);

        //calculate where rear stick hits the wall.
        X=Y=99999;
        if(RX < Xmin) X=Xmin;
        else if(RX > Xmax) X=Xmax;
        if(X!=99999)
        {
            Y=enemyY + ((RY-enemyY) * ((X-enemyX)/(RX-enemyX)));
            if(Y < Ymin | Y > Ymax)X=Y=99999;
        }
        if(X==99999)
        {
            if(RY < Ymin) Y=Ymin;
            else if(RY > Ymax) Y=Ymax;
            if(Y!=99999)
            {
                X=enemyX + ((RX-enemyX) * ((Y-enemyY)/(RY-enemyY)));
                if(X < Xmin | X > Xmax) X=Y=99999;
            }
        }
        RWX=X;
        RWY=Y;
        //System.out.println("X=" + X + " Y=" + Y);
        
        //categories:
        /*
         *1 no walls
         *2 1 wall
         *3 1 wall corner
         *4 2 wall corner
         *5 rear wall
         **/
        double FrontWallRatio=1, RearWallRatio=1;
        if(outside(FX,FY))
        {
            FrontWallRatio = getDistance(enemyX, enemyY, FWX, FWY) / getDistance(enemyX, enemyY, FX, FY);
            if(outside(RX,RY))
            {
                RearWallRatio = getDistance(enemyX, enemyY, RWX, RWY) / getDistance(enemyX, enemyY, RX, RY);
                Category = 4;
            }
            else
            {
                /*
                if(cornerDistance() < 200)
                {
                    Category = 3;
                }
                else
                {
                    Category = 2;
                }
                 **/
                Category = 2;
            }
        }
        else
        {
            if(outside(RX,RY))
            {
                RearWallRatio = getDistance(enemyX, enemyY, RWX, RWY) / getDistance(enemyX, enemyY, RX, RY);
                Category = 5;
            }
            else
            {
                Category = 1;
            }
        }
        
        Situation situation = new Situation();
        situation.setDimension(0, getBulletTravelTime(Power, meX, meY), 0   , 70 ); //max BTT based on power 1.9 at distance 1000
        situation.setDimension(1, getMyBearingDegrees(meX, meY)       , -180, 180);
        situation.setDimension(2, currentVelocity                     , -8  , 8  );
        situation.setDimension(3, getMyBearingDegrees(getBattlefieldWidth()/2, getBattlefieldHeight()/2), -180, 180);
        situation.setDimension(4, Math.sqrt(wallDistance())  , 0, Math.sqrt(getBattlefieldHeight()/2));
        situation.setDimension(5, Math.sqrt(cornerDistance()), 0, Math.sqrt(500));
        situation.setDimension(6, Math.sqrt(Math.min(127, streakTime)), 0, Math.sqrt(127));
        situation.setDimension(7, Power, 0, 3);
        situation.setDimension(8, lastVelocity, -8, 8);
        situation.setDimension(9, Category, 1, 5);
        situation.setDimension(10, FrontWallRatio, 0, 1);
        situation.setDimension(11, RearWallRatio, 0, 1);
        //System.out.println("category " + situation.getDimension(9));
        
        currentSituation = situation;
        startWave(situation, Power, meX, meY);
    }
    
    boolean outside(double x, double y)
    {
        if (x < getHalfRobotWidth()                         ) return true;
        if (x > getBattlefieldWidth()  - getHalfRobotWidth()) return true;
        if (y < getHalfRobotWidth()                         ) return true;
        if (y > getBattlefieldHeight() - getHalfRobotWidth()) return true;
        return false;
    }
        
    double aim(double Power, double meX, double meY)
    {
        currentAim = log.aim(Power, currentSituation, enemyX, enemyY, currentHeading, meX, meY);       
        return currentAim;
    }

    double wallDistance()
    {
        double result, best=1000;
        result = enemyX;
        if(result < best) best = result;
        result = getBattlefieldWidth()-enemyX;
        if(result < best) best = result;
        result = enemyY;
        if(result < best) best = result;
        result = getBattlefieldHeight()-enemyY;
        if(result < best) best = result;
        return best;
    }
    
    double cornerDistance()
    {
        double result, best=1000;
        result = getDistance(0,0);
        if(result < best) best = result;
        result = getDistance(getBattlefieldWidth(),0);
        if(result < best) best = result;
        result = getDistance(0,getBattlefieldHeight());
        if(result < best) best = result;
        result = getDistance(getBattlefieldWidth(),getBattlefieldHeight());
        if(result < best) best = result;
        return best;
    }
    
    double getBulletTravelTime(double Power, double meX, double meY)
    {
        double V = 20.0D - 3.0D * Power;
        double D = Math.sqrt(Math.pow(meX-enemyX, 2) + Math.pow(meY-enemyY, 2));
        double F = (D - V) / V;
        return Math.round(F);
    }
    
    double getMyBearingDegrees(double meX, double meY)
    {
        double result = Math.toDegrees(getAbsoluteAngle(enemyX, enemyY, meX, meY) - currentHeading);
        if (result < -180) result += 360;
        if (result > 180) result -= 360;
        return result;
    }

    void processWave(Wave wave)
    {
        log.addObservation(wave.getSituation(), calcDeltaDistance(wave), calcDeltaHeading(wave));
    }
    
    double calcDeltaHeading(Wave wave)
    {
        return getAbsoluteAngle(wave.getEnemyX(), wave.getEnemyY(), enemyX, enemyY) - wave.getEnemyHeading();
    }
    
    double calcDeltaDistance(Wave wave)
    {
        return Math.sqrt(Math.pow(wave.getEnemyX() - enemyX, 2) + Math.pow(wave.getEnemyY() - enemyY, 2));
    }
}
