package matt;

import matt.Utils;
import matt.AntiGravEngine;

import robocode.*;

import java.awt.Color;
import java.awt.geom.*;
import java.lang.String;
import java.lang.Object;
import java.util.Vector;

public class BlueMind extends AdvancedRobot {
    static Vector velocityMap;
    
    double[] vArray = new double[321];
    
    double direction=1;
    double battleFieldHeight=0;
    double battleFieldWidth=0;
    
    double lastH=0;
    double lastScanT=0;
    
    AntiGravEngine ag_enemy = new AntiGravEngine();
    
    public void run() {
        battleFieldHeight=getBattleFieldHeight();
        battleFieldWidth=getBattleFieldWidth();
        
        for(int flush=0;flush<321;flush++){
            vArray[flush]=0;
        }
        
        if(getRoundNum()==0){
            velocityMap = new Vector();
        }
        
        ag_enemy.setForce(125);
        
        setColors(new Color(0,0,255),new Color(0,0,255),new Color(0,0,255));
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        
        while(true){
            setTurnRadarRight(360);
            execute();
        }
    }
    
    public void onScannedRobot(ScannedRobotEvent e){
        Velocity enemyV = new Velocity(e.getVelocity());
        velocityMap.addElement(enemyV);
        
        for(int flush=0;flush<321;flush++){
            vArray[flush]=0;
        }
        
        Velocity temp = new Velocity(0);
        double temp2=0;
        out.println(velocityMap.size());
        for(int index=0; index < velocityMap.size(); index++){
            temp = (Velocity)velocityMap.get(index);
            temp2 = (temp.v+8)*20;
            vArray[(int)temp2]++;
        }
        
        Count target = new Count();
        for(int scan=0; scan < 321; scan++){
            if(vArray[scan]>target.threshHold){
                target.value = (scan/20)-8;
                target.threshHold=vArray[scan];
            }
        }
        
        double power = (2200/Math.pow(e.getDistance(),1.15));
	if(power>=getEnergy()){
            power = getEnergy()-.1;
        }
        if(power>3)
            power=3;
        if(power<.1)
            power=.1;
        double dist = e.getDistance();
        double playerX = getX();
        double playerY = getY();
        double bearing = (Math.toRadians(getHeading())+e.getBearingRadians())%(2*Math.PI);
        double enemyX = playerX + (dist * Math.sin(bearing));
        double enemyY = playerY + (dist * Math.cos(bearing));
        double bulletV = 20 - 3 * power;
        double enemyH = e.getHeadingRadians();
        enemyH += (enemyH-lastH)/(getTime()-lastScanT);
        double gunH = getGunHeading();
        double predictD = e.getDistance();
        double predictX = enemyX;
        double predictY = enemyY;
        double rawV = target.value;
        double theta = 0;
        double time2 = 0;
        double t=0;
        double timeTheta = 0;
        double time0=dist/bulletV;
        int deltaT = 0;
        int others = getOthers();
        double lastDiff=Double.POSITIVE_INFINITY;
        for(deltaT=-1000;deltaT<=1000;deltaT++){
            t = time0 + deltaT;
            predictX = enemyX+((rawV*t)*Math.sin(enemyH));
            predictY = enemyY+((rawV*t)*Math.cos(enemyH));
            if (predictX < 20){
                predictX = 20;
            }else if(predictX > battleFieldWidth-20){
                predictX = battleFieldWidth-20;
            }
            if (predictY < 20){
                predictY = 20;
            }else if(predictY > battleFieldHeight-20){
                predictY = battleFieldHeight-20;
            }
            predictD = Point2D.Double.distance(playerX,playerY,predictX,predictY);
            timeTheta = Utils.absoluteBearing(playerX, playerY, predictX, predictY);
            timeTheta = Utils.normalizeBearing(timeTheta - gunH);
            time2 = (predictD / bulletV) + (timeTheta / 20);
            if(Math.abs(t-time2) <= lastDiff){
                theta = Utils.absoluteBearing(playerX, playerY, predictX, predictY);
                theta = Utils.normalizeBearing(theta-gunH);
                lastDiff = Math.abs(t-time2);
            }
        }
        turnGunRight(Utils.normalizeBearing(theta));
        
        lastH = enemyH;
        lastScanT = getTime();
        
        if(getEnergy()>0.2)
            fire(power);
        
        ag_enemy.setLocation(enemyX,enemyY);
        ag_enemy.setForce(125);
        
        double myHeading = getHeading();
        double myBearing = e.getBearing();
        double myBearingI = e.getBearing()+180;
        double aheadDist = 100;
        double preT=0;
        double turnAmt=0;
        double newX=0;
        double newY=0;
        double lowForce=Double.POSITIVE_INFINITY;
        double turnTo = 0;
        double tempForce=0;
        double amyX = getX();
        double amyY = getY();
        double raise=2.5;
        for(turnAmt= -90;turnAmt<=180;turnAmt+=.01){
            if(Math.abs((myHeading+turnAmt)-myBearing)>40 && Math.abs((myHeading+turnAmt)-myBearingI)>40 && Math.abs(turnAmt)>40 && turnAmt!=0){
                tempForce=0;
                newX = playerX + ((aheadDist*direction) * Math.sin(Math.toRadians(myHeading+turnAmt+preT)));
                newY = playerY + ((aheadDist*direction) * Math.cos(Math.toRadians(myHeading+turnAmt+preT)));
                tempForce += ag_enemy.getActingForcePoint(newX,newY);
                tempForce += 125/(Math.pow(newX,raise));
                tempForce += 125/(Math.pow(newY,raise));
                tempForce += 125/(Math.pow(battleFieldWidth-newX,raise));
                tempForce += 125/(Math.pow(battleFieldHeight-newY,raise));
                if(tempForce<lowForce){
                    lowForce=tempForce;
                    turnTo = turnAmt+preT;
                }else if(tempForce == lowForce && Math.abs(turnAmt+preT) < Math.abs(turnTo+preT)){
                    lowForce=tempForce;
                    turnTo = turnAmt+preT;
                }
            }
        }
        turnTo = Utils.normalizeBearing(turnTo);
        double buffer=75;
        newX = playerX + ((aheadDist*direction) * Math.sin(Math.toRadians(myHeading+turnTo)));
        newY = playerY + ((aheadDist*direction) * Math.cos(Math.toRadians(myHeading+turnTo)));
        if(newX<buffer||newY<buffer||newX>battleFieldWidth-buffer||newY>battleFieldHeight-buffer||Point2D.distance(newX,newY,enemyX,enemyY)<buffer)
            direction *= -1;
        
        setTurnRight(turnTo);
        setAhead(aheadDist*direction);
        execute();
    }
    
    public void onHitWall(HitWallEvent e){
        direction *= -1;
    }
    
    public void onHitRobot(HitRobotEvent e){
        direction *= -1;
    }
}

class Velocity{
    public double v;
    Velocity(double vnew){
        this.v = vnew;
    }
}

class Count{
    public double threshHold;
    public double value;
    Count(){
        this.threshHold=Double.NEGATIVE_INFINITY;
        this.value = 0;
    }
}