package pfvicm;
import robocode.*;
import java.awt.Color;
import robocode.util.*;
import java.awt.geom.*;

/*
 * Sobieski - PFVICM 7.2.3
 */
public class Sobieski extends AdvancedRobot
{
	double dir = 1;
    static final double d = 150;
	private int timeSinceLastScan = 10;
	static double enemyAbsoluteBearing;
	public void run() {
		setColors(Color.cyan,Color.blue,Color.green);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		///wake();
		do {
        doScanner();
        execute();
		}
		while(true);	
		}
	public void onRobotDeath(RobotDeathEvent e) {
			//wake();
		}
	public void wake() {
		setTurnRadarRight(Double.POSITIVE_INFINITY);
	}
	public void onScannedRobot(ScannedRobotEvent e) {
		enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
    	timeSinceLastScan = 0;
		if(getDistanceRemaining() == 0){
			    dir=-dir;
			    setAhead(300*Math.random()*dir);
		    }
		    setTurnRight(e.getBearing() + 90 - 90*Math.random()*dir*
		    (e.getDistance()>d?1:-1));
		if (getEnergy()<0.1) {
			stop();
			turnGunLeft(e.getBearing());
			fire(0.1);
			resume();
		}
		else {
		double bulletPower = Math.min(3.0,getEnergy());
		double myX = getX();
		double myY = getY();
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyVelocity = e.getVelocity();
		double deltaTime = 0;
		double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
		double predictedX = enemyX, predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;	
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 18.0
				|| predictedY > battleFieldHeight - 18.0){
				predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
				break;
			}
		}
		double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
		setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
		fire(bulletPower);
	}
}
	public void doScanner() {
    timeSinceLastScan++;
    double radarOffset = Double.POSITIVE_INFINITY;
    if(timeSinceLastScan < 3) {
        radarOffset = robocode.util.Utils.normalRelativeAngle(getRadarHeadingRadians() - enemyAbsoluteBearing);
        radarOffset += sign(radarOffset) * 0.02;
    }
    setTurnRadarLeftRadians(radarOffset);
}

int sign(double v) {
    return v > 0 ? 1 : -1;
}
	public void onHitWall(HitWallEvent e) {
		//wake();
}
	public void onHitByBullet(HitByBulletEvent e) {
			//wake();
		}
}