package ph.targeting;
import ph.*;
import ph.intelligence.*;
import robocode.*;
import java.awt.geom.*;
import java.util.Vector;
import apv.*;

public class TargetingModule_GFonly extends RobotModule {
    
    private double gunCoolingRate;
    
    public TargetingModule_GFonly(ModularRobot robot) {
        this.robot=robot;
        gunCoolingRate=robot.getGunCoolingRate();
        robot.setAdjustGunForRobotTurn(true);
    }
    
    double firePower;
    
    public void execute() {
        if(robot.otherRobotsInfo.size()==0) return;
        if(Math.abs(robot.getGunTurnRemaining())>0.01) return;
        double robotGunHeading=robot.getGunHeading();
        double robotGunHeat=robot.getGunHeat();
        double robotHeading=robot.getHeading();
        double robotX=robot.getX();
        double robotY=robot.getY();
        int targetsCount=0;
        robotInfo targetInfo=null;
        long ttimeToHit=0;
        long curTime=robot.getTime();
        double aimingHeading=Double.NaN;
        double bestNeededGunRotate=Double.POSITIVE_INFINITY;
        firePower=Double.NaN;
        for(int i=0; i<robot.otherRobotsInfo.size(); i++) {
            robotInfo ri=(robotInfo)robot.otherRobotsInfo.elementAt(i);
            if(!robot.isTeammate(ri.name())) {
                int index=robot.persistentRobotNames.indexOf(ri.name());
                if(index!=-1) {
                    probotInfo pri=(probotInfo)robot.persistentRobotInfo.elementAt(index);
                    double aimingDistance=utils.dist(robotX,robotY, ri.x(),ri.y());
                    double cFirePower=firePower = calculateFirePower(ri,aimingDistance);
                    double currentAimingHeading=pri.gfAimingHeading(ri,cFirePower);
                    double neededGunRotate = utils.normalRelativeAngle(currentAimingHeading - robotGunHeading);
                    neededGunRotate = Math.abs(neededGunRotate);
                    if(neededGunRotate < bestNeededGunRotate) {
                        bestNeededGunRotate = neededGunRotate;
                        aimingHeading = currentAimingHeading;
                        firePower = cFirePower;
                    }
                }
            }
        }
        double neededGunRotate=utils.normalRelativeAngle(aimingHeading-robotGunHeading);
        //firePower=calculateFirePower(targetInfo);
        robot.setTurnGunRight(neededGunRotate);
        robot.addCustomEvent(new Condition("fireWhenReady") {
            public boolean test()  {
                if(Math.abs(robot.getGunTurnRemaining())<0.01&&robot.getGunHeat()<0.1) {
                    robot.setFire(firePower);
                    for(int i=0; i<robot.persistentRobotInfo.size(); i++) {
                        ((probotInfo)robot.persistentRobotInfo.elementAt(i)).bulletFiredToOther(firePower);
                    }
                    robot.removeCustomEvent(this);
                }
                return false;
            }
        }
        );
    }
    
    private double calculateFirePower(robotInfo ri, double distance) {
        return Math.min(robot.getEnergy() / 5, Math.min(ri.energy() / 4, bulletPower(distance)));
    }
    
    private double bulletPower(double distance) {
	return 3.0 - 1.25 * ((double)Math.min((distance / (800d / 5d)), 4d) / 5d);
    }
    
}
