package zyx.mega.targeting.melee;

import static robocode.Rules.*;

import static robocode.util.Utils.normalRelativeAngle;
import static zyx.mega.bot.Enemy.*;
import static zyx.mega.utils.Config.DEBUG;
import static zyx.mega.utils.TurnHandler.*;
import static zyx.mega.geometry.Geometry.*;
import static zyx.mega.utils.TurnHandler.me_;
import static zyx.mega.utils.TurnHandler.others_;
import static zyx.mega.utils.TurnHandler.robot_;
import static java.lang.Math.*;

import java.awt.Color;
import java.util.ArrayList;

import static java.util.Collections.*;

import zyx.debug.painter.Painter;
import zyx.mega.bot.Bot;
import zyx.mega.bot.Enemy;
import zyx.mega.bot.MeleeEnemy;
import zyx.mega.geometry.Arc;
import zyx.mega.geometry.Line;
import zyx.mega.geometry.Point;
import zyx.mega.utils.DangerSwitch;
import static zyx.mega.utils.RoboUtils.*;
import zyx.mega.utils.TurnHandler;
import static zyx.mega.utils.Range.*;
import zyx.mega.utils.Range;

public class MeleeGun {
  public void run() {
    double power = FirePower();
    double aim_angle_ = 0;
    if ( ticks_to_fire_ > 0 && ticks_to_fire_ < 10 && power > 0 ) {
      //System.out.println("  need to aim");
      Bot firing_me = PredictMyPosition(ticks_to_fire_);
      double tank_turn = firing_me.heading_ - me_.heading_;
      Range reachable = new Range(
          normalRelativeAngle(robot_.getGunHeadingRadians() + tank_turn) - PI_9 * ticks_to_fire_,
          normalRelativeAngle(robot_.getGunHeadingRadians() + tank_turn) + PI_9 * ticks_to_fire_);
      if ( DEBUG ) {
        firing_me.bbox_.Update();
        Painter.Add(firing_me.bbox_, new Color(64, 64, 64, 128));
        Painter.Add(new Arc(firing_me, 800, reachable.window_[0], reachable.window_[1]), new Color(64, 128, 252, 128));
      }
      ArrayList<DangerSwitch> array = new ArrayList<DangerSwitch>();
      long max_time = time_ - last_seen_.scan_time_;
      for ( int e = 0; e < others_; ++e ) {
        MeleeEnemy menemy = alive_enemies_[e];
        //System.out.println(menemy.bot_.name_ + " is still alive");
        Enemy enemy = menemy.bot_;
        double weight = 1000 / enemy.distance_ * 50 / enemy.energy_ *
        (Normalize(time_ - enemy.scan_time_, -1, max_time, false) * 0.3 + 0.7);
        double circular_weight = ((1 - Normalize(enemy.scans_difference_, 0, 8.5, false)) * 0.8 + 0.2) * 0.15;
        //System.out.println(weight);
        Range hot_window = firing_me.CornersAngleWindow(enemy);
        AddWindow(array, hot_window, weight);
        //System.out.println("  have hot");
        Range linear_window = firing_me.CornersAngleWindow(enemy.LinearPrediction(firing_me, (int)(enemy.scan_time_ - time_),ticks_to_fire_, power));
        AddWindow(array, linear_window, weight * 1.05);
        //System.out.println("  have linear");
        Range circular_window = firing_me.CornersAngleWindow(enemy.CircularPrediction(firing_me, (int)(enemy.scan_time_ - time_), ticks_to_fire_, power));
        AddWindow(array, circular_window, weight * circular_weight);
        //System.out.println("  have circular");
        //System.out.println(hot_window + " " + hot_window.Center());
        //System.out.println(linear_window + " " + linear_window.Center());
        if ( DEBUG ) {
          Painter.Add(new Point(firing_me, hot_window.Center(), enemy.distance_), 18, Color.LIGHT_GRAY);
          Painter.Add(new Point(firing_me, linear_window.Center(), enemy.distance_), 18, Color.BLACK);
          Painter.Add(new Line(enemy, new Point(firing_me, linear_window.Center(), enemy.distance_)), Color.BLACK);
          Painter.Add(new Point(firing_me, circular_window.Center(), enemy.distance_), 18, Color.MAGENTA);
          Painter.Add(new Line(enemy, new Point(firing_me, circular_window.Center(), enemy.distance_)), Color.MAGENTA);
        }
      }
      //System.out.println("  have them all");
      sort(array);
      //System.out.println("  sorted");
      aim_angle_ = (array.get(0).factor_ + array.get(1).factor_) / 2;
      double danger = array.get(0).danger_;
      double best_danger = danger;
      for ( int j = 1; j < array.size() - 1; ++j ) {
        double angle = (array.get(j).factor_ + array.get(j + 1).factor_) / 2;
        danger += array.get(j).danger_;
        if ( danger > best_danger && (reachable.Inside(angle) ||
              reachable.Inside(array.get(j).factor_) || 
              reachable.Inside(array.get(j + 1).factor_)) ) {
          aim_angle_ = angle;
          best_danger = danger;
        }
      }
      //System.out.println("  have aim angle");
      if ( DEBUG ) {
        Painter.Add(new Line(firing_me, aim_angle_, 1200), Color.WHITE);
      }
    } else if ( closest_ != null ) {
      //System.out.println("  aiming at closest");
      if ( DEBUG && closest_ != null ) {
        Painter.Add(closest_, 18, Color.YELLOW);
      }
      aim_angle_ = closest_.bearing_;
    }
    robot_.setTurnGunRightRadians(normalRelativeAngle(aim_angle_ - robot_.getGunHeadingRadians()));
    robot_.setFireBullet(power);
  }
  private void AddWindow(ArrayList<DangerSwitch> array, Range window, double weight) {
    if ( window.Size() < PI ) {
      array.add(new DangerSwitch(window.window_[0], weight));
      array.add(new DangerSwitch(window.window_[1], -weight));
    } else {
      array.add(new DangerSwitch(window.window_[1], weight));
      array.add(new DangerSwitch(PI, -weight));
      array.add(new DangerSwitch(-PI, weight));
      array.add(new DangerSwitch(window.window_[0], -weight));
    }
  }
  private double FirePower() {
    double power = 3;
    if ( closest_ != null && closest_.distance_ < 120 ) {
      if ( me_.energy_ < 10 )power = 1;
      else if ( me_.energy_ < 25 )power = 2;
    } else if ( others_ < 3 ) {
      if ( me_.energy_ < 20 )power = 0.5;
      else if ( me_.energy_ < 40 )power = 1;
      else power = 1.9;
    } else if ( others_ < 4 ) {
      if ( me_.energy_ < 20 )power = 0.5;
      else if ( me_.energy_ < 40 )power = 0.9;
      else power = 1;
    } else if ( others_ < 5 ) {
      if ( me_.energy_ < 20 )power = 1;
      else if ( me_.energy_ < 40 )power = 1.5;
      else power = 2;
    } else if ( others_ < 7 ) {
      if ( me_.energy_ < 20 )power = 1;
      else if ( me_.energy_ < 40 )power = 2;
      else power = 2.5;
    } else {
      if ( me_.energy_ < 10 )power = 1;
      else if ( me_.energy_ < 25 )power = 2;
    }
    //power = min(power, me_.energy_ / 6);
    //if ( others_ < 4 && me_.energy_ < 30 ) power = min(power, 1);
    //if ( others_ < 5 && me_.energy_ < 20 ) power = min(power, 0.5);
    if ( power < MIN_BULLET_POWER ) power = 0;
    return power;
  }
}
