package qwaker00;

import robocode.Rules;
import robocode.util.Utils;

import java.awt.*;
import java.awt.geom.Point2D;
import java.lang.reflect.Array;
import java.util.ArrayList;

class Wave {
    double bulletSpeed, heading, maxAngleFront, maxAngleBack, startX, startY, gunHeading;
    GFHolder result;
    int direction;
    long startTime;
    ArrayList<ArrayList<Point2D.Double>> points;

    public Wave(double startX, double startY, double bulletPower, long startTime) {
        this.startX = startX;
        this.startY = startY;
        this.bulletSpeed = Rules.getBulletSpeed(bulletPower);
        this.startTime = startTime;
        this.result = null;
    }

    public Wave(double startX,
                double startY,
                double bulletPower,
                double heading,
                double maxAngleFront,
                double maxAngleBack,
                int direction,
                GFHolder result,
                long startTime,
                double gunHeading,
                ArrayList<ArrayList<Point2D.Double>> points)
    {
        this.startX = startX;
        this.startY = startY;
        this.direction = direction;
        this.bulletSpeed = Rules.getBulletSpeed(bulletPower);
        this.startTime = startTime;
        this.heading = heading;
        this.result = result;
        this.gunHeading = gunHeading;
        this.maxAngleBack = maxAngleBack;
        this.maxAngleFront = maxAngleFront;
        this.points = points;
    }

    public double calcX(long time) {
        double r = bulletSpeed * (time - startTime) - 15;
        return Math.sin(gunHeading) * r + startX;
    }

    public double calcY(long time) {
        double r = bulletSpeed * (time - startTime) - 15;
        return Math.cos(gunHeading) * r + startY;
    }

    public boolean Check(double eX, double eY, long time) {
        if ( (Math.sqrt((eX - startX)*(eX - startX) + (eY - startY)*(eY - startY)) - 15) / bulletSpeed <= time - startTime) {
            if (result != null) {
                double diffAngle = direction * Utils.normalRelativeAngle(Math.PI / 2 - Math.atan2(eY - startY, eX - startX) - heading);
                int gfIndex = 0, halfL = result.length() / 2;
                if (diffAngle < 0) {
                    gfIndex = halfL - (int)Math.round(Math.min(halfL, halfL * -diffAngle / maxAngleBack));
                } else {
                    gfIndex = halfL + (int)Math.round(Math.min(halfL, halfL * diffAngle / maxAngleFront));
                }

                System.out.println("Hit: " + diffAngle + " " + maxAngleFront + " " + maxAngleBack + " = " + gfIndex);

                result.Hit(gfIndex);
            }
            return true;
        }
        return false;
    }

    void Paint(Graphics g, long time) {
        if (result == null) {
            g.setColor(Color.white);
            int r = (int)Math.round(bulletSpeed * (time - startTime)) - 15;
            g.drawOval((int)startX - r, (int)startY - r, r + r, r + r);
        } else {
            g.setColor(Color.orange);
            for (ArrayList<Point2D.Double> pp : points) {
                Point2D.Double p = null;
                for (Point2D.Double pn : pp) {
                    if (p != null) {
                        g.drawLine((int) p.getX(), (int) p.getY(), (int) pn.getX(), (int) pn.getY());
                    }
                    p = pn;
                }
            }
            g.setColor(Color.white);
            int r = (int)Math.round(bulletSpeed * (time - startTime)) - 15;
            g.drawOval((int)startX - r, (int)startY - r, r + r, r + r);
            g.drawLine((int)startX, (int)startY, (int)(Math.sin(heading) * r + startX), (int)(Math.cos(heading) * r + startY));
            g.setColor(Color.green);
            g.drawLine((int)startX, (int)startY, (int)(Math.sin(heading + maxAngleFront * direction) * r + startX), (int)(Math.cos(heading + maxAngleFront * direction) * r + startY));
            g.setColor(Color.red);
            g.drawLine((int)startX, (int)startY, (int)(Math.sin(heading - maxAngleBack * direction) * r + startX), (int)(Math.cos(heading - maxAngleBack * direction) * r + startY));
        }
    }
}
