package sgp;
import robocode.*;
import java.util.*;
import java.lang.String;

/**
 * EnemyBulletList - a class by Simon Parker
 */

public class EnemyBulletList extends Object
{
	JollyNinja robot = null;
	LinkedList list = new LinkedList();

	public EnemyBulletList(JollyNinja theRobot)
	{
		robot = theRobot;
	}

	public void add(EnemyBullet bullet)
	{
		list.add(bullet);
	}

	public void removeSafeBullets(Coordinate robotPosition, double time)
	{
		ListIterator iterator = list.listIterator(0);

		while(iterator.hasNext())
		{
			EnemyBullet bullet = (EnemyBullet)iterator.next();
			if (!bullet.isThreatening(robotPosition, time))
			{
				iterator.remove();
			}
		}
	}

	public double getBulletAvoidanceGoodness(Coordinate robotPosition, double time)
	{
		removeSafeBullets(robotPosition, time);
		double goodness = 0;
		for (int i = 0; i < list.size(); i++)
		{
			EnemyBullet bullet = (EnemyBullet)list.get(i);
			goodness += bullet.getAvoidanceGoodness(robotPosition, time);
		}

		return goodness;
	}

}
