package sgp;
import robocode.*;
import java.util.*;
import java.lang.String;
import java.io.*;

/**
 * MovementLog - a class by Simon Parker
 */

public class MovementLog extends Object
{
	private JollyNinja robot;
	private final int LOG_SIZE = 1000;
	private MovementRecord[] logArray = new MovementRecord[LOG_SIZE];
	private int currentIndex = 0;

	public MovementLog(JollyNinja theRobot)
	{
		robot = theRobot;
	}

	public void add(MovementRecord record)
	{
		if (currentIndex >= LOG_SIZE) return;

		logArray[currentIndex++] = record;
	}

	public void save(String filename)
	{
		try
		{
			PrintStream w = new PrintStream(new RobocodeFileOutputStream(robot.getDataFile(filename)));

			int i = 0;

			while ((logArray[i] != null) && (i < LOG_SIZE))
			{
				if (i == 0)
				{
					w.println(logArray[i].getHeadingText());
				}
				w.println(logArray[i].getText());
				i++;
			}

			// PrintStreams don't throw IOExceptions during prints,
			// they simply set a flag.... so check it here.
			if (w.checkError())
			{
				robot.out.println("I could not write!");
			}
			w.close();
		}
		catch (IOException e)
		{
			robot.out.println("IOException trying to write: " + e);
		}
	}

}