package djc;
import java.awt.*;
import java.awt.geom.*;     // for Point2D's

import djc.util.*;

import robocode.*;
import robocode.util.*;

/**
 * DynaBot - a robot by (your name here)
 */
public class AbstractDynaBot extends AdvancedRobot
{
	public static BattlefieldManager    theBattleManager = null;
	public static EnemyManager		    theEnemyManager  = null;
	public static GunManager      		theGunManager    = null;
	public static MovementManager 		theMoveManager   = null;
	public static RadarManager    		theRadarManager  = null;
	public Point2D.Double               location;
	public Point2D.Double               lastLocation;
	
	public AbstractDynaBot() {
	}
	
	/**
	 * run: DynaBot's default behavior
	 */
	public void run() {
		theBattleManager = new BattlefieldManager(this);
		theEnemyManager = new EnemyManager(this);
		theGunManager = new GunManager(this);
		theMoveManager = new MovementManager(this);
		theRadarManager = new RadarManager(this);
		
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        setAdjustRadarForRobotTurn(true);

		theBattleManager.reset();
		theEnemyManager.reset();
		theGunManager.reset();
		theMoveManager.reset();
		theRadarManager.reset();

		while(true) {
			try {
				//out.println("BattleManager");
				theBattleManager.doWork();
			} catch (Exception ex) {
				out.println("BM ERROR: " + ex.toString());
			}
			try {
				//out.println("EnemyManager");
				theEnemyManager.doWork();
			} catch (Exception ex) {
				out.println("EM ERROR: " + ex.toString());
			}
			try {
				theGunManager.doWork();
				//out.println("GunManager");				
			} catch (Exception ex) {
				out.println("GM ERROR: " + ex.toString());
			}
			try {
				theMoveManager.doWork();
				//out.println("MoveManager");				
			} catch (Exception ex) {
				out.println("MM ERROR: " + ex.toString());
			}		
			try {
				theRadarManager.doWork();
				//out.println("RadarManager");				
			} catch (Exception ex) {
				out.println("RM ERROR: " + ex.toString());
			}		
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		theEnemyManager.onScannedRobot(e);  // First
		theRadarManager.onScannedRobot(e);  // Second
						
		theBattleManager.onScannedRobot(e);
		theGunManager.onScannedRobot(e);
		theMoveManager.onScannedRobot(e);
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		theEnemyManager.onHitByBullet(e);
		theGunManager.onHitByBullet(e);
		theMoveManager.onHitByBullet(e);
		theBattleManager.onHitByBullet(e);
	}
	
	public void onBulletHit(BulletHitEvent e) {
		theEnemyManager.onBulletHit(e);
		theGunManager.onBulletHit(e);
		theBattleManager.onBulletHit(e);
	}

	public void onBulletHitBullet(BulletHitBulletEvent e) {
		theEnemyManager.onBulletHitBullet(e);
		theGunManager.onBulletHitBullet(e);
		theMoveManager.onBulletHitBullet(e);
		theBattleManager.onBulletHitBullet(e);
	}

	public void onBulletMissed(BulletMissedEvent e) {
		theEnemyManager.onBulletMissed(e);
		theGunManager.onBulletMissed(e);
		theBattleManager.onBulletMissed(e);
	}

	public void onDeath(DeathEvent e) {
		theBattleManager.onDeath(e);
		theEnemyManager.onDeath(e);
		theGunManager.onDeath(e);
		theMoveManager.onDeath(e);
	}

	public void onHitRobot(HitRobotEvent e) {
		theBattleManager.onHitRobot(e);
		theEnemyManager.onHitRobot(e);
		theGunManager.onHitRobot(e);
		theMoveManager.onHitRobot(e);
		theRadarManager.onHitRobot(e);
	}

	public void onHitWall(HitWallEvent e) {
		theMoveManager.onHitWall(e);
		theRadarManager.onHitWall(e);
	}

	public void onPaint(Graphics2D g) {
		theBattleManager.onPaint(g);
		theEnemyManager.onPaint(g);
		theGunManager.onPaint(g);
		theMoveManager.onPaint(g);
		theRadarManager.onPaint(g);
	}

	public void onRobotDeath(RobotDeathEvent e) {
		theBattleManager.onRobotDeath(e);
		theEnemyManager.onRobotDeath(e);
		theGunManager.onRobotDeath(e);
		theMoveManager.onRobotDeath(e);
		theRadarManager.onRobotDeath(e);
	}

	public void onWin(WinEvent e) {
		goToDirection *= -1;
		theBattleManager.onWin(e);
		theEnemyManager.onWin(e);
		theGunManager.onWin(e);
		theMoveManager.onWin(e);
		theRadarManager.onWin(e);
	}

	/**
	 * A lot happens when we fire.
	 */
	public Bullet doFireGun(double shotPower) {
		Bullet b;
		b = super.fireBullet(shotPower);
		if(b != null) {
			AdvancedBullet ab = new AdvancedBullet(b, "NONE", theGunManager.currentGun().gunID, -1);
			if(theEnemyManager.currentEnemy != null) {
	    		ab.enemyName = theEnemyManager.currentEnemy.name;
				ab.firedAtDistance = theEnemyManager.currentEnemy.lastDistance;
			} else {
				out.println("curentEnemy is null");
			}
			// Add an outbound wave
			theGunManager.doFireGun(shotPower);
			// Update the battlefield
			theBattleManager.doFireGun(shotPower, ab);
			// Update stats on the enemy
			theEnemyManager.doFireGun(shotPower);
		}
		return b;
	}

	/**
	 * Taken from http://robowiki.net/cgi-bin/robowiki?Movement/CodeSnippetGoTo
	 *
	 * as posted by Stelokim
	 */
	public void goTo(double destinationX, double destinationY) {
		destinationX -= getX();
		destinationY -= getY();
        double angle = Utils.normalRelativeAngle(Math.atan2(destinationX, destinationY) - getHeadingRadians() );
		double turnAngle = angle; //= Math.atan(Math.tan(angle));
        setTurnRightRadians(turnAngle);
		double aheadAmt = Math.hypot(destinationX, destinationY) * (angle == turnAngle ? 1 : -1);
		//out.println("Heading to: " + destinationX + "," + destinationY + " by turning " + Math.toDegrees(turnAngle) + " and setting ahead to " + (aheadAmt * goToDirection));
		
		if(getTurnRemaining() < 1) {		
	        setAhead(aheadAmt * goToDirection);
		}
	}

	private int goToDirection = 1;

	/**
	 *   Distance from the closest corner.  Taken from:
	 *
	 *      http://robowiki.net/cgi-bin/robowiki?MakoHT/Code
	 */
    public double distanceFromCorner()
    {
		return Math.min(Math.min(Point2D.distance(getX(), getY(), 0, 0), Point2D.distance(getBattleFieldWidth(), getY(), getX(), 0)), Math.min(Point2D.distance(getX(), getBattleFieldHeight(), 0, getY()), Point2D.distance(getBattleFieldWidth(), getBattleFieldHeight(), getX(), getY())));
    }


}
