package djc.gun;

import djc.*;
import djc.util.*;

import java.awt.*;
import java.awt.geom.*;

/**
 * Basic GuessFactor Gun
 *
 *  From (conceptually):
 *    http://robowiki.net/cgi-bin/robowiki?GFTargetingBot
 */
public class BasicGuessFactorGun extends BaseGun
{
	public BasicGuessFactorGun(AbstractDynaBot themyrobot) {
		super(themyrobot);
		name = "GUESSFACTORGUN";
		gunID = DynaBotConstants.GUESSFACTORGUN;
	}
	
	public double calcGunTurnRadians(Enemy e) {
		double [][][][][]gf;
		gf = (double[][][][][])myrobot.theEnemyManager.guessFactors.get(e.name);
		double dMaxGF = 0;
		int gameStage = MyUtils.getGameStage(myrobot.getOthers());
		int distSeg = MyUtils.getDistanceBin(e.lastDistance);
		int curVelIndex = MyUtils.getVelocityIndex(e.linVelocity);
		int prevVelIndex = MyUtils.getVelocityIndex(e.prevLinVelocity);
		int iBestIndex = DynaBotConstants.GUESSFACTORMIDDLE_BIN;  // Default to head-on
		
		for(int i=0;i<DynaBotConstants.GUESSFACTORBINS;i++) {
			if(dMaxGF < gf[gameStage][distSeg][curVelIndex][prevVelIndex][i]) {
				iBestIndex = i;
				dMaxGF = gf[gameStage][distSeg][curVelIndex][prevVelIndex][i];
				//dMaxGF = gf[DynaBotConstants.GAMESTAGE_ALLSTAGES][DynaBotConstants.DIST_SEG_ALL][curVelIndex][prevVelIndex][i];
				//dMaxGF = gf[gameStage][distSeg][0][0][i];
			}
		}
		double lateralDirection = 1;
		if(Math.abs(e.linVelocity) > 0) {
			lateralDirection = MyUtils.sign(e.linVelocity * Math.sin(e.heading - e.absBearing));
		}
		
		double retval = e.absBearing /*- myrobot.getHeadingRadians()*/ + (lateralDirection * DynaBotConstants.GUESSFACTORBIN_WIDTH) * (iBestIndex - DynaBotConstants.GUESSFACTORMIDDLE_BIN);
		
		return retval;
	}
	
	public void onPaint(Graphics2D g) {
		if(myrobot.theEnemyManager.currentEnemy == null) return;
		Enemy e = myrobot.theEnemyManager.currentEnemy;
		
		double [][][][][]gf;
		gf = (double[][][][][])myrobot.theEnemyManager.guessFactors.get(e.name);
		double dMaxGF = 0;
		int gameStage = MyUtils.getGameStage(myrobot.getOthers());
		int distSeg = MyUtils.getDistanceBin(e.lastDistance);
		int curVelIndex = MyUtils.getVelocityIndex(e.linVelocity);
		int prevVelIndex = MyUtils.getVelocityIndex(e.prevLinVelocity);
		int iBestIndex = DynaBotConstants.GUESSFACTORMIDDLE_BIN;  // Default to head-on
		
		g.setColor(Color.green);
		for(int i=0;i<DynaBotConstants.GUESSFACTORBINS;i++) {
			g.drawLine(50 + 5*i, 50, 50 + 5*i, (int)(50 + 10 * gf[gameStage][distSeg][curVelIndex][prevVelIndex][i]));
		}
					
	}
	
}
