package djc;
import robocode.*;

/**
 * LinearTargetingStrategy. 
 */
public class LinearTargetingStrategy extends TargetingStrategy
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */

    LinearTargetingStrategy(Target pT)
    {
        super(pT);
        name = TargetingStrategyManager.LINEAR;
    }

    /**
     * predictCoordinates
     *  @return Coordinate
     */
    public Coordinate predictCoordinate(double curTime, double futureTime)
    {
        return _predictCoordinate(curTime, futureTime, t.velocity,
				  t.heading_rad);
    }

    /**
     * _predictCoordinates
     *  @return Coordinate
     */
    public Coordinate _predictCoordinate(double curTime, double futureTime,
					 double pVel, double pHdng)
    {
        double dist = (futureTime + curTime - t.lastTimePosition) * pVel;
	//t.self.out.println("Linear predicting: " + (int)(t.position.x + dist * Math.sin(pHdng))
	//		   + "," + (int)(t.position.y + dist * Math.cos(pHdng))
	//		   + " from " + (int)t.position.x + "," + (int)t.position.y
	//		   + " at " + (int)Math.toDegrees(t.heading_rad)
	//		   + " v = " + t.velocity + " dT =" + (int)futureTime);
        return new Coordinate(t.position.x + dist * Math.sin(pHdng),
			      t.position.y + dist * Math.cos(pHdng));
	
    }
}
