/*
 * Created on Aug 4, 2003
 *
 */
package jekl.gunnery;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.util.*;
import jekl.utils.*;
import jekl.*;

/**
 * @author jbishop
 *
 */

public class WaveGun implements Constants,Gun {
	private Point2D.Double myLocation;
	private Enemy target;
	private static int CLOSING_INDICIES		= 3;
	private static int ACCEL_INDICIES		= 3;
	private static int LAT_VEL_INDICIES		= 5;
	private static int OUT_INDICIES			= 5;
	private static int DIST_INDICIES		= 6;
    private static float [][][][][][] statBuffer;
    private static float [] fastStatBuf;
    private int lastLatVelIndex, lastDecelTime, lastAccelTime = 0;
	private DarkHallow ar;
	private ArrayList waves;
	private int targetDir = 1; 
	
	public WaveGun(DarkHallow _ar) {
		this.ar = _ar;
		this.waves = new ArrayList();
		this.myLocation = new Point2D.Double();
		if (statBuffer == null) {
			statBuffer = new float[CLOSING_INDICIES][ACCEL_INDICIES][LAT_VEL_INDICIES]
				[OUT_INDICIES][DIST_INDICIES][(int) GUESS_FACTORS];
		}

		if (fastStatBuf == null) {
			fastStatBuf = new float[(int) GUESS_FACTORS];
		}
	}

    public void onScannedRobot(ScannedRobotEvent e) {
		target = ar.getTarget();
		doStats();

        myLocation.setLocation(ar.getX(), ar.getY());

		int latVelIndex = (int)Math.round(Math.abs(target.getLatVel()))/2;
		int lastLatVelIndex = (int)Math.round(Math.abs(target.getLastLatVel()))/2;
		
		if (latVelIndex - lastLatVelIndex < 0) {
			lastDecelTime = 0;
		}

		if (latVelIndex - lastLatVelIndex > 0) {
			lastAccelTime = 0;
		}

		if (target.getVelocity() != 0) {
			targetDir = (target.getVelocity() > 0 ? 1 : -1);
		}
		
		int closingIndex = (target.getClosingVelocity() == 0 ? 0 : target.getClosingVelocity() > 0 ? RETREATING : ADVANCING);

		double firePower = calculateFirePower(target);
		//double firePower = (ar.getEnergy() > 0 ? 3.0 : 0.0);

		//Retrieve the current stat segment to use
		int distIndex = (int)Math.min(5, target.getDistance() / DIST_BUCKET_SIZE);
		//92.4%
		float[] stats = statBuffer[closingIndex][target.getAccellIndex()][latVelIndex][JeklUtils.getOutIndex(target.getLocation(),target.getHeading(),targetDir)][distIndex];
        float[] fast = fastStatBuf;

        //Aim the gun and fire
		ar.setTurnGunRightRadians(Utils.normalRelativeAngle(target.getAbsBearing() - ar.getGunHeadingRadians() + 
        	(target.getEnergy() == 0 ? 0 : getGuessAngle(getIndex(stats), firePower, target.getDirection()))));

		if (ar.getGunHeat() == 0 && firePower > 0) {
			ar.incrementMyShots();
		}

		//ar.setFire(firePower);
        if (firePower > 0) {
        	ar.setFire(firePower);
        	Wave w = new Wave(ar);
			w.initializeWave(firePower, 
						stats, fast, 
						myLocation, 
						target.getLocation(), 1, target.getDirection(), 
						distIndex
			);
			waves.add(w);
        }
    }
    
    //--------------------------------------- Helpers ------------------------------------------------------
        
	private void doStats() {
		Iterator it = waves.iterator();		
		while(it.hasNext()) {
			Wave w = (Wave)it.next();
			if ((w.dist += w.bulletVel) >= w.shotOrigin.distance(w.targetLoc) - 18) {
				if (w.shotPower > 1.0) {
					w.incrementGunHits();
				}
				it.remove();
			}
		}
	}
	
	/** Get the current best Guess Factor to shoot at */
	private int getIndex(float[] stats) {
		int bestIndex = (int) MIDDLE_FACTOR;
		float bestTotal = 0;

		for (int i = 1; i < stats.length; i++) {
			float temp = 0;
			for (int j = Math.max(i - 1, 1); j < Math.min(i + 1, stats.length); j++) {
				temp+=stats[j];
			}
			if (temp > bestTotal) {
				bestTotal = temp;
				bestIndex = i;
			}
		}
		return bestIndex;
	}

	public double getGuessAngle(int guessIndex, double firePower, int eDirection) {
		return (Math.asin(8.0 / JeklUtils.bulletV(firePower) * eDirection) * ((guessIndex/MIDDLE_FACTOR) - 1));
	}
	
	public double calculateFirePower(Enemy target) {
		double energy = 0.0;		//If behavior is not properly set we will not fire correctly.
        //Normal occourance. Lets blaze away
        if (ar.getEnergy() >= 20) {
        	energy = (myLocation.distance(ar.getTarget().getLocation()) <= 359 ? MAX_SHOT_POWER : PREFERRED_SHOT_POWER);
        //Coming to the end game. Need to be more prudent with energy usage
        } else if ((ar.getEnergy() >= 10) && (ar.getEnergy() < 20)) {
        	energy = (myLocation.distance(ar.getTarget().getLocation()) <= 359 ? MAX_SHOT_POWER : PREFERRED_SHOT_POWER) * .75;
        } else if ((ar.getEnergy() >= 3.0) && (ar.getEnergy() < 10)) {
            energy = ar.getEnergy() / 5;
        } else if ((ar.getEnergy() < 3.0)) {
        	if (ar.getEnergy() > target.getEnergy() || target.getDistance() < 359)
        		energy = ar.getEnergy() / 5;
        }
        return Math.min(energy, ((target.getEnergy() + 2) / 4));
   }
}