/*
 * Class.java
 *
 * Created on April 7, 2002, 12:41 AM
 */

package tobe.util;
import robocode.*;

/**
 *
 * @author  tobe
 * @version 
     * A Strategy is used to build a part of a robot for robocode.
     * Essentially it encapsulates the logic for the robot.
 */
public abstract class AbstractStrategy {
        
        /** This should be called by the robot at the start of each battle */
        public void init(AdvancedRobot bot){}
        
        /** This should be called by the robot every turn. Here is where to place the logic. */
        /** execute must be called in this routine when necessary */
        public abstract boolean go(AdvancedRobot bot);
        
        /** is called at thw end */
        public void printStatistics(AdvancedRobot bot){}
        
        /** Event handler. Keep its execution time short. */
        public void handleBulletHitEvent(AdvancedRobot bot, BulletHitEvent e) {}
        
        /** Event handler. Keep its execution time short. */
        public void handleBulletMissedEvent(AdvancedRobot bot, BulletMissedEvent e) {}
        
        /** Event handler. Keep its execution time short. */
        public void handleCustomEvent(AdvancedRobot bot, CustomEvent e) {}
        
        /** Event handler. Keep its execution time short.*/
        public void handleDeathEvent(AdvancedRobot bot, DeathEvent e) {}
        
        /** Event handler. Keep its execution time short. */
        public void handleHitByBulletEvent(AdvancedRobot bot, HitByBulletEvent e) {}
        
        /** Event handler. Keep its execution time short. */
        public void handleHitRobotEvent(AdvancedRobot bot, HitRobotEvent e) {}
        
        /** Event handler. Keep its execution time short. */
        public void handleHitWallEvent(AdvancedRobot bot, HitWallEvent e) {}
        
        /** Event handler. Keep its execution time short. */
        public void handleRobotDeathEvent(AdvancedRobot bot, RobotDeathEvent e) {}
        
        /** Event handler. Keep its execution time short. */
        public void handleScannedRobotEvent(AdvancedRobot bot, ScannedRobotEvent e) {}
        
        /** Event handler. Keep its execution time short.*/
        public void handleWinEvent(AdvancedRobot bot, WinEvent e) {}
        
        /** Utility routine to take an angle in radians and returns its normal value between -PI and PI*/
        protected double normalizeAngle(double r) {
            while(r>Math.PI) r-=2*Math.PI;
            while(r<-Math.PI) r+=2*Math.PI;
            return r;
        }

}
