/*
 * Created on 2004-9-27
 */
package tide.pear;

import tide.BulletHitEvent;
import tide.EventListener;
import tide.HitByBulletEvent;
import tide.HitRobotEvent;
import tide.RobotConsole;
import tide.RobotDeathEvent;
import tide.ScannedRobotEvent;
import tide.util.BotInfo;
import tide.util.BotInfoManager;
import tide.util.EnemyInfo;
import tide.util.MyInfo;
import tide.util.Utils;

/**
 * This recorder can recorde very bot's info include yourself robot.
 * Works very accurate in robocode,
 * but not accurate in AIRobot.
 * If you want to use this rocorde's data you must add this listener to the first
 * Make sure this listener can be invoke before you use it's data
 * @author iiley(Chen Jing)
 */
public class BotInfoRecorder extends EventListener {
	
	private BotInfoManager infos;
	
	/**
	 * @param console
	 */
	public BotInfoRecorder(RobotConsole console) {
		super(console);
		infos = new BotInfoManager();
	}
	
	public BotInfoManager getBotInfoManager(){
		return infos;
	}
	
	/* (non-Javadoc)
	 * @see bridge.EventListener#onWork()
	 */
	public void onWork() {
	}
	
	/* (non-Javadoc)
	 * @see bridge.EventListener#onBulletHit(bridge.BulletHitEvent)
	 */
	public void onBulletHit(BulletHitEvent event) {
		BotInfo info = infos.getInfoMustHaveOne(event.getName(), event.getTime() - 1);
		info.modifyEnergy(-Utils.bulletDamage(event.getPower()));
	}
	/* (non-Javadoc)
	 * @see bridge.EventListener#onHitByBullet(bridge.HitByBulletEvent)
	 */
	public void onHitByBullet(HitByBulletEvent event) {
		BotInfo info = infos.getInfoMustHaveOne(event.getName(), event.getTime() - 1);
		info.modifyEnergy(event.getPower()*3d);
	}
	/* (non-Javadoc)
	 * @see bridge.EventListener#onHitRobot(bridge.HitRobotEvent)
	 */
	public void onHitRobot(HitRobotEvent event) {
		BotInfo info = infos.getInfoMustHaveOne(event.getName(), event.getTime() - 1);
		info.modifyEnergy(-0.6d);
	}
	/* (non-Javadoc)
	 * @see bridge.EventListener#onRoundBegin()
	 */
	public void onRoundBegin() {
		infos.clear();
	}
	/* (non-Javadoc)
	 * @see bridge.EventListener#onScannedRobot(bridge.ScannedRobotEvent)
	 */
	public void onScannedRobot(ScannedRobotEvent event) {
		//add my robot info
		infos.addInfo(event.getTime(), new MyInfo(console, event));
		
		//add enemy info
		double wallDamage = 0;
		BotInfo lastEnemyInfo = infos.getInfo(event.getName(), event.getTime() - 1);
		//enemy hit wall energy drop
		if (lastEnemyInfo != null 
				&& Math.abs(event.getVelocity()) == 0 
				&& Math.abs(lastEnemyInfo.getVelocity()) > 2.0) {
			wallDamage = Math.max(0, Math.abs(lastEnemyInfo.getVelocity()) / 2 - 1);
			lastEnemyInfo.modifyEnergy(-wallDamage);
		}
		infos.addInfo(event.getTime(), new EnemyInfo(console, event));
	}
	
	/* (non-Javadoc)
	 * @see tide.EventListener#onRobotDeath(tide.RobotDeathEvent)
	 */
	public void onRobotDeath(RobotDeathEvent event) {
		BotInfo info = new BotInfo(event.getName(), 0d);
		BotInfo lastInfo = infos.getInfoMustHaveOne(event.getName(), event.getTime() - 1);
		info.getLocation().setLocation(lastInfo.getLocation());
		infos.addInfo(event.getTime(), info);
	}
}
