package robar.haiku;

import robocode.*;
import robocode.util.Utils;


/*
 * Spike - my dear haiku designed into the nanorumble :)
 * 
 * 1.0: Duelistnano-type 'gunradar', kawigi's perceptual bullet-dodging code, firepower-management, distance-control. :) 126 bytes, 15 June 2009
 */

public class Spike extends AdvancedRobot {

	
	public void run(){
		
		//turnGunRight(36);
		setTurnGunRight(Double.POSITIVE_INFINITY);
	}
	
	public void onScannedRobot(ScannedRobotEvent e){
		
		//setTurnRightRadians(Math.cos(e.getBearingRadians()) - Math.signum(getVelocity() * (e.getDistance() - 200))*0.17);
		
		//The original perceptual bullet dodging code from Kawigi:
		//setAhead(Math.tan(e.getEnergy()*5)*100);
		
		//And my interpretation
		setAhead( Math.tan(e.getEnergy()*4) * 10
				+ (setFireBullet( 2.5 * Math.signum(  e.getEnergy()) -
						(1/getEnergy())*10) == null ? 0 : 0 ));
		
		setTurnRightRadians(Math.cos(e.getBearingRadians())- Math.signum(getVelocity() * (e.getDistance() - 180)) *0.17);
		
		//setTurnGunLeft(getGunTurnRemaining());
		setTurnGunRightRadians(5 * Utils.normalRelativeAngle((e.getBearingRadians() + getHeadingRadians())-getGunHeadingRadians()));
	}
	
	
	

}
