package axeBots.data;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import axeBots.AxeBot;
import axeBots.pilot.waves.EnemyWave;
import axeBots.util.AxeFiles;
import axeBots.util.RoboMath;

/**
 * SegmentedGFs - 11/06/2004
 * 
 * @author Axe
 * 
 * This code is released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL (Basically it means you must keep the
 * code public if you base any code on it.) Not basically, i think it means that
 * the knowledge should not be retained, but shared. We must all remember that
 * the veins of the Knowledge must flow. Quoting(or some) PEZ�s comment about
 * OpenSouce: "At least is a good Karma".
 */
public class SegmentedGFs {
	public static final int GF_QT = 97;//101;//17;
	public static final int MID_GF = (int) (GF_QT / 2D);

	public static final int HOT_GF_LIMIT_LO = (int) ((GF_QT) * (1D / 4D));
	public static final int HOT_GF_LIMIT_HI = (int) ((GF_QT) * (3D / 4D));

	public static final int DISTS = 3;
	public static final int VELS = 5;
	public static final int ACCS = 3;//3;
	public static final int HEADS = 1;//3;
	public static final int WALLS = 1;//desligado
	public static final int BULL_PWR = 1;//desligado
	public static final int DIST_SLC = 200;
	private static double[][] visits = new double[DISTS][GF_QT];
	private static double[][][][][][][] hits = new double[DISTS][VELS][ACCS][BULL_PWR][WALLS][HEADS][GF_QT];
	private static int[] numVisits = new int[DISTS];
	private static int[][][][][][] numHits = new int[DISTS][VELS][ACCS][BULL_PWR][WALLS][HEADS];

	//	private static int[] numVelHits = new int[VELS];
	//	private static int[] numDistHits = new int[DISTS];
	//	private static int[] numAccHits = new int[ACCS];
	//ALTERADO: APRENDIZADO RAPIDO
	//	private static double[][] velHits = new double[VELS][GF_QT];
	//	private static double[][] distHits = new double[DISTS][GF_QT];
	//	private static double[][] accHits = new double[ACCS][GF_QT];

	private static double[] allHits = new double[GF_QT];
	private static double[] longAllHits = new double[GF_QT];
	private static int numAllHits = 0;
	private static int headOnWarmingUp;
	private static final int GF_SAVING_PRECISION = 15;//63;

	private static final int HOT_GF_SAVING_PRECISION = 127;//63;

	private static final int SAMPLES_AMT_SAVING_PRECISION = 3;
	private static final int SAMPLES_LONGAMT_SAVING_PRECISION = 21;
	private static final int MINMAX_SAVING_PRECISION = 255;

	public SegmentedGFs() {
		super();
		newRound();
	}

	public void newRound() {
		headOnWarmingUp--;
	}

	public void hit(int gf, double bullPw, double dist, EnemyWave ew) {
		updateHitData((int) dist, ew.getVelocity(), ew.getAcceleration(), ew
				.getBulletPower(), ew.getDistToWall(), ew.getMyAttackAngle(),
				gf, ew.getConsecutives(AxeBot.getIt().pos(), AxeBot.BOT_DIM));
	}
	public void updateVisit(int dist, int gf, int consecutives) {
		int ind = this.getDistIndex(dist);
		for (int i = 0; i < SegmentedGFs.GF_QT; i++) {
			visits[ind][i] = RoboMath.rollingAverage(numVisits[ind] > 20
					? 20
					: numVisits[ind], visits[ind][i],
					((i >= gf - consecutives) && (i <= gf + consecutives))
							? 1
							: 0);
		}
		numVisits[ind]++;
	}
	public void updateHitData(int dist, int vel, int acc, double bullPwr,
			int wallsDist, double myAttackAngle, int gf, int consecutives) {
		int dInd = this.getDistIndex(dist);
		int vInd = this.getVelIndex(vel);
		int aInd = this.getAccIndex(acc);
		int wInd = this.getWallsIndex(wallsDist);
		int bpInd = this.getBulletPwrIndex(bullPwr);
		int aaInd = this.getHeadsIndex(myAttackAngle);
		this.updateHitData(dInd, vInd, aInd, bpInd, wInd, aaInd, gf,
				consecutives);

	}

	public void updateHitData(int distIndex, int velIndex, int accIndex,
			int bullPwrIndex, int wallsIndex, int headsIndex, int gf,
			int consecutives) {

		for (int i = 0; i < SegmentedGFs.GF_QT; i++) {
			double entry = ((i >= gf - consecutives) && (i <= gf + consecutives))
					? 1
					: 0;
			hits[distIndex][velIndex][accIndex][bullPwrIndex][wallsIndex][headsIndex][i] = RoboMath
					.rollingAverage(
							numHits[distIndex][velIndex][accIndex][bullPwrIndex][wallsIndex][headsIndex] > 3
									? 3
									: numHits[distIndex][velIndex][accIndex][bullPwrIndex][wallsIndex][headsIndex],
							hits[distIndex][velIndex][accIndex][bullPwrIndex][wallsIndex][headsIndex][i],
							entry);
			//			ALTERADO: APRENDIZADO RAPIDO
			//			distHits[distIndex][i] = RoboMath.rollingAverage(
			//					numDistHits[distIndex] > 3 ? 3 : numDistHits[distIndex],
			//					distHits[distIndex][i], entry);
			//			
			//			velHits[velIndex][i] = RoboMath.rollingAverage(
			//					numVelHits[velIndex] > 3 ? 3 : numVelHits[velIndex],
			//							velHits[velIndex][i], entry);
			//			
			//			accHits[accIndex][i] = RoboMath.rollingAverage(
			//					numAccHits[accIndex] > 3 ? 3 : numAccHits[accIndex],
			//							accHits[accIndex][i], entry);

		}
		//		numAccHits[accIndex]++;
		//		numVelHits[velIndex]++;
		//		numDistHits[distIndex]++;
		numHits[distIndex][velIndex][accIndex][bullPwrIndex][wallsIndex][headsIndex]++;

		updateAllHits(consecutives, gf);

	}

	private void updateAllHits(int consecutives, int gf) {
		for (int i = 0; i < SegmentedGFs.GF_QT; i++) {
			allHits[i] = RoboMath.rollingAverage(numAllHits > 3
					? 3
					: numAllHits, allHits[i],
					((i >= gf - consecutives) && (i <= gf + consecutives))
							? 1
							: 0);
			longAllHits[i] = RoboMath.rollingAverage(numAllHits > 20
					? 20
					: numAllHits, longAllHits[i],
					((i >= gf - consecutives) && (i <= gf + consecutives))
							? 1
							: 0);
		}

		numAllHits++;

	}
	private static int getBulletPwrIndex(double bullPwr) {
		return 0;//bullPwr<=1?0:bullPwr<=2?1:2;
	}

	private static int getWallsIndex(double d) {

		return 0;//(d <= 100) ? 1 : 0;//bullPwr<=1?0:bullPwr<=2?1:2;
	}
	private static int getAccIndex(int acc) {
		return (acc < 0) ? 0 : (acc == 0) ? 1 : 2;
	}
	private static int getVelIndex(int vel) {
		vel = Math.abs(vel);
		//HISTORY v2.43: NOVO TESTE INDICE DE VEL. IDEA PEZ.
		return vel == 0 ? 0 : vel <= 2 ? 1 : vel <= 5 ? 2 : vel <= 7 ? 3 : 4;
		//return vel == 0 ? 0 : vel <= 2 ? 1 : vel <= 4 ? 2 : vel <= 6 ? 3 : 4;
	}

	private static int getHeadsIndex(double attackAngle) {
		return 0;
		//		double aa = Math.abs(attackAngle);
		//		return (aa < 45) ? 0 : (aa < 95) ? 1 : 2;
	}

	//ALTERADO: PARAMETRO REDUZIDO PARA EW.
	public static double[] getVisits(EnemyWave ew) {
		return visits[getDistIndex(ew.getOriginalDistance())];
	}
	public static double getGFArcWdt(double bullPw, double dist) {
		double bVel = RoboMath.getBulletVelocity(bullPw);
		return 2D * Math.toDegrees(Math.asin(AxeBot.MAX_VEL / bVel));
	}

	public int getConsecutives(double bullPw, double dist) {
		double arc = getArcLen(bullPw, dist);
		//tamanho da fatia de cada gf
		double slc = arc / (SegmentedGFs.GF_QT - 1);
		return (int) Math.round((AxeBot.BOT_DIM / 2) / slc);
	}

	public static int getArcLen(double bullPw, double dist) {

		double arcAng = SegmentedGFs.getGFArcWdt(bullPw, dist);
		return (int) (dist * 2 * Math.PI * (arcAng / 360D));
	}

	//	ALTERADO: APRENDIZADO RAPIDO
	//	 Jamougha�s gf rating formula
	public double[] rateGFs(double[] allHits, double[] hits, int qtdHits,
			double[] visits,/*
							 * double[] distHits,double[] velHits,double[]
							 * accHits,
							 */
			boolean headOn) {
		double rate[] = new double[GF_QT];

		if (headOn) { // HEAD ON
			for (int i = 0; i < GF_QT; i++) {
				double rating = 0;
				for (int j = 0; j < GF_QT; j++) {
					rating += ((1 * longAllHits[j]) + (1 * allHits[j]))
							/ Math.pow(Math.abs(j - i) + 1, 1.0);
				}
				rate[i] = rating;
			}
		}

		else if (visits == null) { // WITHOUT FLATTENER
			for (int i = 0; i < GF_QT; i++) {
				double rating = 0;
				for (int j = 0; j < GF_QT; j++) {
					rating += ((1 * hits[j]) + (1 * allHits[j]))
							/ Math.pow(Math.abs(j - i) + 1, 1.0);
				}
				rate[i] = rating;
			}
		} else if (qtdHits > 0) { // NORMAL
			for (int i = 0; i < GF_QT; i++) {
				double rating = 0;
				for (int j = 0; j < GF_QT; j++) {
					rating += ((1 * hits[j]) + (1 * allHits[j]) + (0.5 * visits[j]))
							/ Math.pow(Math.abs(j - i) + 1, 1.0);
				}
				rate[i] = rating;
			}
		} else {
			for (int i = 0; i < GF_QT; i++) {
				double rating = 0;
				for (int j = 0; j < GF_QT; j++) {
					rating += (allHits[j] + (0.5 * visits[j]))
							/ Math.pow(Math.abs(j - i) + 1, 1.0);
				}
				rate[i] = rating;
			}
		}

		return rate;
	}

	public static double getHeadOn() {
		double a1 = RoboMath.getSum(longAllHits, 0,
				(SegmentedGFs.GF_QT / 3) - 1);
		double a2 = RoboMath.getSum(longAllHits, (SegmentedGFs.GF_QT / 3),
				SegmentedGFs.GF_QT - (SegmentedGFs.GF_QT / 3) - 1);
		double a3 = RoboMath.getSum(longAllHits, SegmentedGFs.GF_QT
				- (SegmentedGFs.GF_QT / 3), SegmentedGFs.GF_QT - 1);
		return (headOnWarmingUp > 0) ? 0 : a2 / (a1 + a2 + a3);
	}

	public static double getGFSliceWdt(double maxAng) {
		return maxAng / GF_QT;
	}
	public static int getGF(double bullPw, double angularDelta, double dist) {

		double maxAng = getGFArcWdt(bullPw, dist);
		// tamanho de cada fatia de GF
		double slice = getGFSliceWdt(maxAng);
		double ret = Math.floor((angularDelta + (maxAng / 2)) / slice);
		ret = (ret > (GF_QT - 1)) ? GF_QT - 1 : (ret < 0) ? 0 : ret;

		return (int) ret;
	}
	public static double getRealGF(double bullPw, double angularDelta,
			double dist) {

		double maxAng = getGFArcWdt(bullPw, dist);
		// tamanho de cada fatia de GF
		//			double slice= getGFSliceWdt( maxAng);
		return angularDelta / (maxAng / 2);
	}

	private static int getDistIndex(double dist) {
		int ret = (int) (dist / DIST_SLC);
		return (ret > (DISTS - 1)) ? (DISTS - 1) : ret;
	}
	public void draw(double dist) {
	}

	public void save(String name) {
		GZIPOutputStream zipout = null;
		DataOutputStream w = null;
		try {

			int cont = 0;
			while (true) {
				try {
					zipout = AxeFiles.getGZipOutputStream(name
							+ AxeFiles.GFS_FILE_EXTENSION);
					//zipout.setLevel(9);
					break;
				} catch (Throwable th) {
					cont++;
					AxeBot.getIt().out
							.println(" XXXXXXXXXXXXXXXXXX saving failed. try:"
									+ cont + "/30 reason:" + th.getMessage());
					if (cont >= 30) {
						throw new InterruptedIOException(
								"SAVING ABORTED TO FILE:" + name
										+ AxeFiles.GFS_FILE_EXTENSION);
					}
				}
			}

			w = new DataOutputStream(zipout);
			//HISTORY v2.43: NOVO + COMPRESSED SAVING
			this.saveCompressed(w);

			AxeBot.getIt().out
					.println("Data uploaded successfully for tageted enemy: "
							+ name + ". Disengaging...");
			w.flush();

		} catch (IOException e) {
			AxeBot.getIt().out.println("IOException trying to write: " + e);
		} finally {

			try {
				zipout.finish();
			} catch (Throwable e2) {
			}
			try {
				w.close();
			} catch (Throwable e2) {
			}
		}
	}

	private void saveCompressed(DataOutputStream w) throws IOException {
		boolean hot = AxeBot.getIt().getMyTarget().isHeadOn();
		int gfSavePrecision = (hot
				? HOT_GF_SAVING_PRECISION
				: GF_SAVING_PRECISION);
		int gfbitlen = RoboMath.countBits(gfSavePrecision);
		int amtbitlen = RoboMath.countBits(SAMPLES_AMT_SAVING_PRECISION);
		int longamtbitlen = RoboMath
				.countBits(SAMPLES_LONGAMT_SAVING_PRECISION);
		int minmaxbitlen = RoboMath.countBits(MINMAX_SAVING_PRECISION);

		OptimizedBitBuffer buf = new OptimizedBitBuffer();

		//flag de headon
		buf.add((char) (hot ? 1 : 0), 1);

		buf.add((char) Math.max(numAllHits, SAMPLES_LONGAMT_SAVING_PRECISION),
				longamtbitlen);

		//		ALTERADO: EVEN MORE COMPRESSED. BUG FOUND SAVING HITS[]
		System.out.println("saving NEW COMPRESSED numAllHits=" + numAllHits);

		double graphMin = getGraphMin(allHits);
		double graphMax = getGraphMax(allHits);
		buf.add((char) RoboMath.boundIt(Math.round(graphMin
				* MINMAX_SAVING_PRECISION), 0, MINMAX_SAVING_PRECISION),
				minmaxbitlen);
		buf.add((char) RoboMath.boundIt(Math.round(graphMax
				* MINMAX_SAVING_PRECISION), 0, MINMAX_SAVING_PRECISION),
				minmaxbitlen);
		for (int i = 0; i < GF_QT; i++) {
			buf.add(squeeze(allHits[i], graphMin, graphMax, gfSavePrecision),
					gfbitlen);
		}

		graphMin = getGraphMin(longAllHits);
		graphMax = getGraphMax(longAllHits);
		buf.add((char) RoboMath.boundIt(Math.round(graphMin
				* MINMAX_SAVING_PRECISION), 0, MINMAX_SAVING_PRECISION),
				minmaxbitlen);
		buf.add((char) RoboMath.boundIt(Math.round(graphMax
				* MINMAX_SAVING_PRECISION), 0, MINMAX_SAVING_PRECISION),
				minmaxbitlen);
		for (int i = 0; i < GF_QT; i++) {
			buf
					.add(squeeze(longAllHits[i], graphMin, graphMax,
							gfSavePrecision), gfbitlen);
		}
		if (!hot) {
			for (int j = 0; j < DISTS; j++) {
				for (int k = 0; k < VELS; k++) {
					for (int l = 0; l < ACCS; l++) {
						for (int m = 0; m < BULL_PWR; m++) {
							for (int n = 0; n < WALLS; n++) {
								for (int p = 0; p < HEADS; p++) {
									buf.add((char) RoboMath.boundIt(
											numHits[j][k][l][m][n][p], 0,
											SAMPLES_AMT_SAVING_PRECISION),
											amtbitlen);

									if (numHits[j][k][l][m][n][p] > 0) {
										graphMin = getGraphMin(hits[j][k][l][m][n][p]);
										graphMax = getGraphMax(hits[j][k][l][m][n][p]);
										//System.out.println("min:"+graphMin+"
										// max:"+graphMax );
										buf
												.add(
														(char) RoboMath
																.boundIt(
																		Math
																				.round(graphMin
																						* MINMAX_SAVING_PRECISION),
																		0,
																		MINMAX_SAVING_PRECISION),
														minmaxbitlen);
										buf
												.add(
														(char) RoboMath
																.boundIt(
																		Math
																				.round(graphMax
																						* MINMAX_SAVING_PRECISION),
																		0,
																		MINMAX_SAVING_PRECISION),
														minmaxbitlen);
										for (int i = 0; i < GF_QT; i++) {
											buf.add(squeeze(
													hits[j][k][l][m][n][p][i],
													graphMin, graphMax,
													gfSavePrecision), gfbitlen);

										}
									}
								}
							}
						}
					}
				}
			}
		}
		//ALTERADO: EVEN MORE COMPRESSED
		/*
		 * for (int i = 0; i < GF_QT; i++) {
		 * buf.add((char)RoboMath.boundIt(longAllHits
		 * [i]*GF_SAVING_PRECISION,0,GF_SAVING_PRECISION), gfbitlen); } for (int
		 * j = 0; j < DISTS; j++) { for (int k = 0; k < VELS; k++) { for (int l =
		 * 0; l < ACCS; l++) { for (int m = 0; m < BULL_PWR; m++) { for (int n =
		 * 0; n < WALLS; n++) {
		 * buf.add((char)RoboMath.boundIt(numHits[j][k][l][m][n],0,SAMPLES_AMT_SAVING_PRECISION),
		 * amtbitlen); for (int i = 0; i < GF_QT; i++) {
		 * buf.add((char)RoboMath.boundIt(allHits[i]*GF_SAVING_PRECISION,0,GF_SAVING_PRECISION),
		 * gfbitlen); } } } } } }
		 */
		buf.saveTo(w);

	}

	private double getGraphMin(double graph[]) {
		return RoboMath.boundIt(RoboMath.getMin(graph), 0D, 1D);
	}

	private double getGraphMax(double graph[]) {
		return RoboMath.boundIt(RoboMath.getMax(graph), 0D, 1D);
	}

	private char squeeze(double val, double min, double max, int precision) {
		max -= min;
		val -= min;
		double slc = max / (double) precision;
		return (char) RoboMath.boundIt((int) Math.round(val / slc), 0D,
				precision);
	}

	private double unsqueeze(double val, double min, double max, int precision) {
		max -= min;
		double slc = max / (double) precision;
		val *= slc;
		return val += min;
	}

	public static void saveDebugGraphs() {
	}

	public static void debugGraphs() {
		if (AxeBot.DEBUG_GRAPHS) {
			debugGraph("SHORT ALL-HITS", numAllHits, allHits);
			debugGraph("LONG ALL-HITS", numAllHits, longAllHits);

			for (int j = 0; j < DISTS; j++) {
				for (int k = 0; k < VELS; k++) {
					for (int l = 0; l < ACCS; l++) {
						for (int m = 0; m < BULL_PWR; m++) {
							for (int n = 0; n < WALLS; n++) {
								for (int p = 0; p < HEADS; p++) {
									debugGraph("DIST:" + j + " VEL:" + k
											+ " ACC:" + l + " HED:" + p,
											numHits[j][k][l][m][n][p],
											hits[j][k][l][m][n][p]);
								}
							}
						}
					}
				}
			}
		}
	}

	private static void debugGraph(String title, int qtd, double val[]) {
	}

	public void load(String name) {
		if (name == null) {
			return;
		}
		DataInputStream r = null;
		GZIPInputStream zipin = null;
		try {

			int cont = 0;
			while (true) {
				try {
					zipin = AxeFiles.getGZipInputStream(name
							+ AxeFiles.GFS_FILE_EXTENSION);
					break;
				} catch (SecurityException th) {
					AxeBot.getIt().suicideSolution();
					cont++;
					AxeBot.getIt().out
							.println(" XXXXXXXXXXXXXXXXXX SecurityException. try:"
									+ cont
									+ "/30 reason:"
									+ th.getMessage()
									+ " tipo:" + th.getClass());
					StackTraceElement st[] = th.getStackTrace();
					for (int i = 0; i < st.length; i++) {
						AxeBot.getIt().out.println(st[i]);
					}
					if (cont >= 30) {
						throw new InterruptedIOException(
								"LOADING ABORTED TO FILE:" + name
										+ AxeFiles.GFS_FILE_EXTENSION);
					}
				} catch (FileNotFoundException fnf) {
					throw new InterruptedIOException("File not Found:" + name
							+ AxeFiles.GFS_FILE_EXTENSION);

				} catch (Throwable th) {
					cont++;
					AxeBot.getIt().out
							.println(" XXXXXXXXXXXXXXXXXX loading failed. try:"
									+ cont + "/30 reason:" + th.getMessage()
									+ " tipo:" + th.getClass());
					StackTraceElement st[] = th.getStackTrace();
					for (int i = 0; i < st.length; i++) {
						AxeBot.getIt().out.println(st[i]);
					}
					if (cont >= 30) {
						throw new InterruptedIOException(
								"LOADING ABORTED TO FILE:" + name
										+ AxeFiles.GFS_FILE_EXTENSION);
					}
				}
			}

			//zipin.getNextEntry();
			r = new DataInputStream(zipin); //new FileInputStream(f));
			//HISTORY v2.43: NOVO LOAD COMPRESSED
			this.loadCompressed(r);

			headOnWarmingUp = -1;
			AxeBot.getIt().out
					.println("Data acquisition completed successfully for tageted enemy: "
							+ name + ". Engaging...");

			SegmentedGFs.debugGraphs();

		} catch (Throwable e) {
			AxeBot.getIt().out.println("IOException, trying to read: " + e);
			this.prePopulate();
			headOnWarmingUp = 2;

		} finally {
			try {
				r.close();
			} catch (Throwable e2) {
			}
			try {
				zipin.close();
			} catch (Throwable e2) {
			}
		}

	}

	private void loadCompressed(DataInputStream r) throws IOException {
		OptimizedBitBuffer buf = new OptimizedBitBuffer();
		buf.loadFrom(r);

		boolean hot = buf.get(1) == 1 ? true : false;

		int gfSavePrecision = (hot
				? HOT_GF_SAVING_PRECISION
				: GF_SAVING_PRECISION);

		int gfbitlen = RoboMath.countBits(gfSavePrecision);
		int amtbitlen = RoboMath.countBits(SAMPLES_AMT_SAVING_PRECISION);
		int longamtbitlen = RoboMath
				.countBits(SAMPLES_LONGAMT_SAVING_PRECISION);
		int minmaxbitlen = RoboMath.countBits(MINMAX_SAVING_PRECISION);

		numAllHits = buf.get(longamtbitlen);

		double graphMin = buf.get(minmaxbitlen)
				/ (double) MINMAX_SAVING_PRECISION;
		double graphMax = buf.get(minmaxbitlen)
				/ (double) MINMAX_SAVING_PRECISION;
		for (int i = 0; i < GF_QT; i++) {
			allHits[i] = unsqueeze(buf.get(gfbitlen), graphMin, graphMax,
					gfSavePrecision);
		}

		graphMin = buf.get(minmaxbitlen) / (double) MINMAX_SAVING_PRECISION;
		graphMax = buf.get(minmaxbitlen) / (double) MINMAX_SAVING_PRECISION;
		for (int i = 0; i < GF_QT; i++) {
			longAllHits[i] = unsqueeze(buf.get(gfbitlen), graphMin, graphMax,
					gfSavePrecision);
		}
		if (!hot) {
			for (int j = 0; j < DISTS; j++) {
				for (int k = 0; k < VELS; k++) {
					for (int l = 0; l < ACCS; l++) {
						for (int m = 0; m < BULL_PWR; m++) {
							for (int n = 0; n < WALLS; n++) {
								for (int p = 0; p < HEADS; p++) {
									numHits[j][k][l][m][n][p] = buf
											.get(amtbitlen);
									if (numHits[j][k][l][m][n][p] > 0) {
										graphMin = buf.get(minmaxbitlen)
												/ (double) MINMAX_SAVING_PRECISION;
										graphMax = buf.get(minmaxbitlen)
												/ (double) MINMAX_SAVING_PRECISION;
										//System.out.println("min:"+graphMin+"
										// max:"+graphMax );
										for (int i = 0; i < GF_QT; i++) {
											hits[j][k][l][m][n][p][i] = unsqueeze(
													buf.get(gfbitlen),
													graphMin, graphMax,
													gfSavePrecision);
										}
									}
								}
							}
						}
					}
				}
			}
		}

	}

	/**
	 *  
	 */
	private void prePopulate() {
		int gf = SegmentedGFs.GF_QT / 2;
		updateAllHits(10, gf);
		updateAllHits(10, gf);

	}

	//	ALTERADO: PARAMETRO REDUZIDO PARA EW.
	public static double[] getHits(EnemyWave wav) {
		return hits[getDistIndex(wav.getOriginalDistance())][getVelIndex(wav
				.getVelocity())][getAccIndex(wav.getAcceleration())][getBulletPwrIndex(wav
				.getBulletPower())][getWallsIndex(wav.getDistToWall())][getHeadsIndex(wav
				.getMyAttackAngle())];
	}

	//	ALTERADO: (2004/10/14)
	public static double[] getNotEmptyHits(EnemyWave wav) {

		final int SEARCH_DIST = 0;
		final int SEARCH_ACC = 1;
		final int SEARCH_VEL = 2;
		final int SEARCH_END = 3;
		int searchSeg = 0;

		int d = getDistIndex(wav.getOriginalDistance());
		int v = getVelIndex(wav.getVelocity());
		int a = getAccIndex(wav.getAcceleration());
		int bp = getBulletPwrIndex(wav.getBulletPower());
		int wa = getWallsIndex(wav.getDistToWall());
		int aa = getHeadsIndex(wav.getMyAttackAngle());

		int q;
		int searchWd = 1;
		int d1 = d, v1 = v, a1 = a, bp1 = bp, wa1 = wa, aa1 = aa;
		int segTry = 1;
		LOOP : while ((q = numHits[d1][v1][a1][bp1][wa1][aa1]) == 0) {

			d1 = d;
			v1 = v;
			a1 = a;
			bp1 = bp;
			wa1 = wa;
			aa1 = aa;
			//	        System.out.println("*search:"+searchSeg+" d:"+d1+" v:"+v1+"
			// a:"+a1+ " searchWd:"+searchWd+" segTry"+segTry);
			switch (searchSeg) {
				case SEARCH_DIST :
					do {
						d1 = d + searchWd;
						searchWd *= -1;
						searchWd += (searchWd >= 0) ? 1 : 0;
					} while (d1 < 0 || d1 >= DISTS);
					segTry++;
					if (segTry >= DISTS) {
						segTry = 1;
						searchSeg++;
						searchWd = 1;
						//	                    d1=d;
					}
					break;
				case SEARCH_ACC :
					do {
						a1 = a + searchWd;
						searchWd *= -1;
						searchWd += (searchWd >= 0) ? 1 : 0;

					} while (a1 < 0 || a1 >= ACCS);
					segTry++;
					if (segTry >= ACCS) {
						segTry = 1;
						searchSeg++;
						searchWd = 1;
						//	                    a1=a;
					}
					break;
				case SEARCH_VEL :
					do {
						v1 = v + searchWd;
						searchWd *= -1;
						searchWd += (searchWd >= 0) ? 1 : 0;
					} while (v1 < 0 || v1 >= VELS);
					segTry++;
					if (segTry >= VELS) {
						segTry = 1;
						searchSeg++;
						searchWd = 1;
						//	                    v1=v;
					}
					break;
				case SEARCH_END :
					break LOOP;
			}
			//	        System.out.println("search:"+searchSeg+" d:"+d1+" v:"+v1+"
			// a:"+a1);
		}

		return (q == 0) ? null : hits[d1][v1][a1][bp1][wa1][aa1];
	}

	//	ALTERADO: APRENDIZADO RAPIDO
	//	public static double[] getDistHits(EnemyWave wav) {
	//		return distHits[getDistIndex(wav.getOriginalDistance())];
	//	}
	//	
	//	public static double[] getVelHits(EnemyWave wav) {
	//		return velHits[getVelIndex(wav.getVelocity ())];
	//	}
	//	
	//	public static double[] getAccHits(EnemyWave wav) {
	//		return accHits[getAccIndex(wav.getAcceleration ())];
	//	}

	//	public double[] getHits(int dist, int vel, int acc, double bullPwr, int
	// distToWall) {
	//		return hits[this.getDistIndex(dist)][this.getVelIndex(vel)][this
	//				.getAccIndex(acc)][this.getBulletPwrIndex(bullPwr)][this.getWallsIndex(distToWall)];
	//	}
	//	ALTERADO: PARAMETRO REDUZIDO PARA EW.
	public static double getQtdHits(EnemyWave wav) {//int dist, int vel, int
		// acc, double bullPwr, int
		// distToWall) {
		//		return numHits[this.getDistIndex(dist)][this.getVelIndex(vel)][this
		//				.getAccIndex(acc)][this.getBulletPwrIndex(bullPwr)][this.getWallsIndex(distToWall)];
		return numHits[getDistIndex(wav.getOriginalDistance())][getVelIndex(wav
				.getVelocity())][getAccIndex(wav.getAcceleration())][getBulletPwrIndex(wav
				.getBulletPower())][getWallsIndex(wav.getDistToWall())][getHeadsIndex(wav
				.getMyAttackAngle())];
	}

	public static double[] getAllHits() {
		return allHits;
	}

	public static double[] getLongAllHits() {
		return longAllHits;
	}

}