package org.bolson.vote;

/**
 * GNU LESSER GENERAL PUBLIC LICENSE
                       Version 3, 29 June 2007

 Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.


  This version of the GNU Lesser General Public License incorporates
the terms and conditions of version 3 of the GNU General Public
License, supplemented by the additional permissions listed below.

  0. Additional Definitions.

  As used herein, "this License" refers to version 3 of the GNU Lesser
General Public License, and the "GNU GPL" refers to version 3 of the GNU
General Public License.

  "The Library" refers to a covered work governed by this License,
other than an Application or a Combined Work as defined below.

  An "Application" is any work that makes use of an interface provided
by the Library, but which is not otherwise based on the Library.
Defining a subclass of a class defined by the Library is deemed a mode
of using an interface provided by the Library.

  A "Combined Work" is a work produced by combining or linking an
Application with the Library.  The particular version of the Library
with which the Combined Work was made is also called the "Linked
Version".

  The "Minimal Corresponding Source" for a Combined Work means the
Corresponding Source for the Combined Work, excluding any source code
for portions of the Combined Work that, considered in isolation, are
based on the Application, and not on the Linked Version.

  The "Corresponding Application Code" for a Combined Work means the
object code and/or source code for the Application, including any data
and utility programs needed for reproducing the Combined Work from the
Application, but excluding the System Libraries of the Combined Work.

  1. Exception to Section 3 of the GNU GPL.

  You may convey a covered work under sections 3 and 4 of this License
without being bound by section 3 of the GNU GPL.

  2. Conveying Modified Versions.

  If you modify a copy of the Library, and, in your modifications, a
facility refers to a function or data to be supplied by an Application
that uses the facility (other than as an argument passed when the
facility is invoked), then you may convey a copy of the modified
version:

   a) under this License, provided that you make a good faith effort to
   ensure that, in the event an Application does not supply the
   function or data, the facility still operates, and performs
   whatever part of its purpose remains meaningful, or

   b) under the GNU GPL, with none of the additional permissions of
   this License applicable to that copy.

  3. Object Code Incorporating Material from Library Header Files.

  The object code form of an Application may incorporate material from
a header file that is part of the Library.  You may convey such object
code under terms of your choice, provided that, if the incorporated
material is not limited to numerical parameters, data structure
layouts and accessors, or small macros, inline functions and templates
(ten or fewer lines in length), you do both of the following:

   a) Give prominent notice with each copy of the object code that the
   Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the object code with a copy of the GNU GPL and this license
   document.

  4. Combined Works.

  You may convey a Combined Work under terms of your choice that,
taken together, effectively do not restrict modification of the
portions of the Library contained in the Combined Work and reverse
engineering for debugging such modifications, if you also do each of
the following:

   a) Give prominent notice with each copy of the Combined Work that
   the Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the Combined Work with a copy of the GNU GPL and this license
   document.

   c) For a Combined Work that displays copyright notices during
   execution, include the copyright notice for the Library among
   these notices, as well as a reference directing the user to the
   copies of the GNU GPL and this license document.

   d) Do one of the following:

       0) Convey the Minimal Corresponding Source under the terms of this
       License, and the Corresponding Application Code in a form
       suitable for, and under terms that permit, the user to
       recombine or relink the Application with a modified version of
       the Linked Version to produce a modified Combined Work, in the
       manner specified by section 6 of the GNU GPL for conveying
       Corresponding Source.

       1) Use a suitable shared library mechanism for linking with the
       Library.  A suitable mechanism is one that (a) uses at run time
       a copy of the Library already present on the user's computer
       system, and (b) will operate properly with a modified version
       of the Library that is interface-compatible with the Linked
       Version.

   e) Provide Installation Information, but only if you would otherwise
   be required to provide such information under section 6 of the
   GNU GPL, and only to the extent that such information is
   necessary to install and execute a modified version of the
   Combined Work produced by recombining or relinking the
   Application with a modified version of the Linked Version. (If
   you use option 4d0, the Installation Information must accompany
   the Minimal Corresponding Source and Corresponding Application
   Code. If you use option 4d1, you must provide the Installation
   Information in the manner specified by section 6 of the GNU GPL
   for conveying Corresponding Source.)

  5. Combined Libraries.

  You may place library facilities that are a work based on the
Library side by side in a single library together with other library
facilities that are not Applications and are not covered by this
License, and convey such a combined library under terms of your
choice, if you do both of the following:

   a) Accompany the combined library with a copy of the same work based
   on the Library, uncombined with any other library facilities,
   conveyed under the terms of this License.

   b) Give prominent notice with the combined library that part of it
   is a work based on the Library, and explaining where to find the
   accompanying uncombined form of the same work.

  6. Revised Versions of the GNU Lesser General Public License.

  The Free Software Foundation may publish revised and/or new versions
of the GNU Lesser General Public License from time to time. Such new
versions will be similar in spirit to the present version, but may
differ in detail to address new problems or concerns.

  Each version is given a distinguishing version number. If the
Library as you received it specifies that a certain numbered version
of the GNU Lesser General Public License "or any later version"
applies to it, you have the option of following the terms and
conditions either of that published version or of any later version
published by the Free Software Foundation. If the Library as you
received it does not specify a version number of the GNU Lesser
General Public License, you may choose any version of the GNU Lesser
General Public License ever published by the Free Software Foundation.

  If the Library as you received it specifies that a proxy can decide
whether future versions of the GNU Lesser General Public License shall
apply, that proxy's public statement of acceptance of any version is
permanent authorization for you to choose that version for the
Library.
 */

/**
 * Implements the Condorcet method of ranked voting tabulation
 * and beatpath tie resolution based on Ratings, as suggested by James Green-Armytage
 @author Brian Olson
 */
public class CondorcetRTB extends Condorcet {
	private static final long serialVersionUID = -6835854872862284307L;
	protected int talley[];
	protected double dtalley[];
	protected double bpm[];
	String message = null;
	int[] winners = null;
    public CondorcetRTB( int numCandidates ) {
    	super( numCandidates );
		talley = new int[numc*numc];
		dtalley = new double[numc*numc];
		for ( int i = 0; i < numc*numc; i++ ) {
			talley[i] = 0;
			dtalley[i] = 0.0;
		}
    }
	public String name() {
		return "Condorcet + Rated Beatpath Cycle Resolution";
	}
	
    public int voteRating( int rating[] ) {
		int j, k;
		winners = null;
		// foreach pair of candidates, vote 1-on-1
		for ( j = 0; j < numc; j++ ) {
			for ( k = j + 1; k < numc; k++ ) {
				int pk, pj;
				pk = rating[k];
				pj = rating[j];
				if ( pk > pj ) {
					talley[k*numc + j]++;	// k beats j
					dtalley[k*numc + j] += pk - pj;
				} else if ( pj > pk ) {
					talley[j*numc + k]++;	// j beats k
					dtalley[j*numc + k] += pj - pk;
				}
			}
		}
		return 0;
    }
    public int voteRating( float rating[] ) {
		int j, k;
		winners = null;
		// foreach pair of candidates, vote 1-on-1
		for ( j = 0; j < numc; j++ ) {
			for ( k = j + 1; k < numc; k++ ) {
				float pk, pj;
				pk = rating[k];
				pj = rating[j];
				if ( pk > pj ) {
					talley[k*numc + j]++;	// k beats j
					dtalley[k*numc + j] += pk - pj;
				} else if ( pj > pk ) {
					talley[j*numc + k]++;	// j beats k
					dtalley[j*numc + k] += pj - pk;
				}
			}
		}
		return 0;
    }
    public int voteRating( double rating[] ) {
		int j, k;
		winners = null;
		// foreach pair of candidates, vote 1-on-1
		for ( j = 0; j < numc; j++ ) {
			for ( k = j + 1; k < numc; k++ ) {
				double pk, pj;
				pk = rating[k];
				pj = rating[j];
				if ( pk > pj ) {
					talley[k*numc + j]++;	// k beats j
					dtalley[k*numc + j] += pk - pj;
				} else if ( pj > pk ) {
					talley[j*numc + k]++;	// j beats k
					dtalley[j*numc + k] += pj - pk;
				}
			}
		}
		return 0;
    }
    
    public int[] getWinners() {
		if ( winners != null ) {
			return winners;
		}
	int defeatCount[];
	/* ndefeats is "numc choose 2" or ((numc !)/((2 !)*((numc - 2)!))) */
	@SuppressWarnings("unused")
	int ndefeats = (numc*(numc-1))/2, dpos = 0;
	int j,k;
	int numWinners;
	int choiceIndecies[] = new int[numc];
	message = null;
    
	defeatCount = new int[numc];
	for ( j = 0; j < numc; j++ ) {
	    defeatCount[j] = 0;
	}
	for ( j = 0; j < numc; j++ ) {
	    for ( k = j + 1; k < numc; k++ ) {
		int vk, vj;
		vk = talley[k*numc + j];	// k beat j vk times
		vj = talley[j*numc + k];	// j beat k vj times
		if ( vj > vk ) {
		    defeatCount[k]++;
		} else if ( vj < vk ) {
		    defeatCount[j]++;
		}
	    }
	}
	ndefeats = dpos;
	numWinners = 0;
	for ( j = 0; j < numc; j++ ) {
	    if ( defeatCount[j] == 0 ) {
		choiceIndecies[numWinners] = j;
		numWinners++;
	    }
	}
	if ( numWinners > 1 ) {
	} else if ( numWinners == 0 ) {
		StringBuffer msg = new StringBuffer("no clear winner, defeats={ ");
		for ( j = 0; j < numc; j++ ) {
			msg.append(defeatCount[j]);
			if ( j < (numc - 1) ) {
				msg.append(", ");
			}
		}
		msg.append(" }, running preference-differential beatpath");
		message = msg.toString();
	    double winsize = -1.0 * Double.MAX_VALUE;
	    bpm = new double[numc*numc];
	    runBeatpath( talley, dtalley, bpm, numc, 0 );
	    for ( j = 0; j < numc; j++ ) {
			double winsizet;
			winsizet = -1.0 * Double.MAX_VALUE;
			defeatCount[j] = 0;
			for ( k = 0; k < numc; k++ ) if ( k != j ) {
				double bpmt = bpm[j*numc + k];
				if ( bpmt == 0 ) {
					defeatCount[j]++;
				} else if ( bpmt > winsizet ) {
					winsizet = bpmt;
				}
			}
			if ( defeatCount[j] == 0 ) {
				if ( winsizet > winsize ) {
					choiceIndecies[0] = j;
					numWinners = 1;
					winsize = winsizet;
				} else if ( winsizet == winsize ) {
					choiceIndecies[numWinners] = j;
					numWinners++;
					//winsize = winsizet;
				}
			}
	    }
	}
/*    if ( 0 ) {
	if ( numWinners == 0 ) {
	    static int cErrCount = 0;
	    static char cErrFileName[32];
	    snprintf( cErrFileName, sizeof(cErrFileName), "condorcetError%.10d", cErrCount );
	    voterBinDump( cErrFileName, they, numv, numc );
	}
    }*/
/*    if ( 0 ) {
	if ( winner == -1 ) {
	    printf("no Condorcet-beatpath winner, bpm array:\n");
	    for ( j = 0; j < numc; j++ ) {
		printf("dc(%d)\t", defeatCount[j] );
		for ( k = 0; k < numc; k++ ) {
		    printf("%d\t", bpm[j*numc + k] );
		}
		printf("\n");
	    }
	    printf("\ntalley array:\n");
	    for ( j = 0; j < numc; j++ ) {
		for ( k = 0; k < numc; k++ ) {
		    printf("%d\t", talley[j*numc + k] );
		}
		printf("\n");
	    }
	    printf("\n");
	}
    }*/
	winners = new int[numWinners];
	for ( int i = 0; i < numWinners; i++ ) {
	    winners[i] = choiceIndecies[i];
	}
	return winners;
    }

static int umin( int a, int b ) {
    if ( a < b ) {
	return a;
    } else {
	return b;
    }
}
static double umin( double a, double b ) {
    if ( a < b ) {
		return a;
    } else {
		return b;
    }
}
/**
 * bpm Beat Path Matrix, filled in as we go.
 */
static void runBeatpath( int talley[], double dtalley[], double bpm[], int numc, int depth ) {
    int j, k;
    // foreach pair of candidates
    boolean notDone = true;
    for ( j = 0; j < numc; j++ ) {
		bpm[j*numc + j] = 0;
		for ( k = j + 1; k < numc; k++ ) {
			int vj, vk;
			vk = talley[k*numc + j];	// k beat j vk times
			vj = talley[j*numc + k];	// j beat k vj times
			if ( vk > vj ) {
				bpm[k*numc + j] = dtalley[k*numc + j];
				bpm[j*numc + k] = 0;
			} else if ( vj > vk ) {
				bpm[k*numc + j] = 0;
				bpm[j*numc + k] = dtalley[j*numc + k];
			} else /* vj == vk */ {
				bpm[k*numc + j] = 0;
				bpm[j*numc + k] = 0;
			}
		}
    }

    while ( notDone ) {
		notDone = false;
		/*if ( 0 ) {
		for ( j = 0; j < numc; j++ ) {
			for ( k = 0; k < numc; k++ ) {
				printf("%d\t", bpm[j*numc + k] );
			}
			printf("\n");
		}
		printf("\n");
		}*/
		for ( j = 0; j < numc; j++ ) {
			for ( k = 0; k < numc; k++ ) if ( k != j ) {
				double vk;
				vk = bpm[k*numc + j];	// candidate k > j
				if ( vk != 0 ) {
					// sucessful beat, see if it can be used to get a better beat over another
					for ( int l = 0; l < numc; l++ ) if ( l != j && l != k ) { // don't care about self (k) or same (j)
						double vl;
						vl = umin( bpm[j*numc + l], vk );	// j > l
						if ( /*vl != 0 &&*/ vl > bpm[k*numc + l] ) {
							// better beat path found
							//			    printf("set bpm[%d * %d + %d] = %d\n", k, numc, l, vl);
							bpm[k*numc + l] = vl;
							notDone = true;
						}
					}
				}
			}
		}
    }
	for ( j = 0; j < numc; j++ ) {
		for ( k = j + 1; k < numc; k++ ) {
			double vj, vk;
			vk = bpm[k*numc + j];
			vj = bpm[j*numc + k];
			if ( vk > vj ) {
				//bpm[k*numc + j] = vk;
				bpm[j*numc + k] = 0;
			} else if ( vj > vk ) {
				bpm[k*numc + j] = 0;
				//bpm[j*numc + k] = vj;
			}
		}
	}
/*if ( 0 ) {
    for ( j = 0; j < numc; j++ ) {
	for ( k = 0; k < numc; k++ ) {
	    printf("%d\t", bpm[j*numc + k] );
	}
	printf("\n");
    }
}*/
}

public String toString() {
    StringBuffer sb = new StringBuffer();
    for ( int i = 0; i < numc; i++ ) {
	for ( int ii = 0; ii < numc; ii++ ) {
	    sb.append( talley[i*numc + ii] );
	    sb.append( '\t' );
	}
	sb.append( '\n' );
    }
    return sb.toString();
}    
public String toString( String names[] ) {
    if ( names == null ) return toString();
    StringBuffer sb = new StringBuffer();
    for ( int i = 0; i < numc; i++ ) {
	sb.append( names[i] ).append( '\t' );
	for ( int ii = 0; ii < numc; ii++ ) {
	    sb.append( talley[i*numc + ii] );
	    sb.append( '\t' );
	}
	sb.append( '\n' );
    }
    return sb.toString();
}

public static StringBuffer htmlTable( StringBuffer sb, int numc, double[] arr, String title, String names[] ) {
	if ( names != null ) {
	    sb.append( "<table border=\"1\"><tr><th></th><th colspan=\"" );
	} else {
	    sb.append( "<table border=\"1\"><tr><th>Choice Index</th><th colspan=\"");
	}
	sb.append( numc );
	sb.append("\">");
	sb.append( title );
	sb.append("</th></tr>\n" );
	for ( int i = 0; i < numc; i++ ) {
		sb.append("<tr><td>");
		if ( names != null ) {
			sb.append( names[i] );
		} else {
			sb.append( i );
		}
		sb.append("</td>");
		for ( int j = 0; j < numc; j++ ) {
			if ( (i == j) && (arr[i*numc + j] == 0) ) {
				sb.append("<td bgcolor=\"#ffffff\"></td>");
			} else {
				if ( arr[i*numc + j] > arr[j*numc + i] ) {
					sb.append("<td bgcolor=\"#bbffbb\">");
				} else if ( arr[i*numc + j] < arr[j*numc + i] ) {
					sb.append("<td bgcolor=\"#ffbbbb\">");
				} else {
					sb.append("<td>");
				}
				sb.append(arr[i*numc + j]);
				sb.append("</td>");
			}
		}
		sb.append("</tr>\n");
	}
	sb.append("</table>\n");
	return sb;
}

public String htmlSummary( String names[] ) {
	StringBuffer sb;
	sb = new StringBuffer(1024);
	htmlTable( sb, numc, talley, "Condorcet Vote Array", names );
	if ( message != null ) {
		sb.append(message);
		htmlTable( sb, numc, dtalley, "Rating Differential Array", names );
		htmlTable( sb, numc, bpm, "Beat-Path Results Array", names );
	}
    return sb.toString();
}
};
