package theo.simple.utils;
import java.awt.geom.Point2D;
import java.util.*;
import robocode.*;
import robocode.util.Utils;
/**
 * botUtils - a class by Damij
 */
public class botUtils
{

	public static double force(double dist, double weight){
		return (weight/(dist*dist));
	}

	public static double absAngle(Point2D.Double source, Point2D.Double target){
		return Utils.normalAbsoluteAngle(Math.atan2(target.x-source.x,target.y-source.y));
	}
	
	public static double absBearing(Point2D.Double source, Point2D.Double target){
		return Utils.normalRelativeAngle(Math.atan2(target.x-source.x,target.y-source.y));
	}

	public static Point2D.Double project(Point2D.Double source, double distance, double theta){
		return new Point2D.Double(source.x+distance*Math.sin(theta),source.y+distance*Math.cos(theta));
	}

	public static double limit(double low, double mid, double high){
		if(low<high){
			return Math.max(Math.min(high,mid),low);
		}
		else{
			return Math.max(Math.min(low,mid),high);
		}
	}
	
	public static double bSpeed(double pow){
		return (20 - 3*pow);
	}

	public static double distance(double[] a, double[] b){
		double dist = 0;
		for (int i = 0; i < a.length; i ++){
			//dist += (a[i]-b[i]) * (a[i]-b[i]);
			dist += Math.abs(a[i]-b[i]);
		}
		return dist;
	}

	public static List<Double> findNearestSurfNeighbors(double[] a, HashMap<double[],Double> factorMap, long NUM_NEIGHBORS){
		//solveSet.clear(); /*keySet.clear();*/ nnFactor.clear();
		Object[] keySet = factorMap.keySet().toArray();
		List<double[]> solveSet;
		List<Double> nnFactor;
		solveSet = new ArrayList<double[]>();
		nnFactor = new ArrayList<Double>();
		/*for(int i = 0; i < factorMap.keySet().size(); i ++){
			keySet.add((double[])factorMap.keySet().toArray()[i]);
		}*/
		int maxIndex = 0;
		double dist = 0, maxDist = 0;
		double tempDist = 0;
		for (int i = 0; i < Math.min(NUM_NEIGHBORS,keySet.length); i ++){
			//double[] neighbor = (double[])keySet.get(i);
			double[] neighbor = (double[])keySet[i];
			nnFactor.add(factorMap.get(neighbor));
			solveSet.add(neighbor);
			if(distance(neighbor,a)>maxDist){
				maxDist = distance(neighbor,a);
				maxIndex = nnFactor.indexOf(factorMap.get(neighbor));
			}
		}
		for(int q = (int)NUM_NEIGHBORS; q < keySet.length; q++){
			//double[] vals = keySet.get(q);
			double[] vals = (double [])keySet[q];
			dist = distance(vals, a);
			if (dist < maxDist){
				nnFactor.set(maxIndex, factorMap.get(vals));
				solveSet.set(maxIndex, vals);
				tempDist = 0;
				for (int i = 0; i < solveSet.size(); i ++){
					double[] neighbor = solveSet.get(i);
					if(distance(neighbor,a)>tempDist){
						maxDist = distance(neighbor,a);
						tempDist = maxDist;
						maxIndex = i;
					}
				}
			}
		}
		
		//System.out.println("FactorLength " + keySet.length);
		//System.out.println("NSize " + nnFactor.size());
		return nnFactor;
	}

}
