/*
 * Decompiled with CFR 0.152.
 */
package rjw;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import rjw.AbstractComponent;
import rjw.RabidWombat;
import rjw.pluggablerobot.Canvas;
import rjw.pluggablerobot.EventListener;
import rjw.pluggablerobot.Hud;
import rjw.radar.Enemy;
import rjw.radar.EnemyScan;
import rjw.radar.EnemyWave;
import rjw.util.Particle;
import rjw.util.Wave;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;

public class Memory
extends AbstractComponent
implements EventListener.HitByBullet,
EventListener.BulletHit,
EventListener.HitRobot,
Hud.Painter {
    private Enemy _target;
    private ArrayList<EnemyWave> _waves = new ArrayList();

    public Memory(RabidWombat bot) {
        super(bot);
    }

    public void enemyScan(ScannedRobotEvent event, Particle origin) {
        EnemyScan scan = new EnemyScan(event, origin);
        if (this._target == null) {
            this._target = new Enemy(scan);
            return;
        }
        this._target.addScan(scan);
    }

    @Override
    public void notifyHitByBullet(HitByBulletEvent event) {
        if (this._target != null) {
            this._target.notifyHitMe(event.getBullet().getPower());
        }
    }

    @Override
    public void notifyBulletHit(BulletHitEvent event) {
        if (this._target != null) {
            this._target.notifyBulletHit(event.getBullet().getPower());
        }
    }

    @Override
    public void notifyHitRobot(HitRobotEvent event) {
        if (this._target != null) {
            this._target.notifyRobotCollision();
        }
    }

    @Override
    public void go() {
        if (this.getBot().getOthers() == 0) {
            this.getBot().victoryDance();
            return;
        }
        if (this._target == null) {
            return;
        }
        EnemyWave wave = this._target.fireCheck(this.getBot());
        if (wave != null) {
            this._waves.add(wave);
        }
    }

    public List<EnemyWave> getWaves() {
        return this._waves;
    }

    public void cleanUpOldWaves(Point2D.Double currentPosition, long currentTick) {
        ListIterator<EnemyWave> iter = this._waves.listIterator();
        while (iter.hasNext()) {
            Wave wave = iter.next();
            if (!wave.isPassed(currentPosition, currentTick)) continue;
            iter.remove();
        }
    }

    public Enemy getTarget() {
        return this._target;
    }

    @Override
    public void paint(Canvas canvas, long tick) {
        for (EnemyWave wave : this._waves) {
            wave.draw(canvas, tick);
        }
    }
}

