/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Iterator;
import pedersen.core.Constraints;
import pedersen.core.Foundation;
import pedersen.core.Targetable;
import pedersen.core.TargetableBase;
import pedersen.debug.Debug;
import pedersen.debug.GraphicalDebugger;
import pedersen.debug.profiling.Stopwatches;
import pedersen.divination.FiringAngle;
import pedersen.divination.WaveOutboundBank;
import pedersen.divination.WaveOutboundImpl;
import pedersen.misc.Host;
import pedersen.opponent.Target;
import pedersen.physics.DynamicHeadingImpl;
import pedersen.physics.Projection;
import pedersen.physics.StaticHeadingImpl;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVector;
import pedersen.systems.DrivingMethod;
import pedersen.systems.DrivingMethodStandardImpl;
import pedersen.systems.ScanningMethod;
import pedersen.systems.ScanningMethodLockImpl;
import pedersen.systems.ScanningMethodPassiveImpl;
import pedersen.systems.ScanningMethodStandardImpl;
import pedersen.tactics.grail.Grid;
import pedersen.tactics.grail.GridSector;
import pedersen.tactics.movement.MovementMethodSet;
import pedersen.tactics.movement.impl.MovementMethodGridImpl;
import pedersen.tactics.targeting.FiringSolution;
import pedersen.tactics.targeting.TargetingMethod;

public class Combatant
extends TargetableBase
implements Targetable {
    private DrivingMethod chassis = null;
    private ScanningMethod scanner = null;
    private boolean performanceStatisticsTracking = false;
    private Projection projection = null;
    private Target target = null;
    private FiringSolution firingSolution = null;
    private WaveOutboundImpl outboundWave = null;
    protected long paintingScalar = 1L;
    private static int initialGracePeriod;
    private static int gracePeriod;
    private static long gracePeriodIncrementFrequency;
    private static final double targetReaquisitionDistance = 75.0;
    private static final Combatant singleton;

    static {
        gracePeriod = initialGracePeriod = 3;
        gracePeriodIncrementFrequency = 5L;
        singleton = new Combatant();
    }

    private Combatant() {
    }

    public void operate(Foundation robot) {
        Stopwatches.combatantOperate.start();
        if (this.target != null && Host.singleton.getTurn() - this.target.getLastUpdate() > 10L) {
            this.setTarget(null, robot);
        }
        Stopwatches.combatantOperateGun.start();
        if (this.outboundWave != null) {
            WaveOutboundBank.singleton.add(this.outboundWave);
        }
        double turretAbsoluteHeading = Host.singleton.getTurretHeading();
        if (this.target != null && this.firingSolution != null && Host.singleton.isGunCool() && this.target.getFireControl().readyToFire(this, turretAbsoluteHeading, this.target, this.firingSolution)) {
            double firepower = Constraints.getClosestLegalFirepower(this.firingSolution.getFirepower());
            this.outboundWave.setLiveRound();
            Host.singleton.fireGun(firepower);
            this.scanner.resetScanCycle();
        }
        Stopwatches.combatantOperateGun.stop();
        Stopwatches.combatantOperateChassis.start();
        StaticVector vehicleRelativeVectorChange = this.chassis.operate(this, this.target, Host.singleton.getTurn());
        this.chassis.recordTime();
        this.projection = new Projection(this);
        double vehicleRelativeHeadingChange = vehicleRelativeVectorChange.getHeading();
        double vehicleRelativeVelocityChange = vehicleRelativeVectorChange.getVelocity();
        this.projection.setRelativeTargetHeading(vehicleRelativeHeadingChange);
        this.projection.setRelativeTargetVelocity(vehicleRelativeVelocityChange);
        this.projection.project();
        double projectedVelocity = this.projection.getVelocity();
        vehicleRelativeHeadingChange = projectedVelocity == 0.0 ? 0.0 : this.getRelativeAngle(this.projection.getHeading());
        Stopwatches.combatantOperateChassis.stop();
        Stopwatches.combatantOperateTurret.start();
        double turretRelativeHeadingChange = this.operateTurret(turretAbsoluteHeading + vehicleRelativeHeadingChange);
        Stopwatches.combatantOperateTurret.stop();
        Stopwatches.combatantOperateScanner.start();
        double scannerAbsoluteHeading = Host.singleton.getScannerHeading();
        double scannerRelativeHeadingChange = this.scanner.getRelativeRotation(scannerAbsoluteHeading + vehicleRelativeHeadingChange + turretRelativeHeadingChange, this.projection.getStaticPosition(), this.target);
        Stopwatches.combatantOperateScanner.stop();
        Host.singleton.turnChassis(vehicleRelativeHeadingChange);
        Host.singleton.turnTurret(turretRelativeHeadingChange);
        Host.singleton.turnScanner(scannerRelativeHeadingChange);
        Host.singleton.setThrottle(projectedVelocity);
        Stopwatches.combatantOperate.stop();
    }

    public void scan(Target scan, Foundation robot) {
        double distanceToTargetNew;
        StaticPositionImpl combatantPosition;
        double distanceToTargetNow;
        if (this.target == null) {
            this.setTarget(scan, robot);
        } else if (!this.target.equals(scan) && (distanceToTargetNow = (combatantPosition = new StaticPositionImpl(Host.singleton.getChassisX(), Host.singleton.getChassisY())).getDistance(this.target)) - (distanceToTargetNew = combatantPosition.getDistance(scan)) > 75.0) {
            this.setTarget(scan, robot);
        }
    }

    public void onHitByBullet() {
        if (this.performanceStatisticsTracking) {
            this.chassis.recordHit();
        }
    }

    public void onEnemyFire() {
        if (this.performanceStatisticsTracking) {
            this.chassis.onEnemyFire();
        }
    }

    public void recalibrate(Foundation robot) {
        int activeTargets = Host.singleton.getActiveEnemyCount();
        MovementMethodSet aquiredMovementMethods = activeTargets == 1 && this.target != null ? this.target.getMovementMethods() : robot.getMovementMethods(activeTargets);
        this.chassis = new DrivingMethodStandardImpl(aquiredMovementMethods, gracePeriod);
        this.chassis.setPerformanceStatisticsTracking(this.performanceStatisticsTracking);
        this.scanner = activeTargets == 0 ? new ScanningMethodPassiveImpl() : (activeTargets == 1 ? new ScanningMethodLockImpl() : new ScanningMethodStandardImpl());
    }

    public void roundSetup() {
        MovementMethodGridImpl.setGridSector(new GridSector(this));
        Grid.singleton.generateNeighborConnections();
        gracePeriod = initialGracePeriod + (int)(Host.singleton.getRound() / gracePeriodIncrementFrequency);
        if (this.performanceStatisticsTracking) {
            this.setPerformanceStatisticsTracking(false);
        }
    }

    public void roundTeardown() {
        this.target = null;
    }

    public void teardown() {
    }

    public void retire(Target deadTarget, Foundation robot) {
        if (this.target != null && this.target.equals(deadTarget)) {
            this.setTarget(null, robot);
        }
    }

    public DrivingMethod getDrivingMethod() {
        return this.chassis;
    }

    public void setPerformanceStatisticsTracking(boolean on) {
        this.performanceStatisticsTracking = on;
        this.chassis.setPerformanceStatisticsTracking(this.performanceStatisticsTracking);
    }

    public void onPaint(Graphics2D console) {
        try {
            console.setColor(Color.darkGray);
            GraphicalDebugger.singleton.drawVehicleHitBox(console, new StaticPositionImpl(Host.singleton.getChassisX(), Host.singleton.getChassisY()));
        }
        catch (Exception ex) {
            Debug.line("Exception thrown: " + ex.toString());
        }
    }

    private double operateTurret(double absoluteHeading) {
        DynamicHeadingImpl turret = new DynamicHeadingImpl(absoluteHeading);
        long timeOfCreation = Host.singleton.getTurn() + 1L;
        this.firingSolution = null;
        this.outboundWave = null;
        if (this.target != null) {
            double bulletVelocity = this.target.getFireControl().getBulletVelocity(this.projection.getStaticPosition(), this.target);
            this.outboundWave = new WaveOutboundImpl(this, this.projection.getStaticPosition(), bulletVelocity, (Targetable)this.target, timeOfCreation);
            this.target.attachFiringAngles(this.outboundWave);
            TargetingMethod favoredTargetingMethod = this.target.getFavoredTargetingMethod();
            if (favoredTargetingMethod != null) {
                Iterator firingAngleIterator = this.outboundWave.getFiringAngleIterator();
                while (this.firingSolution == null && firingAngleIterator.hasNext()) {
                    FiringAngle firingAngle = (FiringAngle)firingAngleIterator.next();
                    if (!firingAngle.getTargetingMethod().equals(favoredTargetingMethod)) continue;
                    this.firingSolution = new FiringSolution(firingAngle, bulletVelocity);
                }
            }
            if (this.firingSolution != null) {
                turret.setAbsoluteTargetHeading(this.firingSolution.getFiringAngle());
            } else {
                turret.setAbsoluteTargetHeading(this.projection.getBearing(this.target));
            }
        } else {
            turret.setAbsoluteTargetHeading(this.projection.getHeading());
        }
        return turret.getRelativeAngle(new StaticHeadingImpl(turret.projectHeading(0.3490658503988659)));
    }

    private void setTarget(Target newTarget, Foundation robot) {
        this.target = newTarget;
        this.recalibrate(robot);
    }

    public static Combatant getCombatant() {
        return singleton;
    }
}

