/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.drive;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.Arrays;
import xander.core.drive.DirectDrivePredictor;
import xander.core.drive.DistancingEquation;
import xander.core.drive.DriveState;
import xander.core.event.Painter;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.gfws.FactorArrays;
import xander.gfws.drive.DirectSurfSelector;
import xander.gfws.drive.DirectWaveSurfingDrive;
import xander.gfws.processor.FactorArrayProcessor;

public class GreenBeeSurfSelector
implements DirectSurfSelector,
Painter {
    private static final Log log = Logger.getLog(GreenBeeSurfSelector.class);
    private static final int DTA = 30;
    private static final double TI = 6.0;
    private FactorArrayProcessor factorArrayProcessor;
    private double[][] cwTestAngles;
    private double[][] ccwTestAngles;
    private DistancingEquation de;
    private WeightedIndex[] weightedIndicies;
    private double[] surfArray;
    private double minFactorAngle;
    private double maxFactorAngle;
    private double targetFactorAngle;
    private Wave surfWave;
    private double dangerCheckWidth;

    public GreenBeeSurfSelector(FactorArrayProcessor factorArrayProcessor, DistancingEquation de) {
        this.factorArrayProcessor = factorArrayProcessor;
        this.de = de;
        this.cwTestAngles = new double[30][4];
        this.ccwTestAngles = new double[30][4];
    }

    @Override
    public void onPaint(Graphics2D g) {
        g.setColor(Color.BLUE);
        Ellipse2D.Double point = new Ellipse2D.Double();
        int i = 0;
        while (i < this.cwTestAngles.length) {
            point.x = this.cwTestAngles[i][2] - 1.0;
            point.y = this.cwTestAngles[i][3] - 1.0;
            point.width = 2.0;
            point.height = 2.0;
            g.draw(point);
            ++i;
        }
        i = 0;
        while (i < this.ccwTestAngles.length) {
            point.x = this.ccwTestAngles[i][2] - 1.0;
            point.y = this.ccwTestAngles[i][3] - 1.0;
            point.width = 2.0;
            point.height = 2.0;
            g.draw(point);
            ++i;
        }
    }

    @Override
    public void updateSurfSelection(DirectWaveSurfingDrive.DirectSurfSelection[] surfSelections, Wave surfWave, DirectDrivePredictor predictor, DriveState myDriveState, Snapshot currentOpponentSnapshot, long fromTime) {
        long currentTime = fromTime;
        double inHeading = RCMath.getRobocodeAngle(myDriveState.getPosition(), surfWave.getOrigin());
        int i = 0;
        while (i < 30) {
            this.ccwTestAngles[i][0] = RCMath.normalizeDegrees(inHeading + ((double)i + 0.5) * 6.0);
            this.cwTestAngles[i][0] = RCMath.normalizeDegrees(inHeading + 180.0 + ((double)i + 0.5) * 6.0);
            ++i;
        }
        int greatestCWIndex = -1;
        int greatestCCWIndex = -1;
        int i2 = 0;
        while (i2 < this.cwTestAngles.length) {
            DriveState testDriveState = predictor.predictDriveStateUntilWaveHits(surfWave, myDriveState, this.cwTestAngles[i2][0], 8.0, currentTime);
            this.cwTestAngles[i2][1] = FactorArrays.getFactorAngle(surfWave, testDriveState.getPosition());
            this.cwTestAngles[i2][2] = testDriveState.getX();
            this.cwTestAngles[i2][3] = testDriveState.getY();
            if (greatestCWIndex == -1 || this.cwTestAngles[i2][1] > this.cwTestAngles[greatestCWIndex][1]) {
                greatestCWIndex = i2;
            }
            testDriveState = predictor.predictDriveStateUntilWaveHits(surfWave, myDriveState, this.ccwTestAngles[i2][0], 8.0, currentTime);
            this.ccwTestAngles[i2][1] = FactorArrays.getFactorAngle(surfWave, testDriveState.getPosition());
            this.ccwTestAngles[i2][2] = testDriveState.getX();
            this.ccwTestAngles[i2][3] = testDriveState.getY();
            if (greatestCCWIndex == -1 || this.ccwTestAngles[i2][1] < this.ccwTestAngles[greatestCCWIndex][1]) {
                greatestCCWIndex = i2;
            }
            ++i2;
        }
        double[] oppXYShift = currentOpponentSnapshot.getXYShift();
        long cwTimeToHit = surfWave.getTimeUntilHit(this.cwTestAngles[greatestCWIndex][2], this.cwTestAngles[greatestCWIndex][3], currentTime);
        double oppX = currentOpponentSnapshot.getX() + oppXYShift[0] / 2.0 * (double)cwTimeToHit;
        double oppY = currentOpponentSnapshot.getY() + oppXYShift[1] / 2.0 * (double)cwTimeToHit;
        double oppDistance = RCMath.getDistanceBetweenPoints(oppX, oppY, this.cwTestAngles[greatestCWIndex][2], this.cwTestAngles[greatestCWIndex][3]);
        double cwAdjustAngle = this.de.getAdjustAngle(oppDistance, surfWave);
        int cwIndexShift = (int)Math.round(-cwAdjustAngle / 6.0);
        int cwBeginIndex = greatestCWIndex;
        int cwEndIndex = greatestCWIndex;
        if (cwAdjustAngle < 0.0) {
            int maxCWBeginIndex = (int)Math.round(15.0 + this.de.getMaxAdvanceAngle() / 6.0);
            cwBeginIndex = Math.max(0, Math.min(maxCWBeginIndex, greatestCWIndex + cwIndexShift));
            cwEndIndex = 29;
        } else if (cwAdjustAngle > 0.0) {
            int minCWEndIndex = (int)Math.round(15.0 - this.de.getMaxRetreatAngle() / 6.0);
            cwBeginIndex = 0;
            cwEndIndex = Math.min(29, Math.max(minCWEndIndex, greatestCWIndex + cwIndexShift));
        }
        long ccwTimeToHit = surfWave.getTimeUntilHit(this.ccwTestAngles[greatestCCWIndex][2], this.ccwTestAngles[greatestCCWIndex][3], currentTime);
        oppX = currentOpponentSnapshot.getX() + oppXYShift[0] / 2.0 * (double)ccwTimeToHit;
        oppY = currentOpponentSnapshot.getY() + oppXYShift[1] / 2.0 * (double)ccwTimeToHit;
        oppDistance = RCMath.getDistanceBetweenPoints(oppX, oppY, this.ccwTestAngles[greatestCCWIndex][2], this.ccwTestAngles[greatestCCWIndex][3]);
        double ccwAdjustAngle = this.de.getAdjustAngle(oppDistance, surfWave);
        int ccwIndexShift = (int)Math.round(cwAdjustAngle / 6.0);
        int ccwBeginIndex = greatestCCWIndex;
        int ccwEndIndex = greatestCCWIndex;
        if (ccwAdjustAngle < 0.0) {
            int minCCWEndIndex = (int)Math.round(15.0 - this.de.getMaxAdvanceAngle() / 6.0);
            ccwBeginIndex = 0;
            ccwEndIndex = Math.min(29, Math.max(minCCWEndIndex, greatestCCWIndex + ccwIndexShift));
        } else if (ccwAdjustAngle > 0.0) {
            int maxCCWBeginIndex = (int)Math.round(15.0 + this.de.getMaxRetreatAngle() / 6.0);
            ccwBeginIndex = Math.max(0, Math.min(maxCCWBeginIndex, greatestCCWIndex + ccwIndexShift));
            ccwEndIndex = 29;
        }
        this.minFactorAngle = 360.0;
        this.maxFactorAngle = -360.0;
        int i3 = ccwBeginIndex;
        while (i3 <= ccwEndIndex) {
            this.minFactorAngle = Math.min(this.minFactorAngle, this.ccwTestAngles[i3][1]);
            ++i3;
        }
        i3 = cwBeginIndex;
        while (i3 <= cwEndIndex) {
            this.maxFactorAngle = Math.max(this.maxFactorAngle, this.cwTestAngles[i3][1]);
            ++i3;
        }
        if (this.minFactorAngle > this.maxFactorAngle) {
            log.warn("Possible error in surf selection- minFactorAngle > maxFactorAngle; reversing to prevent bad things from happening.");
            double temp = this.minFactorAngle;
            this.minFactorAngle = this.maxFactorAngle;
            this.maxFactorAngle = temp;
        }
        double maxRange = this.cwTestAngles[greatestCWIndex][1] - this.ccwTestAngles[greatestCCWIndex][1];
        double distancedRange = this.maxFactorAngle - this.minFactorAngle;
        boolean rangeExtendable = true;
        while (rangeExtendable && !RCMath.differenceLessThanPercent(maxRange, distancedRange, 0.2)) {
            rangeExtendable = false;
            if (ccwBeginIndex == 0 && ccwEndIndex < 29) {
                rangeExtendable = true;
                this.minFactorAngle = Math.min(this.minFactorAngle, this.ccwTestAngles[++ccwEndIndex][1]);
            } else if (ccwBeginIndex > 0) {
                rangeExtendable = true;
                this.minFactorAngle = Math.min(this.minFactorAngle, this.ccwTestAngles[--ccwBeginIndex][1]);
            }
            if (cwBeginIndex == 0 && cwEndIndex < 29) {
                rangeExtendable = true;
                this.maxFactorAngle = Math.max(this.maxFactorAngle, this.cwTestAngles[++cwEndIndex][1]);
            } else if (cwBeginIndex > 0) {
                rangeExtendable = true;
                this.maxFactorAngle = Math.max(this.maxFactorAngle, this.cwTestAngles[--cwBeginIndex][1]);
            }
            if (this.minFactorAngle > this.maxFactorAngle) {
                log.warn("Possible error in surf selection- minFactorAngle > maxFactorAngle; reversing to prevent bad things from happening.");
                double temp = this.minFactorAngle;
                this.minFactorAngle = this.maxFactorAngle;
                this.maxFactorAngle = temp;
            }
            distancedRange = this.maxFactorAngle - this.minFactorAngle;
        }
        this.surfArray = this.factorArrayProcessor.getFactorArray(surfWave, this.minFactorAngle, this.maxFactorAngle);
        if (this.weightedIndicies == null || this.weightedIndicies.length != this.surfArray.length) {
            this.weightedIndicies = new WeightedIndex[this.surfArray.length];
            int i4 = 0;
            while (i4 < this.weightedIndicies.length) {
                this.weightedIndicies[i4] = new WeightedIndex();
                ++i4;
            }
        }
        int i5 = 0;
        while (i5 < this.surfArray.length) {
            this.weightedIndicies[i5].index = i5;
            this.weightedIndicies[i5].weight = Double.MAX_VALUE;
            ++i5;
        }
        double minFactorAngleIndex = FactorArrays.getPreciseFactorIndex(this.minFactorAngle, this.surfArray.length, surfWave.getBulletVelocity(), surfWave.getSurfDirection());
        double maxFactorAngleIndex = FactorArrays.getPreciseFactorIndex(this.maxFactorAngle, this.surfArray.length, surfWave.getBulletVelocity(), surfWave.getSurfDirection());
        int minIndex = (int)Math.round(Math.floor(Math.min(minFactorAngleIndex, maxFactorAngleIndex)));
        int maxIndex = (int)Math.round(Math.ceil(Math.max(minFactorAngleIndex, maxFactorAngleIndex)));
        minIndex = Math.min(this.surfArray.length - 1, Math.max(0, minIndex));
        maxIndex = Math.min(this.surfArray.length - 1, Math.max(0, maxIndex));
        double robotWidthDistance = RCMath.getDistanceBetweenPoints(surfWave.getOrigin(), myDriveState.getPosition());
        int indexRobotHalfWidth = (int)Math.round(0.5 * FactorArrays.getPreciseFactorIndexRobotWidth(this.surfArray.length, robotWidthDistance, surfWave.getBulletVelocity()));
        int i6 = minIndex;
        while (i6 <= maxIndex) {
            this.weightedIndicies[i6].weight = this.getDangerForFactorIndex(i6, indexRobotHalfWidth);
            ++i6;
        }
        Arrays.sort(this.weightedIndicies);
        int surfSelectionIndex = 0;
        int weightedIndiciesIndex = 0;
        while (surfSelectionIndex < surfSelections.length && weightedIndiciesIndex < this.weightedIndicies.length && this.weightedIndicies[weightedIndiciesIndex].weight < Double.MAX_VALUE) {
            int factorIndex = this.weightedIndicies[weightedIndiciesIndex].index;
            if (factorIndex >= minIndex && factorIndex <= maxIndex) {
                boolean sufficientSeparation = true;
                int i7 = 0;
                while (i7 < surfSelectionIndex) {
                    if (Math.abs(surfSelections[i7].factorIndex - factorIndex) < indexRobotHalfWidth * 2) {
                        sufficientSeparation = false;
                    }
                    ++i7;
                }
                if (sufficientSeparation) {
                    this.updateSurfSelection(surfSelections[surfSelectionIndex], factorIndex, this.weightedIndicies[weightedIndiciesIndex].weight, indexRobotHalfWidth, surfWave, this.surfArray, this.minFactorAngle, this.maxFactorAngle, cwBeginIndex, cwEndIndex, ccwBeginIndex, ccwEndIndex, fromTime, myDriveState, predictor, currentOpponentSnapshot);
                    ++surfSelectionIndex;
                }
            }
            ++weightedIndiciesIndex;
        }
        this.surfWave = surfWave;
        this.dangerCheckWidth = 2.0 * (double)indexRobotHalfWidth;
    }

    private double getDangerForFactorIndex(int factorIndex, int indexRobotHalfWidth) {
        int beginIndex = factorIndex - indexRobotHalfWidth;
        int endIndex = factorIndex + indexRobotHalfWidth;
        int rBeginIndex = Math.max(0, beginIndex);
        int rEndIndex = Math.min(this.surfArray.length - 1, endIndex);
        double danger = 0.0;
        int j = rBeginIndex;
        while (j <= rEndIndex) {
            danger += this.surfArray[j];
            ++j;
        }
        return danger *= (double)((endIndex - beginIndex + 1) / (rEndIndex - rBeginIndex + 1));
    }

    private void updateSurfSelection(DirectWaveSurfingDrive.DirectSurfSelection surfSelection, int factorIndex, double danger, int indexRobotHalfWidth, Wave surfWave, double[] surfArray, double minFactorAngle, double maxFactorAngle, int cwBeginIndex, int cwEndIndex, int ccwBeginIndex, int ccwEndIndex, long fromTime, DriveState myDriveState, DirectDrivePredictor predictor, Snapshot currentOpponentSnapshot) {
        double factorAngle = FactorArrays.getLeastWeightedFactorAngle(surfArray, factorIndex, surfWave.getBulletVelocity(), surfWave.getSurfDirection());
        factorAngle = RCMath.limit(factorAngle, minFactorAngle, maxFactorAngle);
        DriveState finalDriveState = new DriveState();
        double targetHeading = this.getTargetHeading(surfWave, cwBeginIndex, cwEndIndex, ccwBeginIndex, ccwEndIndex, factorAngle, fromTime, myDriveState, finalDriveState, predictor, currentOpponentSnapshot);
        surfSelection.danger = danger;
        surfSelection.factorIndex = factorIndex;
        surfSelection.factorAngle = factorAngle;
        surfSelection.finalDriveState = finalDriveState;
        surfSelection.heading = targetHeading;
    }

    private double getTargetHeading(Wave surfWave, int cwBeginIndex, int cwEndIndex, int ccwBeginIndex, int ccwEndIndex, double targetFactorAngle, long fromTime, DriveState myDriveState, DriveState finalDriveState, DirectDrivePredictor predictor, Snapshot currentOpponentSnapshot) {
        double distance;
        double oppY;
        double oppX;
        long tuh;
        long time;
        DriveState dDriveState = new DriveState();
        double targetHeading = myDriveState.getHeading();
        double closestDistance = Double.MAX_VALUE;
        double[] oppXYShift = currentOpponentSnapshot.getXYShift();
        double currentFactorAngle = FactorArrays.getFactorAngle(surfWave, myDriveState.getPosition());
        int i = cwBeginIndex;
        while (i <= cwEndIndex) {
            if (RCMath.between(targetFactorAngle, currentFactorAngle, this.cwTestAngles[i][1])) {
                time = fromTime;
                dDriveState.setState(myDriveState);
                tuh = surfWave.getTimeUntilHit(dDriveState.getX(), dDriveState.getY(), time);
                while (tuh > 0L && !predictor.shouldStop(surfWave, targetFactorAngle, dDriveState, this.cwTestAngles[i][0], 8.0, time, false)) {
                    predictor.advanceDriveState(dDriveState, this.cwTestAngles[i][0], 8.0);
                    tuh = surfWave.getTimeUntilHit(dDriveState.getX(), dDriveState.getY(), ++time);
                }
                while (tuh > 0L && Math.abs(dDriveState.getVelocity()) > 0.0) {
                    predictor.advanceDriveState(dDriveState, this.cwTestAngles[i][0], 0.0);
                    tuh = surfWave.getTimeUntilHit(dDriveState.getX(), dDriveState.getY(), ++time);
                }
                tuh = surfWave.getTimeUntilHit(dDriveState.getX(), dDriveState.getY(), fromTime);
                oppX = currentOpponentSnapshot.getX() + (double)tuh * 0.5 * oppXYShift[0];
                oppY = currentOpponentSnapshot.getY() + (double)tuh * 0.5 * oppXYShift[1];
                distance = Math.abs(this.de.getOptimalDistance() - RCMath.getDistanceBetweenPoints(dDriveState.getX(), dDriveState.getY(), oppX, oppY));
                if (distance < closestDistance) {
                    closestDistance = distance;
                    targetHeading = this.cwTestAngles[i][0];
                    finalDriveState.setState(dDriveState);
                }
            }
            ++i;
        }
        i = ccwBeginIndex;
        while (i <= ccwEndIndex) {
            if (RCMath.between(targetFactorAngle, currentFactorAngle, this.ccwTestAngles[i][1])) {
                time = fromTime;
                dDriveState.setState(myDriveState);
                tuh = surfWave.getTimeUntilHit(dDriveState.getX(), dDriveState.getY(), time);
                while (tuh > 0L && !predictor.shouldStop(surfWave, targetFactorAngle, dDriveState, this.ccwTestAngles[i][0], 8.0, time, false)) {
                    predictor.advanceDriveState(dDriveState, this.ccwTestAngles[i][0], 8.0);
                    tuh = surfWave.getTimeUntilHit(dDriveState.getX(), dDriveState.getY(), ++time);
                }
                while (tuh > 0L && Math.abs(dDriveState.getVelocity()) > 0.0) {
                    predictor.advanceDriveState(dDriveState, this.ccwTestAngles[i][0], 0.0);
                    tuh = surfWave.getTimeUntilHit(dDriveState.getX(), dDriveState.getY(), ++time);
                }
                tuh = surfWave.getTimeUntilHit(dDriveState.getX(), dDriveState.getY(), fromTime);
                oppX = currentOpponentSnapshot.getX() + (double)tuh * 0.5 * oppXYShift[0];
                oppY = currentOpponentSnapshot.getY() + (double)tuh * 0.5 * oppXYShift[1];
                distance = Math.abs(this.de.getOptimalDistance() - RCMath.getDistanceBetweenPoints(dDriveState.getX(), dDriveState.getY(), oppX, oppY));
                if (distance < closestDistance) {
                    closestDistance = distance;
                    targetHeading = this.ccwTestAngles[i][0];
                    finalDriveState.setState(dDriveState);
                }
            }
            ++i;
        }
        return targetHeading;
    }

    private static class WeightedIndex
    implements Comparable<WeightedIndex> {
        double weight;
        int index;

        private WeightedIndex() {
        }

        @Override
        public int compareTo(WeightedIndex other) {
            double diff = this.weight - other.weight;
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return 0;
        }
    }
}

