/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.bothandling;

import alk.lap.LoudAndProud;
import alk.lap.strategy.analysis.EvaluateVirtualGuns;
import alk.lap.strategy.analysis.Recommendation;
import alk.lap.strategy.targetting.TargetStrategy;
import java.awt.Color;
import robocode.CustomEvent;
import robocode.GunTurnCompleteCondition;

public class Gunner {
    private LoudAndProud proud;
    private GunTurnCompleteCondition gtcc;
    TargetStrategy tStrategy;
    EvaluateVirtualGuns evaluateVGuns;

    public Gunner(TargetStrategy tStrategy) {
        this.tStrategy = tStrategy;
    }

    public void checkCustomEvent(CustomEvent ce) {
        ce.getCondition();
    }

    public void turnGunToTarget() {
        double turnToBeMade;
        double theta;
        if (this.proud.getTacticLead().isEnemySpotted() && (theta = this.tStrategy.getFireAngleTo(0, null)[0]) != Double.NaN && Math.abs(turnToBeMade = LoudAndProud.normalRelativeAngle(theta - this.proud.getGunHeading())) >= 1.0E-4) {
            this.proud.setTurnGunRight(LoudAndProud.normalToAbsMin(turnToBeMade, 19.0));
        }
    }

    public void doFire() {
        Recommendation r;
        double gunHeat = this.proud.getGunHeat();
        if (gunHeat <= 0.2 && gunHeat > 0.1 && (r = this.evaluateVGuns.analyse(this.proud)) != null) {
            r.execute();
        }
        if (this.proud.getGunHeat() == 0.0 && this.proud.getEnergy() > 0.1 && this.proud.getOthers() > 0) {
            this.proud.setFireBullet(this.tStrategy.getFireEnergy());
            this.proud.getTacticLead().notifyFire();
        }
    }

    public void unMount() {
    }

    public void mount() {
        this.proud.setGunColor(this.tStrategy.getColorCode());
        this.proud.setBulletColor(Color.pink);
    }

    public void newRound(LoudAndProud proud) {
        this.proud = proud;
        this.tStrategy.newRound(proud);
        this.evaluateVGuns = new EvaluateVirtualGuns();
        this.evaluateVGuns.newRound(proud);
    }

    public String getName() {
        return this.tStrategy.describe();
    }

    public TargetStrategy getTargetStrategy() {
        return this.tStrategy;
    }
}

