/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.targetting;

import alk.lap.LoudAndProud;
import alk.lap.strategy.FireWave;
import alk.lap.strategy.TacticalLead;
import alk.lap.strategy.analysis.AnalystsDatabase;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;
import alk.lap.utils.LapUtils;
import java.awt.Color;

public class StatDistanceTargeting
implements TargetStrategy {
    private static final double BEAM_ANGLE = 15.0;
    public static final String NAME = "StatDistanceT";
    private double fireEnergy = 3.0;
    public static final double THRESHOLD_TO_AVOID = 0.8;
    LoudAndProud proud;
    private String name = "StatDistanceT";

    public String describe() {
        return this.name;
    }

    public TargetStrategy.StrategyType getType() {
        return TargetStrategy.StrategyType.Heuristic;
    }

    public double[] getFireAngleTo(int target, FireWave wave) {
        double angle = 0.0;
        TacticalLead tLead = this.proud.getTacticLead();
        AnalystsDatabase db = this.proud.getStrategicLead().getAnalystsDB();
        if (target == 1) {
            throw new RuntimeException("Diese Strat ist nicht f\u00fcr Gegner anwendbar!");
        }
        if (!tLead.isEnemySpotted()) {
            return LapUtils.toDArray(this.proud.getRadarHeading());
        }
        double enemyHeading = LoudAndProud.normalRelativeAngle(this.proud.getTacticLead().getEnemyHeading() + (double)(this.proud.getStrategicLead().getAnalystsDB().getScanBase().getCurrentEnemyMove().signV > 0.0 ? 0 : 180) - this.proud.getTacticLead().getEnemyBearing());
        DVektor proudsPos = this.proud.getPosition();
        DVektor enemyPos = this.proud.getTacticLead().getEnemyPos();
        double distance = db.getMostLikelyDistance(db.enemyDistStat, (double)enemyHeading).value;
        DVektor move = DVektor.fromPolarCoord(this.proud.getPosition().getDirectionTo(enemyPos) + 90.0, distance);
        DVektor newEnemyPos = DVektor.add(enemyPos, move);
        int bulletTravelTime = (int)(proudsPos.getDistanceTo(newEnemyPos) / (20.0 - 3.0 * this.fireEnergy));
        this.proud.getVc().drawPoint(newEnemyPos, "prog pos at" + bulletTravelTime, bulletTravelTime, this.getColorCode());
        angle = proudsPos.getDirectionTo(newEnemyPos);
        return LapUtils.toDArray(angle);
    }

    public double getFireEnergy() {
        return this.fireEnergy;
    }

    public double getBeamAngle() {
        return 15.0;
    }

    public StatDistanceTargeting setName(String name) {
        this.name = name;
        return this;
    }

    public StatDistanceTargeting setFireEnergy(double fireEnergy) {
        this.fireEnergy = fireEnergy;
        this.setName(String.valueOf(this.describe()) + "-f" + LoudAndProud.printStaticDouble(fireEnergy));
        return this;
    }

    public Color getColorCode() {
        return Color.yellow;
    }

    public void newRound(LoudAndProud proud) {
        this.proud = proud;
    }
}

