/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.compound;

import dmonner.xlbp.Component;
import dmonner.xlbp.InternalComponent;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.UpstreamComponent;
import dmonner.xlbp.WeightInitializer;
import dmonner.xlbp.WeightUpdaterType;
import dmonner.xlbp.compound.AbstractWeightedCompound;
import dmonner.xlbp.compound.FunctionCompound;
import dmonner.xlbp.compound.LogisticCompound;
import dmonner.xlbp.compound.WeightBank;
import dmonner.xlbp.layer.FanOutLayer;
import dmonner.xlbp.layer.PiLayer;
import dmonner.xlbp.util.MatrixTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class PiCompound
extends AbstractWeightedCompound {
    private static final long serialVersionUID = 1L;
    private final int size;
    private final PiLayer pi;
    private FanOutLayer fan;
    private FunctionCompound[] ins;

    public PiCompound(PiCompound that, NetworkCopier copier) {
        super(that, copier);
        this.size = that.size;
        this.pi = copier.getCopyOf(that.pi);
        this.fan = copier.getCopyOf(that.fan);
        this.ins = new FunctionCompound[that.ins.length];
        for (int i = 0; i < that.ins.length; ++i) {
            this.ins[i] = copier.getCopyOf(that.ins[i]);
        }
        this.in = copier.getCopyOf(that.in);
        this.out = copier.getCopyOf(that.out);
    }

    public PiCompound(String name, int size) {
        super(name);
        this.size = size;
        this.pi = new PiLayer(name + "Pi", size);
        this.fan = new FanOutLayer(name + "Fan", size);
        this.ins = new FunctionCompound[0];
        this.fan.addUpstream(this.pi);
        this.in = this.pi;
        this.out = this.fan;
    }

    @Override
    public void activateTest() {
        super.activateTest();
        for (FunctionCompound in : this.ins) {
            in.activateTest();
        }
        this.pi.activateTest();
    }

    @Override
    public void activateTrain() {
        super.activateTrain();
        for (FunctionCompound in : this.ins) {
            in.activateTrain();
        }
        this.pi.activateTrain();
    }

    @Override
    public void addUpstreamWeights(UpstreamComponent upstream) {
        this.ins = Arrays.copyOf(this.ins, this.ins.length + 1);
        LogisticCompound log = new LogisticCompound(upstream.getName() + "Log", this.size);
        this.ins[this.ins.length - 1] = log;
        this.pi.addUpstream(log);
        log.addUpstreamWeights(upstream);
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            for (FunctionCompound in : this.ins) {
                in.build();
            }
            this.pi.build();
            if (this.fan != null) {
                this.fan.build();
            }
            this.built = true;
        }
    }

    @Override
    public void clearActivations() {
        super.clearActivations();
        for (FunctionCompound in : this.ins) {
            in.clearActivations();
        }
        this.pi.clearActivations();
    }

    @Override
    public void clearEligibilities() {
        super.clearEligibilities();
        for (FunctionCompound in : this.ins) {
            in.clearEligibilities();
        }
    }

    @Override
    public void clearResponsibilities() {
        super.clearResponsibilities();
        for (FunctionCompound in : this.ins) {
            in.clearResponsibilities();
        }
        this.pi.clearResponsibilities();
        if (this.fan != null) {
            this.fan.clearResponsibilities();
        }
    }

    @Override
    public PiCompound copy(NetworkCopier copier) {
        return new PiCompound(this, copier);
    }

    @Override
    public PiCompound copy(String nameSuffix) {
        NetworkCopier copier = new NetworkCopier(nameSuffix);
        PiCompound copy = this.copy(copier);
        copier.build();
        return copy;
    }

    @Override
    public Component[] getComponents() {
        ArrayList<InternalComponent> list = new ArrayList<InternalComponent>();
        for (FunctionCompound in : this.ins) {
            list.add(in);
        }
        list.add(this.pi);
        if (this.fan != null) {
            list.add(this.fan);
        }
        return list.toArray(new Component[list.size()]);
    }

    @Override
    public int nWeights() {
        int sum = super.nWeights();
        for (FunctionCompound in : this.ins) {
            sum += in.nWeights();
        }
        return sum;
    }

    @Override
    public boolean optimize() {
        if (!super.optimize()) {
            return false;
        }
        ArrayList<FunctionCompound> list = new ArrayList<FunctionCompound>(this.ins.length);
        for (FunctionCompound in : this.ins) {
            list.add(in);
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (((FunctionCompound)it.next()).optimize()) continue;
            it.remove();
        }
        this.ins = list.toArray(new FunctionCompound[list.size()]);
        if (!this.pi.optimize()) {
            return false;
        }
        if (this.fan != null && !this.fan.optimize()) {
            this.fan = null;
            this.out = this.pi;
        }
        return true;
    }

    @Override
    public void processBatch() {
        super.processBatch();
        for (FunctionCompound in : this.ins) {
            in.processBatch();
        }
    }

    @Override
    public void setWeightInitializer(WeightInitializer win) {
        super.setWeightInitializer(win);
        for (FunctionCompound in : this.ins) {
            in.setWeightInitializer(win);
        }
    }

    @Override
    public void setWeightUpdaterType(WeightUpdaterType wut) {
        super.setWeightUpdaterType(wut);
        for (FunctionCompound in : this.ins) {
            in.setWeightUpdaterType(wut);
        }
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showIntermediate()) {
            super.toString(sb);
            sb.pushIndent();
            if (this.fan != null) {
                this.fan.toString(sb);
            }
            this.pi.toString(sb);
            for (FunctionCompound functionCompound : this.ins) {
                functionCompound.toString(sb);
            }
            for (Component component : this.conn) {
                ((WeightBank)component).toString(sb);
            }
            sb.popIndent();
        } else {
            super.toString(sb);
            sb.pushIndent();
            if (sb.showActivations()) {
                sb.appendln("Activations:");
                sb.pushIndent();
                sb.appendln(MatrixTools.toString(this.pi.getActivations()));
                sb.popIndent();
            }
            if (sb.showResponsibilities()) {
                sb.appendln("Responsibilities:");
                sb.pushIndent();
                sb.appendln(this.pi.getResponsibilities().toString());
                sb.popIndent();
            }
            for (WeightBank weightBank : this.conn) {
                weightBank.getConnection().toString(sb);
            }
            sb.popIndent();
        }
    }

    @Override
    public void unbuild() {
        super.unbuild();
        for (FunctionCompound in : this.ins) {
            in.unbuild();
        }
        this.pi.unbuild();
        if (this.fan != null) {
            this.fan.unbuild();
        }
    }

    @Override
    public void updateEligibilities() {
        if (this.fan != null) {
            this.fan.updateEligibilities();
        }
        this.pi.updateEligibilities();
        for (FunctionCompound in : this.ins) {
            in.updateEligibilities();
        }
        super.updateEligibilities();
    }

    @Override
    public void updateResponsibilities() {
        if (this.fan != null) {
            this.fan.updateResponsibilities();
        }
        this.pi.updateResponsibilities();
        for (FunctionCompound in : this.ins) {
            in.updateResponsibilities();
        }
        super.updateResponsibilities();
    }

    @Override
    public void updateWeights() {
        this.pi.updateWeights();
        for (FunctionCompound in : this.ins) {
            in.updateWeights();
        }
        super.updateWeights();
    }
}

