/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.Optimizer;
import dmonner.xlbp.stat.SetStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.Map;

public class TestStat
extends AbstractStat {
    private SetStat bestTrain;
    private SetStat bestValid;
    private SetStat bestTest;
    private SetStat lastTrain;
    private SetStat lastValid;
    private SetStat lastTest;
    private boolean initialized;
    private final Optimizer optimizer;

    public TestStat() {
        this(Optimizer.defaultOptimizer);
    }

    public TestStat(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    public boolean add(SetStat train, SetStat valid, SetStat test) {
        this.initialized = true;
        this.lastTrain = train;
        this.lastValid = valid;
        this.lastTest = test;
        if (this.optimizer.betterThan(valid, this.bestValid)) {
            this.bestTrain = train;
            this.bestValid = valid;
            this.bestTest = test;
            return true;
        }
        return false;
    }

    @Override
    public void add(Stat that) {
        if (!(that instanceof TestStat)) {
            throw new IllegalArgumentException("Can only add in TestStats.");
        }
        this.add((TestStat)that);
    }

    public void add(TestStat that) {
        if (!this.initialized) {
            if (that.bestTrain != null) {
                this.bestTrain = new SetStat("bestTrain");
            }
            if (that.bestValid != null) {
                this.bestValid = new SetStat("bestValid");
            }
            if (that.bestTest != null) {
                this.bestTest = new SetStat("bestTest");
            }
            if (that.lastTrain != null) {
                this.lastTrain = new SetStat("lastTrain");
            }
            if (that.lastValid != null) {
                this.lastValid = new SetStat("lastValid");
            }
            if (that.lastTest != null) {
                this.lastTest = new SetStat("lastTest");
            }
            this.initialized = true;
        }
        if (this.bestTrain != null) {
            this.bestTrain.add(that.bestTrain);
        }
        if (this.bestValid != null) {
            this.bestValid.add(that.bestValid);
        }
        if (this.bestTest != null) {
            this.bestTest.add(that.bestTest);
        }
        if (this.lastTrain != null) {
            this.lastTrain.add(that.lastTrain);
        }
        if (this.lastValid != null) {
            this.lastValid.add(that.lastValid);
        }
        if (this.lastTest != null) {
            this.lastTest.add(that.lastTest);
        }
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        if (this.bestTest != null) {
            this.bestTest.addTo("bestTest" + prefix, map);
        }
        if (this.lastTest != null) {
            this.lastTest.addTo("lastTest" + prefix, map);
        }
        if (this.bestValid != null) {
            this.bestValid.addTo("bestValid" + prefix, map);
        }
        if (this.lastValid != null) {
            this.lastValid.addTo("lastValid" + prefix, map);
        }
        if (this.bestTrain != null) {
            this.bestTrain.addTo("bestTrain" + prefix, map);
        }
        if (this.lastTrain != null) {
            this.lastTrain.addTo("lastTrain" + prefix, map);
        }
    }

    @Override
    public void analyze() {
        if (this.bestTest != null) {
            this.bestTest.analyze();
        }
        if (this.lastTest != null) {
            this.lastTest.analyze();
        }
        if (this.bestValid != null) {
            this.bestValid.analyze();
        }
        if (this.lastValid != null) {
            this.lastValid.analyze();
        }
        if (this.bestTrain != null) {
            this.bestTrain.analyze();
        }
        if (this.lastTrain != null) {
            this.lastTrain.analyze();
        }
    }

    @Override
    public void clear() {
        if (this.bestTest != null) {
            this.bestTest.clear();
        }
        if (this.lastTest != null) {
            this.lastTest.clear();
        }
        if (this.bestValid != null) {
            this.bestValid.clear();
        }
        if (this.lastValid != null) {
            this.lastValid.clear();
        }
        if (this.bestTrain != null) {
            this.bestTrain.clear();
        }
        if (this.lastTrain != null) {
            this.lastTrain.clear();
        }
    }

    public SetStat getBestTest() {
        return this.bestTest;
    }

    public SetStat getBestTrain() {
        return this.bestTrain;
    }

    public SetStat getBestValid() {
        return this.bestValid;
    }

    public SetStat getLastTest() {
        return this.lastTest;
    }

    public SetStat getLastTrain() {
        return this.lastTrain;
    }

    public SetStat getLastValid() {
        return this.lastValid;
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        out.beginRecord();
        if (this.bestTest != null) {
            this.bestTest.saveData(out);
        }
        if (this.lastTest != null) {
            this.lastTest.saveData(out);
        }
        if (this.bestValid != null) {
            this.bestValid.saveData(out);
        }
        if (this.lastValid != null) {
            this.lastValid.saveData(out);
        }
        if (this.bestTrain != null) {
            this.bestTrain.saveData(out);
        }
        if (this.lastTrain != null) {
            this.lastTrain.saveData(out);
        }
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        out.beginRecord();
        if (this.bestTest != null) {
            this.bestTest.saveHeader("bestTest" + prefix, out);
        }
        if (this.lastTest != null) {
            this.lastTest.saveHeader("lastTest" + prefix, out);
        }
        if (this.bestValid != null) {
            this.bestValid.saveHeader("bestValid" + prefix, out);
        }
        if (this.lastValid != null) {
            this.lastValid.saveHeader("lastValid" + prefix, out);
        }
        if (this.bestTrain != null) {
            this.bestTrain.saveHeader("bestTrain" + prefix, out);
        }
        if (this.lastTrain != null) {
            this.lastTrain.saveHeader("lastTrain" + prefix, out);
        }
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        if (this.bestTest != null) {
            sb.append("BestTest:\n");
            sb.append(this.bestTest.toString(prefix));
            sb.append("\n");
        }
        if (this.lastTest != null) {
            sb.append("LastTest:\n");
            sb.append(this.lastTest.toString(prefix));
            sb.append("\n");
        }
        if (this.bestValid != null) {
            sb.append("BestValid:\n");
            sb.append(this.bestValid.toString(prefix));
            sb.append("\n");
        }
        if (this.lastValid != null) {
            sb.append("LastValid:\n");
            sb.append(this.lastValid.toString(prefix));
            sb.append("\n");
        }
        if (this.bestTrain != null) {
            sb.append("BestTrain:\n");
            sb.append(this.bestTrain.toString(prefix));
            sb.append("\n");
        }
        if (this.lastTrain != null) {
            sb.append("LastTrain:\n");
            sb.append(this.lastTrain.toString(prefix));
            sb.append("\n");
        }
        return sb.toString();
    }
}

