/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.movement;

import java.awt.Color;
import java.awt.Graphics2D;
import rampancy.util.RPoint;
import rampancy.util.RRectangle;
import rampancy.util.RUtil;

public class RMoveChoice {
    public static final Color DEFAULT_COLOR = Color.blue;
    public RPoint destination;
    public Color color;
    public double angle;
    public double distance;
    public double maxVelocity;
    public double danger;
    public double guessFactor;
    public long timeToDestination;
    public int direction;

    public RMoveChoice(RPoint destination, double angle, double distance, double maxVelocity, double danger, double guessFactor, long timeToDestination, int direction) {
        this(destination, angle, distance, maxVelocity, danger, guessFactor, timeToDestination, direction, DEFAULT_COLOR);
    }

    public RMoveChoice(RPoint destination, double angle, double distance, double maxVelocity, double danger, double guessFactor, long timeToDestination, int direction, Color color) {
        this.destination = destination.getCopy();
        this.angle = angle;
        this.distance = distance;
        this.maxVelocity = maxVelocity;
        this.danger = danger;
        this.timeToDestination = timeToDestination;
        this.color = color;
        this.guessFactor = guessFactor;
        this.direction = direction;
    }

    public RMoveChoice(RMoveChoice choice) {
        this(choice.destination, choice.angle, choice.distance, choice.maxVelocity, choice.danger, choice.guessFactor, choice.timeToDestination, choice.direction, choice.color);
    }

    public void draw(Graphics2D g) {
        g.setColor(new Color((int)Math.min(this.danger / 2.0 * 255.0, 255.0), 40, 0));
        RUtil.fillOval(this.destination, 4, g);
        g.draw(new RRectangle(this.destination));
    }
}

