/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.wave;

import java.awt.Color;
import java.awt.Graphics2D;
import rampancy.util.RDrawableObject;
import rampancy.util.RPoint;
import rampancy.util.RUtil;

public abstract class RWave {
    protected RPoint origin;
    protected Color color;
    protected long timeFired;
    protected double power;
    protected double velocity;
    protected double distanceTraveled;
    protected boolean isVirtual;
    protected RDrawableObject drawableObject;

    public RWave(RPoint origin, long timeFired, double power, Color color) {
        this(origin, timeFired, power, color, false);
    }

    public RWave(RPoint origin, long timeFired, double power, Color color, boolean virtual) {
        this(origin, timeFired, power, color, virtual, null);
    }

    public RWave(RPoint origin, long timeFired, double power, Color color, boolean virtual, RDrawableObject drawableObject) {
        this.origin = origin.getCopy();
        this.timeFired = timeFired;
        this.power = power;
        this.distanceTraveled = this.velocity = RUtil.computeBulletVelocity(power);
        this.color = color;
        this.isVirtual = virtual;
        this.drawableObject = drawableObject;
    }

    public void update(long time) {
        this.distanceTraveled = (double)(time - this.timeFired) * this.getVelocity();
    }

    public double distanceFrom(RPoint point) {
        return point.distance(this.origin) - this.distanceTraveled;
    }

    public double distanceFrom(RPoint point, long timeOffset) {
        return point.distance(this.origin) - this.getDistanceTraveled() + this.getVelocity() * (double)timeOffset;
    }

    public long timeToImpact(RPoint point) {
        return this.timeToImpact(point, 0L);
    }

    public long timeToImpact(RPoint point, long timeOffset) {
        double remainingDistance = this.distanceFrom(point) - this.getDistanceTraveled();
        return (long)(remainingDistance / this.getVelocity());
    }

    public void draw(Graphics2D g) {
        Color lastColor = g.getColor();
        g.setColor(this.color);
        g.drawOval((int)(this.origin.x - this.distanceTraveled), (int)(this.origin.y - this.distanceTraveled), (int)(2.0 * this.distanceTraveled), (int)(2.0 * this.distanceTraveled));
        if (this.drawableObject != null) {
            this.drawableObject.draw(g);
        }
        g.setColor(lastColor);
    }

    public String toString() {
        return "RWave: Origin: " + this.origin.toString() + " velocity: " + this.getVelocity();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    public RPoint getOrigin() {
        return this.origin;
    }

    public long getTimeFired() {
        return this.timeFired;
    }

    public double getPower() {
        return this.power;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getDistanceTraveled() {
        return this.distanceTraveled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isVirtual ? 1231 : 1237);
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        long temp = Double.doubleToLongBits(this.power);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.timeFired ^ this.timeFired >>> 32);
        temp = Double.doubleToLongBits(this.velocity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RWave other = (RWave)obj;
        if (this.isVirtual != other.isVirtual) {
            return false;
        }
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        if (Double.doubleToLongBits(this.power) != Double.doubleToLongBits(other.power)) {
            return false;
        }
        if (this.timeFired != other.timeFired) {
            return false;
        }
        return Double.doubleToLongBits(this.velocity) == Double.doubleToLongBits(other.velocity);
    }
}

