/*
 * Decompiled with CFR 0.152.
 */
package sim;

import execution.Message;
import execution.MessageRouter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import sim.Bot;
import sim.Data;

public final class Robots {
    private MessageRouter _router;
    private Map<String, Bot> _enemy = new HashMap<String, Bot>();
    private Map<String, Bot> _ally = new HashMap<String, Bot>();
    private static Map<String, Boolean> _IFF = new HashMap<String, Boolean>();
    public Bot Self;

    public Robots(MessageRouter router) {
        this._router = router;
    }

    public final Collection<Bot> Enemies() {
        return this._enemy.values();
    }

    public final Bot Enemy(String name) {
        Bot enemy = this._enemy.get(name);
        if (enemy == null) {
            enemy = new Bot(name);
            this._enemy.put(name, enemy);
            _IFF.put(name, true);
            this._router.prepare(Message.Kind.DiscoveredEnemy).at(Data.Battle.Time).about(enemy).send();
        }
        return enemy;
    }

    public final boolean IsEnemy(String name) {
        return _IFF.get(name);
    }

    public final Collection<Bot> Allies() {
        return this._ally.values();
    }

    public final Bot Ally(String name) {
        Bot ally = this._ally.get(name);
        if (ally == null) {
            ally = new Bot(name);
            this._ally.put(name, ally);
            _IFF.put(name, false);
        }
        return ally;
    }
}

