/*
 * Decompiled with CFR 0.152.
 */
package rijteam;

public class Util {
    public static final double THREE_QUARTERS = 4.71238898038469;
    public static final double ONE_QUARTER = 1.5707963267948966;
    public static final double ONE_EIGHTH = 0.7853981633974483;
    public static final double CLOSE_ANGLE = 0.19634954084936207;
    public static final double FOUR_QUARTERS = Math.PI * 2;
    static double PI = Math.PI;

    public static double NormaliseBearing(double ang) {
        if (ang > PI) {
            ang -= (double)2 * PI;
        }
        if (ang < -PI) {
            ang += (double)2 * PI;
        }
        return ang;
    }

    public static double getUnitCircleAngle(double angle) {
        return -(angle + 4.71238898038469);
    }

    public static double getHeadingPoints(double originX, double originY, double targetX, double targetY) {
        return (Math.atan2(targetX - originX, targetY - originY) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double getRelativeBearing(double itemHeading, double originX, double originY, double targetX, double targetY) {
        double a = (Math.atan2(targetX - originX, targetY - originY) + Math.PI * 2) % (Math.PI * 2) - itemHeading;
        if (Math.abs(a) > Math.PI) {
            a += a < 0.0 ? Math.PI * 2 : Math.PI * -2;
        }
        return a;
    }

    public static double getBulletDamage(double power) {
        return (double)4 * power + (power > 1.0 ? (double)2 * (power - 1.0) : 0.0);
    }

    public static double NormaliseHeading(double ang) {
        if (ang > (double)2 * PI) {
            ang -= (double)2 * PI;
        }
        if (ang < 0.0) {
            ang += (double)2 * PI;
        }
        return ang;
    }

    public static double getrange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public static double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Util.getrange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }
}

