/*
 * Decompiled with CFR 0.152.
 */
package tex;

import tex.Longbot;
import tex.Program;

public class FireProgram
extends Program {
    private State myState = State.GunCharging;

    @Override
    public void execute(Longbot bot) {
        this.nextProgram(bot);
        System.out.println("Time: " + bot.getTime());
        if (this.myState == State.GunReady) {
            if (bot.mustAimGun(bot.getLastSeenEnemy())) {
                System.out.println("AIM don't want to miss too much");
                bot.aimGun(bot.getLastSeenEnemy());
            } else {
                System.out.println("Fire!!");
                bot.fireGun();
            }
        } else if (this.myState == State.LostTarget) {
            bot.turnRadarLeft(360.0);
        } else if (this.myState == State.GunCharging) {
            bot.turnRadarLeft(360.0);
        } else if (this.myState == State.Aiming) {
            System.out.println("AIM");
            if (bot.getTime() - bot.getLastSeenEnemy().getTime() > 4L) {
                bot.setTurnRadarLeft(360.0);
            }
            bot.aimGun(bot.getLastSeenEnemy());
        }
    }

    @Override
    public void nextProgram(Longbot bot) {
        if (bot.getLastSeenEnemy() == null) {
            this.myState = State.LostTarget;
        } else {
            if (bot.getTime() - bot.getLastSeenEnemy().getTime() > 20L) {
                this.myState = State.LostTarget;
            }
            if (bot.mustAimGun(bot.getLastSeenEnemy())) {
                this.myState = State.Aiming;
            } else if (bot.getGunHeat() == 0.0) {
                this.myState = State.GunReady;
            }
        }
    }

    static enum State {
        GunReady,
        GunCharging,
        Aiming,
        LostTarget;

    }
}

