/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.targeting;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.tactics.targeting.TargetingMethod;
import pedersen.tactics.targeting.TargetingStatistics;

public abstract class TargetingMethodBase
implements TargetingMethod {
    private final int persistenceId;
    private final TargetingStatistics targetingStatistics = new TargetingStatistics(this);

    public TargetingMethodBase(int newPersistenceId) {
        this.persistenceId = newPersistenceId;
    }

    public int getPersistenceId() {
        return this.persistenceId;
    }

    public TargetingStatistics getTargetingStatistics() {
        return this.targetingStatistics;
    }

    public void onFire() {
    }

    public void debug() {
        Debug.debug(String.valueOf(this.getClass().getSimpleName()) + " " + this.targetingStatistics.getSummary());
    }

    public static int getBulletFlightTime(double distanceToTarget, double bulletVelocity) {
        return 1 + (int)(distanceToTarget / bulletVelocity);
    }

    public static double getBulletVelocity(double distanceToTarget, int bulletFlightTime) {
        return distanceToTarget / ((double)bulletFlightTime - 0.5);
    }

    public static boolean doesBulletIntersectTargetMidpoint(double distanceToTarget, double bulletVelocity, int timeToTarget) {
        return Constraints.isInRange(bulletVelocity * (double)(timeToTarget - 1), distanceToTarget, bulletVelocity * (double)timeToTarget);
    }
}

