/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.geom.Point2D;
import justin.Mallais;
import justin.Tank;
import justin.Utils;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.ScannedRobotEvent;

public class Gun
extends Mallais {
    public Scan first;
    public Scan last;
    public int size = 0;
    private AdvancedRobot bot;
    Point2D enemyLoc;
    double enemyEnergy;
    double enemyDist;
    boolean aiming;
    public int logLevel = 2;
    public double minBulletPower = 0.1;
    public double maxBulletPower = 3.0;
    boolean referenceMode = false;
    protected long lastAimTime = 0L;
    private double lastDir = 1.0;
    private double lastRunDir = 1.0;
    private long lastRunStart = 0L;
    private double lastRunTime = 0.0;
    private double lastVel;
    public long bulletsFired = 0L;
    public long bulletsHit = 0L;
    public double powerFired = 0.0;
    public double powerHit = 0.0;
    private int missedScans = 0;
    private int maxSize = 30000;
    private int topCount = 100;
    private int angMax = 100;
    private int centerHitDist = 0;
    private double toleranceWidth = 20.0;
    private boolean targetCos = true;
    long startTime = 0L;
    double bulletPower = 3.0;
    private long lastTime = 0L;
    private double battleFieldWidth;
    private double battleFieldHeight;
    private double tolerance = 0.0;
    private double nextX = 0.0;
    private double nextY = 0.0;
    private double headOnAngle;

    public Gun(AdvancedRobot b) {
        this.bot = b;
        this.battleFieldWidth = this.bot.getBattleFieldWidth();
        this.battleFieldHeight = this.bot.getBattleFieldHeight();
    }

    public void initRound() {
        this.enemyLoc = null;
        this.aiming = false;
    }

    public void bulletFired(Bullet b) {
        ++this.bulletsFired;
        this.powerFired += b.getPower();
    }

    /*
     * Unable to fully structure code
     */
    public void cleanUpRound() {
        this.enemyLoc = null;
        if (this.size != 0) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            this.first = this.first.next;
            --this.size;
lbl6:
            // 2 sources

            ** while (this.size > this.maxSize)
        }
lbl7:
        // 1 sources

        this.first.previous = null;
    }

    public double calcBulletPower() {
        this.bulletPower = 3.0;
        if (this.enemyLoc == null) {
            return 0.0;
        }
        this.bulletPower = this.bot.getEnergy() > 60.0 || this.bot.getOthers() < 2 && this.enemyEnergy * 2.0 < this.bot.getEnergy() ? Math.min(this.bulletPower, 1200.0 / this.enemyDist) : Math.min(this.bulletPower, 900.0 / this.enemyDist);
        this.bulletPower = Math.min(this.bulletPower, (this.enemyEnergy + 0.1) / 4.0);
        if (this.bulletPower * 6.0 >= this.bot.getEnergy()) {
            this.bulletPower = this.bot.getEnergy() / 6.0;
        }
        if (this.bulletPower >= this.bot.getEnergy() - 0.1) {
            this.bulletPower = this.bot.getEnergy() - 0.1;
        }
        this.bulletPower = Math.max(this.minBulletPower, Math.min(this.maxBulletPower, this.bulletPower));
        if (this.referenceMode) {
            this.bulletPower = Math.min(this.bot.getEnergy(), 3.0);
        }
        if (this.bot.getEnergy() < 0.2) {
            this.bulletPower = 0.0;
        }
        return this.bulletPower;
    }

    public void execute() {
        Bullet b = null;
        if (this.enemyLoc != null) {
            double nextTurn = this.bot.getTurnRemaining() >= 0.0 ? Math.min(this.bot.getTurnRemaining(), 10.0 - 0.75 * Math.abs(this.bot.getVelocity())) : Math.max(this.bot.getTurnRemaining(), -10.0 + 0.75 * Math.abs(this.bot.getVelocity()));
            double nextD = this.bot.getHeading() + nextTurn;
            this.nextX = this.bot.getX() + this.bot.getVelocity() * Utils.sinD(nextTurn);
            this.nextY = this.bot.getY() + this.bot.getVelocity() * Utils.cosD(nextTurn);
            this.headOnAngle = Utils.angleTo(this.nextX, this.nextY, this.enemyLoc.getX(), this.enemyLoc.getY());
            this.bulletPower = this.calcBulletPower();
            if (this.bot.getGunHeat() > this.bot.getGunCoolingRate() || this.bot.getEnergy() < this.bulletPower || this.bulletPower == 0.0) {
                this.aiming = false;
                double GunTurn = Utils.normalizeBearing(this.headOnAngle - this.bot.getGunHeading());
                this.bot.setTurnGunRight(Utils.normalizeBearing(GunTurn));
            } else if (this.aiming && this.bot.getGunTurnRemaining() == 0.0 && this.bot.getGunHeat() == 0.0) {
                b = this.bot.setFireBullet(this.bulletPower);
                this.aiming = false;
            } else if (!this.aiming) {
                this.lastAimTime = this.bot.getTime();
                double fireAngle = this.findBestAngle();
                if (fireAngle != 10000.0) {
                    this.bot.setTurnGunRight(Utils.normalizeBearing(fireAngle - this.bot.getGunHeading()));
                    this.aiming = true;
                } else {
                    this.bot.setTurnGunRight(Utils.normalizeBearing(this.headOnAngle - this.bot.getGunHeading()));
                }
            }
        }
        if (b != null) {
            this.bulletFired(b);
        }
    }

    public void update(BulletHitEvent e) {
        ++this.bulletsHit;
        this.powerHit += e.getBullet().getPower();
    }

    public void update(ScannedRobotEvent e) {
        if (this.referenceMode && this.bot.getEnergy() <= 0.1) {
            return;
        }
        long t1 = this.bot.getTime() - this.startTime;
        if (t1 - this.lastTime > 1L) {
            this.missedScans = (int)((long)this.missedScans + (t1 - this.lastTime - 1L));
        }
        if (t1 - this.lastTime > 20L || t1 < this.lastTime) {
            this.lastRunStart = this.startTime = this.bot.getTime();
        }
        t1 = this.bot.getTime() - this.startTime;
        double dist = e.getDistance();
        double velocity = e.getVelocity();
        double heading = (this.bot.getHeading() + e.getBearing()) % 360.0;
        if (heading < 0.0) {
            heading += 360.0;
        }
        double x = this.bot.getX() + dist * Utils.sinD(heading);
        double y = this.bot.getY() + dist * Utils.cosD(heading);
        this.enemyLoc = new Point2D.Double(x, y);
        this.enemyEnergy = e.getEnergy();
        this.enemyDist = dist;
        double d = this.lastDir = velocity != 0.0 ? velocity : this.lastDir;
        if (velocity != this.lastVel) {
            this.lastRunTime = Math.min(40.0, (double)t1 - (double)this.lastRunStart) / 40.0;
            this.lastRunStart = t1;
        }
        if (velocity * this.lastDir < 0.0 || velocity == 0.0) {
            this.lastRunStart = t1;
        }
        this.lastRunDir = this.lastDir;
        heading = this.lastDir < 0.0 ? (e.getHeading() + 180.0) % 360.0 : e.getHeading();
        Scan currInfo = new Scan(x, y, heading, Math.abs(velocity) / 8.0, t1);
        currInfo.dtm = Math.min(e.getDistance(), 1200.0) / 1200.0;
        currInfo.runTime = Math.min(40.0, (double)(t1 - this.lastRunStart)) / 40.0;
        currInfo.lastRunTime = this.lastRunTime;
        currInfo.myGunHeat = Math.min(1.5, this.bot.getGunHeat()) / 1.5;
        if (Math.abs(this.lastVel) > Math.abs(velocity)) {
            currInfo.acc = 1.0;
        } else if (Math.abs(this.lastVel) < Math.abs(velocity)) {
            currInfo.acc = -1.0;
        }
        this.lastVel = velocity;
        currInfo.atm = Math.abs(Utils.normalizeBearing(heading - this.bot.getHeading() - e.getBearing())) / 180.0;
        justin.Scan s = Tank.getScan(e.getName(), 0);
        currInfo.cbdd = s.deltaSmallestDistance < 0.0 ? -1 : 1;
        currInfo.cbd = Math.min(s.smallestDistance, 600.0) / 600.0;
        currInfo.atcb = s.closestBotAngle;
        currInfo.others = 1.0 - Math.pow(Math.min(this.bot.getOthers(), 10), 2.0) / 100.0;
        currInfo.bcd = s.botCloseDanger;
        double maxWDist = 400.0;
        double distV = 0.0;
        double distH = 0.0;
        distV = heading == 90.0 || heading == 270.0 ? Double.POSITIVE_INFINITY : (heading < 90.0 || heading > 270.0 ? (this.battleFieldHeight - y) / Utils.cosD(heading) : y / Utils.cosD(heading - 180.0));
        distH = heading == 180.0 || heading == 0.0 ? Double.POSITIVE_INFINITY : (heading < 180.0 ? (this.battleFieldWidth - x) / Utils.cosD(heading - 90.0) : x / Utils.cosD(heading - 180.0 - 90.0));
        currInfo.dtwf = 1.0 - Math.min(Math.min(distV, distH), maxWDist) / maxWDist;
        double h1 = (heading + 180.0) % 360.0;
        if (h1 < 0.0) {
            h1 += 360.0;
        }
        distV = h1 == 90.0 || h1 == 270.0 ? Double.POSITIVE_INFINITY : (h1 < 90.0 || h1 > 270.0 ? (this.battleFieldHeight - y) / Utils.cosD(h1) : y / Utils.cosD(h1 - 180.0));
        distH = h1 == 180.0 || h1 == 0.0 ? Double.POSITIVE_INFINITY : (h1 < 180.0 ? (this.battleFieldWidth - x) / Utils.cosD(h1 - 90.0) : x / Utils.cosD(h1 - 180.0 - 90.0));
        currInfo.dtwb = 1.0 - Math.min(Math.min(distV, distH), maxWDist) / maxWDist;
        if (this.size == 0) {
            this.first = currInfo;
            this.last = currInfo;
        } else {
            this.last.next = currInfo;
            currInfo.previous = this.last;
            this.last = currInfo;
        }
        ++this.size;
        this.lastTime = t1;
    }

    public double findBestAngle() {
        int j;
        Scan info = this.last;
        info.fired = true;
        Scan currentInfo = info;
        double currentDistance = 0.0;
        boolean newRound = true;
        Scan[] topInfo = new Scan[this.topCount];
        double[] topDiff = new double[this.topCount];
        double bestAngle = 0.0;
        if (this.last == null) {
            return this.headOnAngle;
        }
        long t1 = info.t;
        long time = (long)(Utils.distanceTo(this.bot, this.last.x, this.last.y) / (20.0 - 3.0 * this.bulletPower) * 1.1);
        int i = 0;
        while (i < this.topCount) {
            topDiff[i] = Double.POSITIVE_INFINITY;
            topInfo[i] = currentInfo;
            ++i;
        }
        long iCount = 0L;
        while (info.previous != null) {
            if (newRound) {
                t1 = info.t;
                while (info.previous != null && t1 - info.t < time && info.t <= t1) {
                    ++iCount;
                    info = info.previous;
                }
                if (info.t > t1) continue;
                newRound = false;
                continue;
            }
            currentDistance = 0.0;
            currentDistance += Gun.sqr(currentInfo.cbd - info.cbd) / 4.0;
            currentDistance += Gun.sqr(currentInfo.cbdd - info.cbdd) / 4.0;
            currentDistance += Gun.sqr(currentInfo.atcb - info.atcb) / 4.0;
            currentDistance += Gun.sqr(currentInfo.others - info.others) / 6.0;
            currentDistance += Gun.sqr(currentInfo.dtm - info.dtm) * 5.0;
            currentDistance += Gun.sqr(currentInfo.atm - info.atm);
            currentDistance += Gun.sqr(currentInfo.v - info.v) * 2.0;
            currentDistance += Gun.sqr(currentInfo.dtwf - info.dtwf) * 4.0;
            currentDistance += Gun.sqr(currentInfo.dtwb - info.dtwb);
            currentDistance += Gun.sqr(currentInfo.runTime - info.runTime);
            currentDistance += Gun.sqr(currentInfo.lastRunTime - info.lastRunTime);
            currentDistance += Gun.sqr((currentInfo.acc - info.acc) / 2.0);
            int i2 = this.topCount - 1;
            while (i2 >= 0 && currentDistance < topDiff[i2]) {
                --i2;
            }
            if (i2 < this.topCount - 1) {
                ++i2;
                int j2 = this.topCount - 2;
                while (j2 >= i2) {
                    topDiff[j2 + 1] = topDiff[j2];
                    topInfo[j2 + 1] = topInfo[j2];
                    --j2;
                }
                topDiff[i2] = currentDistance;
                topInfo[i2] = info;
            }
            info = info.previous;
            ++iCount;
            if (info.t <= t1) continue;
            newRound = true;
        }
        double[] dists = new double[this.topCount];
        int i3 = 0;
        while (i3 < this.topCount) {
            dists[i3] = topDiff[i3];
            ++i3;
        }
        double[][] angles = new double[this.topCount][4];
        int i4 = 0;
        while (i4 < this.topCount) {
            angles[i4][0] = 1000.0;
            ++i4;
        }
        int angCount = 0;
        double angSum = 0.0;
        double avgAng = 0.0;
        int i5 = 0;
        while (i5 < this.topCount && angCount < this.angMax) {
            double ang = this.getGunAngle(topInfo[i5]);
            if (ang < 1000.0) {
                angles[angCount][0] = ang = Utils.normalizeBearing(ang - this.headOnAngle);
                angles[angCount][1] = this.tolerance;
                angles[angCount][2] = 1.0;
                angles[angCount][3] = 1.0;
                j = 0;
                while (j < angCount) {
                    if (angles[j][0] < 1000.0) {
                        if (Math.abs(angles[j][0] - angles[angCount][0]) < angles[angCount][1]) {
                            double[] dArray = angles[j];
                            dArray[2] = dArray[2] + angles[angCount][3];
                        }
                        if (Math.abs(angles[angCount][0] - angles[j][0]) < angles[j][1]) {
                            double[] dArray = angles[angCount];
                            dArray[2] = dArray[2] + angles[j][3];
                        }
                    }
                    ++j;
                }
                ++angCount;
                angSum += ang;
            }
            ++i5;
        }
        double maxCount = 0.0;
        int maxIDX = 0;
        j = 0;
        while (j < angCount) {
            if (angles[j][2] > maxCount) {
                maxCount = angles[j][2];
                maxIDX = j;
            }
            ++j;
        }
        bestAngle = angles[maxIDX][0];
        if (bestAngle >= 1000.0) {
            bestAngle = 0.0;
        }
        return this.headOnAngle + bestAngle;
    }

    public double getGunAngle(Scan predictedInfo) {
        this.tolerance = 0.0;
        Scan currInfo = this.last;
        Scan endInfo = predictedInfo;
        long timeDelta = this.bot.getTime() - this.startTime - currInfo.t;
        double predx = 0.0;
        double predy = 0.0;
        double predDist = 0.0;
        double bulletSpeed = 20.0 - 3.0 * this.bulletPower;
        int i = 0;
        while (i < 50) {
            predDist = Utils.distanceTo(endInfo.x, endInfo.y, predictedInfo.x, predictedInfo.y);
            double predAng = 1.5707963267948966 - Math.atan2(endInfo.y - predictedInfo.y, endInfo.x - predictedInfo.x) - Math.toRadians(predictedInfo.d);
            predx = currInfo.x + predDist * Math.sin(Math.toRadians(currInfo.d) + predAng);
            long bulletTime = (long)((predDist = Utils.distanceTo(predx, predy = currInfo.y + predDist * Math.cos(Math.toRadians(currInfo.d) + predAng), this.nextX, this.nextY) - (double)this.centerHitDist) / bulletSpeed) + 1L;
            if (Math.abs(endInfo.t - predictedInfo.t - timeDelta - bulletTime) <= 1L) break;
            endInfo = predictedInfo;
            while (endInfo.next != null && endInfo.t >= predictedInfo.t && endInfo.t - predictedInfo.t - timeDelta < bulletTime) {
                endInfo = endInfo.next;
            }
            if (endInfo.next == null || endInfo.t < predictedInfo.t) {
                return Double.POSITIVE_INFINITY;
            }
            ++i;
        }
        if (predx < 0.0 || predx > this.battleFieldWidth || predy < 0.0 || predy > this.battleFieldHeight) {
            return Double.POSITIVE_INFINITY;
        }
        this.tolerance = Math.toDegrees(this.toleranceWidth / predDist);
        return Math.toDegrees(1.5707963267948966 - Math.atan2(predy - this.nextY, predx - this.nextX));
    }

    private static final double sqr(double x) {
        return x * x;
    }

    public class Scan {
        public double x = 0.0;
        public double y = 0.0;
        public double d = 0.0;
        public long t = 0L;
        public double v = 0.0;
        public double acc = 0.0;
        public double atm = 0.0;
        public double dtm = 0.0;
        public double dtwf = 0.0;
        public double dtwb = 0.0;
        public double runTime = 0.0;
        public double lastRunTime = 0.0;
        public double myGunHeat = 0.0;
        public double cbdd;
        public double cbd;
        public double atcb;
        public double others;
        public double bcd;
        public boolean fired = false;
        public Scan previous;
        public Scan next;

        public Scan(double x1, double y1, double d1, double v1, long t1) {
            this.x = x1;
            this.y = y1;
            this.d = d1;
            this.v = v1;
            this.t = t1;
        }
    }
}

