/*
 * Decompiled with CFR 0.152.
 */
package ahr.ice;

import ahr.ice.Gun;
import ahr.ice.Math.math;
import ahr.ice.RobotState;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import robocode.Rules;
import robocode.util.Utils;

class LinearIterativeGun
extends Gun {
    LinearIterativeGun() {
    }

    @Override
    public String getName() {
        return "LinearIterative Gun";
    }

    @Override
    public Color getColor() {
        return Color.RED;
    }

    @Override
    public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield) {
        double t2;
        double c;
        double discrim;
        double D;
        double eHd;
        double eV;
        double B;
        double b;
        double eY;
        double C;
        double ROBOT_WIDTH = 16.0;
        double ROBOT_HEIGHT = 16.0;
        double eAbsBearing = shooter.absoluteAngleTo(target);
        double rX = shooter.x;
        double rY = shooter.y;
        double bV = Rules.getBulletSpeed((double)bulletPower);
        double eX = rX + shooter.distance(target) * Math.sin(eAbsBearing);
        double A = (eX - rX) / bV;
        double a = A * A + (C = ((eY = rY + shooter.distance(target) * Math.cos(eAbsBearing)) - rY) / bV) * C;
        double t1 = 2.0 * a / (-(b = 2.0 * (A * (B = (eV = target.velocity) / bV * Math.sin(eHd = target.heading)) + C * (D = eV / bV * Math.cos(eHd)))) - Math.sqrt(discrim = b * b - 4.0 * a * (c = B * B + D * D - 1.0)));
        double t = Math.min(t1, t2 = 2.0 * a / (-b + Math.sqrt(discrim))) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2);
        double endX = math.limit(eX + eV * t * Math.sin(eHd), 8.0, this.getBattleFieldWidth(battlefield) - 8.0);
        double endY = math.limit(eY + eV * t * Math.cos(eHd), 8.0, this.getBattleFieldHeight(battlefield) - 8.0);
        return Utils.normalRelativeAngle((double)Math.atan2(endX - rX, endY - rY));
    }
}

