/*
 * Decompiled with CFR 0.152.
 */
package jwirde;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import jwirde.AIStrategy;
import jwirde.CoordUtils;
import jwirde.Environment;
import jwirde.Ghost;
import jwirde.Gun;
import jwirde.GunStats;
import jwirde.MovementStrategy;
import jwirde.VectPol;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.util.Utils;

public class Gort
extends AdvancedRobot {
    private static final GunStats gunStats = new GunStats();
    private static final double THREAT_RANGE = 200.0;
    private static final double SCAN_RANGE = 400.0;
    private Gun currentGun;
    private MovementStrategy currentMovement;
    private AIStrategy aiStrategy;
    private String target;
    private final Environment env = new Environment();

    public void run() {
        this.aiStrategy = new AIStrategy(this, this.env);
        this.setColors(Color.GRAY, Color.DARK_GRAY, Color.RED);
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            this.execute();
        }
    }

    private boolean hasTarget() {
        return this.target != null;
    }

    private void selectEnemy() {
        if (!this.hasTarget()) {
            Ghost suggestedTarget;
            double distance = Double.MAX_VALUE;
            for (Ghost ghost : this.env.getFoes()) {
                if (!(distance > ghost.distance)) continue;
                distance = ghost.distance;
                this.target = ghost.name;
            }
            if (distance > 200.0 && (suggestedTarget = this.env.foeByName(gunStats.bestTarget(this.env.getFoes(), 400.0))) != null) {
                this.target = suggestedTarget.name;
            }
        }
    }

    public void onRobotDeath(RobotDeathEvent event) {
        String targetName = event.getName();
        if (targetName.equals(this.target)) {
            this.target = null;
        }
        this.env.removeFoe(targetName);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Point2D foeCoord = CoordUtils.getCoordFromBearing(new Point2D.Double(this.getX(), this.getY()), new VectPol(this.getHeadingRadians() + e.getBearingRadians(), e.getDistance()));
        this.env.updateFoe(new Ghost(e.getName(), e.getTime(), foeCoord, e.getBearingRadians(), e.getDistance(), e.getHeadingRadians(), e.getVelocity(), e.getEnergy()));
    }

    public void onStatus(StatusEvent e) {
        if (this.aiStrategy != null) {
            this.aiStrategy.selectRadarStrategy().turnRadar();
        }
        if (!this.hasTarget()) {
            this.selectEnemy();
        }
        if (this.hasTarget()) {
            Ghost foe = this.env.foeByName(this.target);
            if (this.isReadyToFire() && this.isGunStill()) {
                gunStats.shotFired(foe, this.currentGun, this.currentGun.fire());
                this.target = null;
            } else {
                this.currentGun = this.aiStrategy.gunByName(gunStats.bestGun(foe));
                this.currentGun.aim(foe);
            }
            this.currentMovement = this.aiStrategy.selectMovementStrategy();
            this.currentMovement.moveRobot();
        }
    }

    private boolean isReadyToFire() {
        return Utils.isNear((double)this.getGunHeat(), (double)0.0);
    }

    private boolean isGunStill() {
        return Utils.isNear((double)this.getGunTurnRemainingRadians(), (double)0.0);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.currentMovement.onHitByBullet(this.env.foeByName(event.getName()));
    }

    public void onBulletHit(BulletHitEvent e) {
        gunStats.recordHit(e.getBullet());
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        gunStats.recordBulletHitBullet(e.getBullet());
    }

    public void onBulletMissed(BulletMissedEvent e) {
        gunStats.recordMiss(e.getBullet());
    }

    public void onRoundEnded(RoundEndedEvent event) {
        System.out.println("Gun Stats");
        System.out.println("---------");
        System.out.println(gunStats);
    }

    public void onPaint(Graphics2D g) {
        Point2D.Double myPos = new Point2D.Double(this.getX(), this.getY());
        CoordUtils.drawRobotPosition(g, Color.RED, myPos);
        if (this.hasTarget()) {
            Ghost ghost = this.env.foeByName(this.target);
            CoordUtils.drawLineBetweenCoords(g, Color.ORANGE, myPos, ghost.coord);
        }
        this.env.onPaint(g);
        if (this.currentGun != null) {
            this.currentGun.onPaint(g);
        }
        if (this.currentMovement != null) {
            this.currentMovement.onPaint(g);
        }
    }
}

