/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.utils;

import de._4geeks.robots.guns.manager.EnemyScan;
import de._4geeks.robots.guns.manager.Wave;
import de._4geeks.robots.utils.SUtils;
import de._4geeks.robots.utils.apv.MovSim;
import de._4geeks.robots.utils.apv.MovSimStat;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class MEASim {
    protected MovSim sim = new MovSim();
    protected double BFWidth;
    protected double BFHeight;
    private static double WALL_STICK = 140.0;
    private Rectangle2D.Double _fieldRect;

    public MEASim(AdvancedRobot robot) {
        this.BFWidth = robot.getBattleFieldWidth();
        this.BFHeight = robot.getBattleFieldHeight();
        this._fieldRect = new Rectangle2D.Double(18.0, 18.0, this.BFWidth - 36.0, this.BFHeight - 36.0);
    }

    public double forwardSim(Wave wave, double startX, double startY) {
        double orientation = SUtils.sign(wave.getEnemy().getAngularVelocity()) * wave.getEnemy().getOrientation();
        return this.forwardSim(wave, startX, startY, orientation);
    }

    public double backwardSim(Wave wave, double startX, double startY) {
        double orientation = SUtils.sign(wave.getEnemy().getAngularVelocity()) * wave.getEnemy().getOrientation();
        return this.forwardSim(wave, startX, startY, -orientation);
    }

    public double forwardSim(Wave wave, double startX, double startY, double orientation) {
        EnemyScan enemy = wave.getEnemy();
        double currentDist = enemy.getDistance();
        double currentBearing = enemy.getBearing();
        double currentDirection = enemy.getHeading();
        double currentVelocity = enemy.getVelocity();
        double currentX = enemy.getX();
        double currentY = enemy.getY();
        double currentAngularVelocity = enemy.getAngularVelocity();
        double bulletSpeed = 20.0 - 3.0 * wave.getFirePower();
        int i = 0;
        while (i < 500) {
            double desiredAngle = Utils.normalAbsoluteAngle((double)(currentBearing + SUtils.sign(currentAngularVelocity) * Math.PI / 2.0));
            desiredAngle = Utils.normalAbsoluteAngle((double)this.wallSmoothing(currentX, currentY, desiredAngle, (int)SUtils.sign(currentAngularVelocity), 1));
            MovSimStat[] stat = this.sim.futurePos(1, currentX, currentY, currentVelocity, currentDirection, orientation * 10000.0, orientation * Utils.normalRelativeAngle((double)(desiredAngle - currentDirection)), this.BFWidth, this.BFHeight);
            currentX = stat[0].x;
            currentY = stat[0].y;
            currentVelocity = stat[0].v;
            currentDirection = stat[0].h;
            currentDist = Math.sqrt(Math.pow(startX - currentX, 2.0) + Math.pow(startY - currentY, 2.0));
            currentBearing = Utils.normalAbsoluteAngle((double)Math.atan2(currentX - startX, currentY - startY));
            currentAngularVelocity = currentVelocity * Math.sin(Utils.normalRelativeAngle((double)(currentDirection - currentBearing)));
            if ((double)i * bulletSpeed > currentDist) break;
            ++i;
        }
        return Utils.normalRelativeAngle((double)(currentBearing - enemy.getAbsoluteBearing()));
    }

    public double wallSmoothing(double x, double y, double startAngle, int orientation, int smoothTowardEnemy) {
        double angle = startAngle;
        double testX = x + Math.sin(angle += Math.PI * 4) * WALL_STICK;
        double testY = y + Math.cos(angle) * WALL_STICK;
        double wallDistanceX = Math.min(x - 18.0, this.BFWidth - x - 18.0);
        double wallDistanceY = Math.min(y - 18.0, this.BFHeight - y - 18.0);
        double testDistanceX = Math.min(testX - 18.0, this.BFWidth - testX - 18.0);
        double testDistanceY = Math.min(testY - 18.0, this.BFHeight - testY - 18.0);
        double adjacent = 0.0;
        int g = 0;
        while (!this._fieldRect.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += (double)(smoothTowardEnemy * orientation) * (Math.abs(Math.acos(adjacent / WALL_STICK)) + 0.005)) * WALL_STICK;
            testY = y + Math.cos(angle) * WALL_STICK;
            testDistanceX = Math.min(testX - 18.0, this.BFWidth - testX - 18.0);
            testDistanceY = Math.min(testY - 18.0, this.BFHeight - testY - 18.0);
        }
        return angle;
    }
}

