/*
 * Decompiled with CFR 0.152.
 */
package com.spp.robocode;

class VirtualBullet {
    private String target;
    private long fireTime;
    private double startX;
    private double startY;
    private double bearing;
    private double currX;
    private double currY;
    private double velocity;
    private long lastUpdateTime;
    private String targetMethod;

    VirtualBullet(String n, long t, double x, double y, double b, double v, String m) {
        this.target = n;
        this.fireTime = t;
        this.startX = x;
        this.startY = y;
        this.bearing = b;
        this.currX = this.startX;
        this.currY = this.startY;
        this.velocity = v;
        this.targetMethod = m;
        this.lastUpdateTime = t;
    }

    void updatePosition(long time) {
        while (this.lastUpdateTime < time) {
            this.currX += this.velocity * Math.sin(this.bearing);
            this.currY += this.velocity * Math.cos(this.bearing);
            ++this.lastUpdateTime;
        }
    }

    double getX() {
        return this.currX;
    }

    double getY() {
        return this.currY;
    }

    Object getTargetname() {
        return this.target;
    }

    long getTime() {
        return this.fireTime;
    }

    String getTargetMethod() {
        return this.targetMethod;
    }
}

