/*
 * Decompiled with CFR 0.152.
 */
package syl.core;

import java.util.AbstractCollection;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import syl.core.EnemyMap;
import syl.core.FireScanner;
import syl.core.RobotListener;
import syl.util.Angle;
import syl.util.Coordinate;
import syl.util.Log;

public abstract class BaseRobot
extends AdvancedRobot {
    private ArrayList robotListeners = new ArrayList();
    private Coordinate coordinate = new Coordinate(0.0, 0.0);
    private EnemyMap enemyMap = new EnemyMap();
    private FireScanner fireScanner = new FireScanner();
    private static final double CORNER_NEAR_DISTANCE = 100.0;

    public abstract void doInitialize();

    public abstract void performAction();

    public final void run() {
        Log.initialize((Robot)this);
        this.doInitialize();
        this.initialize();
        while (true) {
            this.coordinate.setX(this.getX());
            this.coordinate.setY(this.getY());
            this.performAction();
            this.execute();
        }
    }

    public final void initialize() {
        Coordinate.initialize(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.addRobotListener(this.enemyMap);
        this.enemyMap.addEnemyListener(this.fireScanner);
    }

    public double getEnemyAngle(double enemyBearing) {
        return Angle.toAbsoluteAngle(this.getHeading() + enemyBearing);
    }

    public double getGunToEnemyBearing(double enemyBearing) {
        return Angle.toRelativeAngle(enemyBearing - this.getGunBearing());
    }

    public double getGunBearing() {
        return Angle.toRelativeAngle(this.getGunHeading() - this.getHeading());
    }

    public boolean isCornerNear() {
        if (this.getX() < 100.0 || this.getBattleFieldWidth() - this.getX() < 100.0) {
            return this.getY() < 100.0 || this.getBattleFieldHeight() - this.getY() < 100.0;
        }
        return (this.getY() < 100.0 || this.getBattleFieldHeight() - this.getY() < 100.0) && (this.getX() < 100.0 || this.getBattleFieldWidth() - this.getX() < 100.0);
    }

    public boolean isWallNear() {
        if (this.getX() < 50.0) {
            return true;
        }
        if (this.getBattleFieldWidth() - this.getX() < 50.0) {
            return true;
        }
        if (this.getY() < 50.0) {
            return true;
        }
        return this.getBattleFieldHeight() - this.getY() < 50.0;
    }

    public boolean isSideWallsNear() {
        if (this.getY() < 50.0) {
            return true;
        }
        return this.getBattleFieldHeight() - this.getY() < 50.0;
    }

    public void onBulletHit(BulletHitEvent event) {
        int i = 0;
        while (i < this.robotListeners.size()) {
            ((RobotListener)this.robotListeners.get(i)).onBulletHit(this, event);
            ++i;
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        int i = 0;
        while (i < this.robotListeners.size()) {
            ((RobotListener)this.robotListeners.get(i)).onBulletHitBullet(this, event);
            ++i;
        }
    }

    public void onBulletMissed(BulletMissedEvent event) {
        int i = 0;
        while (i < this.robotListeners.size()) {
            ((RobotListener)this.robotListeners.get(i)).onBulletMissed(this, event);
            ++i;
        }
    }

    public void onDeath(DeathEvent event) {
        int i = 0;
        while (i < this.robotListeners.size()) {
            ((RobotListener)this.robotListeners.get(i)).onDeath(this, event);
            ++i;
        }
    }

    public void onHitByBullet(HitByBulletEvent event) {
        int i = 0;
        while (i < this.robotListeners.size()) {
            ((RobotListener)this.robotListeners.get(i)).onHitByBullet(this, event);
            ++i;
        }
    }

    public void onHitRobot(HitRobotEvent event) {
        int i = 0;
        while (i < this.robotListeners.size()) {
            ((RobotListener)this.robotListeners.get(i)).onHitRobot(this, event);
            ++i;
        }
    }

    public void onHitWall(HitWallEvent event) {
        int i = 0;
        while (i < this.robotListeners.size()) {
            ((RobotListener)this.robotListeners.get(i)).onHitWall(this, event);
            ++i;
        }
    }

    public void onRobotDeath(RobotDeathEvent event) {
        int i = 0;
        while (i < this.robotListeners.size()) {
            ((RobotListener)this.robotListeners.get(i)).onRobotDeath(this, event);
            ++i;
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        int i = 0;
        while (i < this.robotListeners.size()) {
            ((RobotListener)this.robotListeners.get(i)).onScannedRobot(this, event);
            ++i;
        }
    }

    public void onWin(WinEvent event) {
        int i = 0;
        while (i < this.robotListeners.size()) {
            ((RobotListener)this.robotListeners.get(i)).onWin(this, event);
            ++i;
        }
    }

    public void addRobotListener(RobotListener listener) {
        this.robotListeners.add(listener);
    }

    public void removeRobotListener(RobotListener listener) {
        ((AbstractCollection)this.robotListeners).remove(listener);
    }

    public Coordinate getCoordinate() {
        this.coordinate.setX(this.getX());
        this.coordinate.setY(this.getY());
        return this.coordinate;
    }

    public EnemyMap getEnemyMap() {
        return this.enemyMap;
    }

    public FireScanner getFireScanner() {
        return this.fireScanner;
    }
}

