/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.gun.waveGun.formula;

import ags.utils.dataStructures.trees.thirdGenKD.DistanceFunction;
import ags.utils.dataStructures.trees.thirdGenKD.KdTree;
import ags.utils.dataStructures.trees.thirdGenKD.NearestNeighborIterator;
import ags.utils.dataStructures.trees.thirdGenKD.WeightedManhattanDistanceFunction;
import catcat20.core.gun.waveGun.GunWave;
import catcat20.core.gun.waveGun.formula.GunFormula;
import catcat20.core.utils.LUtils;
import catcat20.core.utils.knn.KNNData;
import java.awt.Color;
import java.util.ArrayList;

public class GunKNNModel<T> {
    public KdTree<T> tree;
    public GunFormula formula;
    public int maxK = 32;
    public double kDivisor = 2.0;
    public Color color = new Color(1.0f, 0.0f, 1.0f, 0.33f);
    public double treeWeight = 1.0;
    public double[] weights;
    public DistanceFunction distanceFunction;

    public GunKNNModel(GunFormula formula) {
        this(new WeightedManhattanDistanceFunction(formula.weights), formula);
    }

    public GunKNNModel(DistanceFunction distanceFunction, GunFormula formula) {
        this.distanceFunction = distanceFunction;
        this.weights = formula.weights;
        this.formula = formula;
        this.tree = new KdTree(this.weights.length);
    }

    public GunKNNModel<T> setMaxK(int maxK) {
        this.maxK = maxK;
        return this;
    }

    public GunKNNModel<T> setTreeWeight(double treeWeight) {
        this.treeWeight = treeWeight;
        return this;
    }

    public GunKNNModel<T> setKDivisor(double kDivisor) {
        this.kDivisor = kDivisor;
        return this;
    }

    public GunKNNModel<T> setColor(Color color) {
        this.color = color;
        return this;
    }

    public void addPoint(GunWave w, T data) {
        this.tree.addPoint(this.formula.dataPoint(w), (Object)data);
    }

    public ArrayList<KNNData<T>> getNearestNeighborsList(GunWave w) {
        return this.getNearestNeighborsList(w, LUtils.limit(1, (int)Math.sqrt(this.tree.size()), this.maxK));
    }

    public ArrayList<KNNData<T>> getNearestNeighborsList(GunWave w, double divisor) {
        return this.getNearestNeighborsList(w, LUtils.limit(1, (int)((double)this.tree.size() / divisor), this.maxK));
    }

    public ArrayList<KNNData<T>> getNearestNeighborsList(GunWave w, int k) {
        NearestNeighborIterator<T> neighbors = this.tree.getNearestNeighborIterator(this.formula.dataPoint(w), k, this.distanceFunction);
        ArrayList<KNNData<T>> list = new ArrayList<KNNData<T>>();
        int dataCount = 0;
        for (T data : neighbors) {
            KNNData dataset = new KNNData();
            dataset.order = ++dataCount;
            dataset.distance = neighbors.distance();
            dataset.data = data;
            dataset.treeWeight = this.treeWeight;
            dataset.color = this.color;
            list.add(dataset);
        }
        return list;
    }
}

