/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.Distance;
import bh.units.interfaces.AbsoluteToRelative;
import bh.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Angle
implements Continuum<Angle>,
AbsoluteToRelative<Angle, Angle> {
    public static final Angle ZERO = new Angle(0.0);
    public static final Angle FULL_CIRCLE = new Angle(360.0);
    public static final Angle HALF_CIRCLE = new Angle(180.0);
    private final double degrees;

    public static Angle fromDegrees(double degrees) {
        return new Angle(degrees);
    }

    public static Angle fromRadians(double radians) {
        return new Angle(Math.toDegrees(radians));
    }

    public static Angle atan2(Distance y, Distance x) {
        return new Angle(Math.toDegrees(Math.atan2(y.toDouble(), x.toDouble())));
    }

    public static double sin(Angle angle) {
        return Math.sin(angle.toRadians());
    }

    public static double cos(Angle angle) {
        return Math.cos(angle.toRadians());
    }

    public Angle(double degrees) {
        assert (!Double.isNaN(degrees));
        this.degrees = (double)Math.round(degrees * 1000000.0) / 1000000.0;
    }

    @Override
    public Angle negate() {
        return new Angle(-this.degrees);
    }

    @Override
    public Angle abs() {
        return new Angle(Math.abs(this.degrees));
    }

    @Override
    public Angle plus(Angle angle) {
        return new Angle(this.degrees + angle.degrees);
    }

    @Override
    public Angle minus(Angle angle) {
        return new Angle(this.degrees - angle.degrees);
    }

    @Override
    public Angle times(double scalar) {
        return new Angle(this.degrees * scalar);
    }

    @Override
    public Angle divide(double d) {
        return new Angle(this.degrees / d);
    }

    @Override
    public double divide(Angle d) {
        return this.degrees / d.degrees;
    }

    public Angle normalAbsolute() {
        double circles = Math.floor(this.divide(FULL_CIRCLE));
        Angle result = this.minus(FULL_CIRCLE.times(circles));
        assert (result.toDouble() >= 0.0);
        assert (result.toDouble() < FULL_CIRCLE.toDouble());
        return result;
    }

    public Angle normalRelative() {
        Angle result = this.plus(HALF_CIRCLE).normalAbsolute().minus(HALF_CIRCLE);
        assert (result.toDouble() >= -180.0);
        assert (result.toDouble() < 180.0);
        return result;
    }

    public double sin() {
        return Angle.sin(this);
    }

    public double cos() {
        return Angle.cos(this);
    }

    public double toDegrees() {
        return this.degrees;
    }

    public double toRadians() {
        return Math.toRadians(this.degrees);
    }

    @Override
    public double toDouble() {
        return this.degrees;
    }

    public String toString() {
        return String.valueOf(String.format("%1$6.4f", this.degrees)) + "d";
    }

    public String toStringRadians() {
        return String.valueOf(Long.toString(Math.round(this.toRadians()))) + "r";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Angle)) {
            return false;
        }
        Angle angle = (Angle)o;
        return angle.degrees == this.degrees;
    }

    public int hashCode() {
        return new Double(this.degrees).hashCode();
    }
}

