/*
 * Decompiled with CFR 0.152.
 */
package cli;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.GunTurnCompleteCondition;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.MoveCompleteCondition;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.TurnCompleteCondition;
import robocode.util.Utils;

public class Dancer
extends AdvancedRobot {
    private static int EST_MAX = 3;
    private Pos moveTo;
    private int direction;
    private int currentTarget;
    private int currentThreat;
    private boolean aiming;
    private long lastScanTime;
    private TargetInfo[] Targets;
    private boolean movementOverride;
    private Condition MoveComplete;
    private Condition TurnComplete;
    private Condition GunTurnComplete;
    private Condition RadarTurnComplete;

    public void run() {
        this.TurnComplete = new TurnCompleteCondition((AdvancedRobot)this);
        this.MoveComplete = new MoveCompleteCondition((AdvancedRobot)this);
        this.direction = 100;
        this.currentTarget = -1;
        this.currentThreat = -1;
        this.aiming = false;
        this.movementOverride = false;
        this.setAhead(this.direction);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.RadarTurnComplete = new RadarTurnCompleteCondition((AdvancedRobot)this);
        this.addCustomEvent(this.RadarTurnComplete);
        this.setTurnRadarRight(360.0);
        this.Targets = new TargetInfo[this.getOthers()];
        this.setAdjustGunForRobotTurn(true);
        this.GunTurnComplete = new GunTurnCompleteCondition((AdvancedRobot)this);
        this.addCustomEvent(this.GunTurnComplete);
        double sizeX = this.getBattleFieldWidth();
        double sizeY = this.getBattleFieldHeight();
        double offsetX = sizeX / 2.0;
        double offsetY = sizeY / 2.0;
        if (offsetX > 1200.0 / Math.sqrt(2.0)) {
            offsetX = 1200.0 / Math.sqrt(2.0);
        }
        if (offsetY > 1200.0 / Math.sqrt(2.0)) {
            offsetY = 1200.0 / Math.sqrt(2.0);
        }
        double safetyX = 200.0;
        double safetyY = 200.0;
        if (safetyX > sizeX / 4.0) {
            safetyX = sizeX / 4.0;
        }
        if (safetyY > sizeY / 4.0) {
            safetyY = sizeY / 4.0;
        }
        block0: while (true) {
            if (this.getEnergy() <= Rules.getBulletDamage((double)3.0) && this.currentThreat >= 0) {
                System.out.println("Banzai!");
                do {
                    if (!this.estimateThreatPos()) {
                        System.out.println("No Threat.");
                        continue block0;
                    }
                    this.moveTo(this.Targets[this.currentThreat].estPos[Dancer.EST_MAX].x, this.Targets[this.currentThreat].estPos[Dancer.EST_MAX].y, 100.0, true);
                } while (this.getEnergy() <= Rules.getBulletDamage((double)3.0) && this.currentThreat >= 0);
                continue;
            }
            if (this.getX() < safetyX / 2.0 || this.getX() > sizeX - 1.0 - safetyX / 2.0 || this.getY() < safetyY / 2.0 || this.getY() > sizeY - 1.0 - safetyY / 2.0) {
                System.out.println("Much too close to the walls...");
                this.moveTo(sizeX / 2.0, sizeY / 2.0, (safetyX + safetyY) / 2.0, false);
                if (!(this.getX() >= safetyX / 2.0) || !(this.getX() <= sizeX - 1.0 - safetyX / 2.0) || !(this.getY() >= safetyY / 2.0) || !(this.getY() <= sizeY - 1.0 - safetyY / 2.0)) continue;
                System.out.println("... should be safe now.");
                continue;
            }
            if (this.getX() < safetyX || this.getX() > sizeX - 1.0 - safetyX || this.getY() < safetyY || this.getY() > sizeY - 1.0 - safetyY) {
                System.out.println("Getting clear off the walls...");
                this.moveTo(sizeX / 2.0, sizeY / 2.0, (safetyX + safetyY) / 2.0, true);
                if (!(this.getX() >= safetyX) || !(this.getX() <= sizeX - 1.0 - safetyX) || !(this.getY() >= safetyY) || !(this.getY() <= sizeY - 1.0 - safetyY)) continue;
                System.out.println("... should be safe now.");
                continue;
            }
            if (this.currentThreat < 0) {
                double dY;
                double dX;
                double distance;
                System.out.println("Searching for other bots...");
                while (this.currentThreat < 0 && !this.moveTo(sizeX / 2.0, sizeY / 2.0, 100.0, true)) {
                }
                while (this.currentThreat < 0 && !this.moveTo(offsetX, offsetY, 100.0, true)) {
                }
                while (this.currentThreat < 0 && !this.moveTo(sizeX - 1.0 - offsetX, offsetY, 100.0, true)) {
                }
                while (this.currentThreat < 0 && !this.moveTo(offsetX, sizeY - 1.0 - offsetY, 100.0, true)) {
                }
                while (this.currentThreat < 0 && !this.moveTo(offsetX, offsetY, 100.0, true)) {
                }
                while (this.currentThreat < 0 && !this.moveTo(sizeX - 1.0 - offsetX, sizeY - 1.0 - offsetY, 100.0, true)) {
                }
                while (this.currentThreat < 0 && !this.moveTo(offsetX, sizeY - 1.0 - offsetY, 100.0, true)) {
                }
                while (this.currentThreat < 0 && !this.moveTo(sizeX - 1.0 - offsetX, offsetY, 100.0, true)) {
                }
                while (this.currentThreat < 0 && !this.moveTo(sizeX - 1.0 - offsetX, sizeY - 1.0 - offsetY, 100.0, true)) {
                }
                while (this.currentThreat < 0 && !this.moveTo(sizeX / 2.0, sizeY / 2.0, 100.0, true)) {
                }
                if (this.currentThreat < 0) continue;
                System.out.println("... found.");
                if (!this.estimateThreatPos() || !((distance = Math.sqrt((dX = this.Targets[this.currentThreat].estPos[0].x - this.getX()) * dX + (dY = this.Targets[this.currentThreat].estPos[0].y - this.getY()) * dY)) > 900.0)) continue;
                System.out.println("Moving closer...");
                do {
                    this.moveTo(this.Targets[this.currentThreat].estPos[Dancer.EST_MAX].x, this.Targets[this.currentThreat].estPos[Dancer.EST_MAX].y, 100.0, true);
                } while (this.estimateThreatPos() && (distance = Math.sqrt((dX = this.Targets[this.currentThreat].estPos[0].x - this.getX()) * dX + (dY = this.Targets[this.currentThreat].estPos[0].y - this.getY()) * dY)) > 900.0);
                if (this.currentThreat < 0) {
                    System.out.println("... lost again.");
                    continue;
                }
                System.out.println("... close enough.");
                continue;
            }
            this.setAhead(this.direction);
            while (!this.MoveComplete.test()) {
                this.think();
            }
            this.direction = -this.direction;
        }
    }

    public boolean estimateThreatPos() {
        if (this.currentThreat < 0) {
            return false;
        }
        if (this.Targets[this.currentThreat].estPos == null) {
            this.think();
            if (this.currentThreat < 0) {
                return false;
            }
        }
        return this.Targets[this.currentThreat].estPos != null;
    }

    public double computeDirection(double dX, double dY, double heading, double desiredBearing) {
        return Utils.normalRelativeAngle((double)(Math.atan2(dX, dY) - heading + desiredBearing));
    }

    public double computeDirection(double dX, double dY, double heading) {
        return this.computeDirection(dX, dY, heading, 0.0);
    }

    public boolean moveTo(double x, double y, double maxDist, boolean driveWhileTurning) {
        long time = this.getTime();
        double dX = x - this.getX();
        double dY = y - this.getY();
        double direction = this.computeDirection(dX, dY, this.getHeadingRadians());
        double distance = Math.sqrt(dX * dX + dY * dY);
        if (distance >= 1.0) {
            if (distance > maxDist) {
                distance = maxDist;
            }
            if (Math.abs(direction) > 1.5707963267948966) {
                direction = Utils.normalRelativeAngle((double)(direction + Math.PI));
                distance = -distance;
            }
            this.movementOverride = true;
            this.moveTo = new Pos(x, y);
            if (driveWhileTurning) {
                this.setTurnRightRadians(direction);
                this.setAhead(distance);
                while (!this.MoveComplete.test()) {
                    this.think();
                    dX = x - this.getX();
                    dY = y - this.getY();
                    direction = this.computeDirection(dX, dY, this.getHeadingRadians());
                    distance = Math.sqrt(dX * dX + dY * dY);
                    if (this.getVelocity() < 0.0) {
                        direction = Utils.normalRelativeAngle((double)(direction + Math.PI));
                    }
                    this.setTurnRightRadians(direction);
                }
            } else {
                this.setTurnRightRadians(direction);
                while (!driveWhileTurning && !this.TurnComplete.test()) {
                    this.think();
                }
                this.setAhead(distance);
                while (!this.MoveComplete.test()) {
                    this.think();
                }
            }
            this.movementOverride = false;
            this.moveTo = null;
        }
        if (time == this.getTime()) {
            this.think();
        }
        return distance < 1.0;
    }

    public double recommendedFirePower(double distance, double energy) {
        double firePower = 4.0 - distance / 100.0;
        if (firePower < 1.0) {
            firePower = 1.0;
        }
        if (firePower > 3.0) {
            firePower = 3.0;
        }
        if (firePower < 0.1) {
            firePower = 0.1;
        }
        if (energy < Rules.getBulletDamage((double)firePower)) {
            double power = 0.1;
            while (Rules.getBulletDamage((double)power) <= energy) {
                power += 0.1;
            }
            if (power < firePower) {
                firePower = power;
            }
        }
        if (firePower > this.getEnergy() + 0.1) {
            firePower = 0.1;
        }
        return firePower;
    }

    public Pos estimateTargetPosition(Pos origin, double heading, double velocity, double estTime) {
        double distance = velocity * estTime;
        double distanceX = distance * Math.sin(heading);
        double distanceY = distance * Math.cos(heading);
        Pos p = new Pos(origin.x + distanceX, origin.y + distanceY);
        if (p.x < 0.0) {
            p.x = 0.0;
        }
        if (p.x >= this.getBattleFieldWidth()) {
            p.x = this.getBattleFieldWidth() - 1.0;
        }
        if (p.y < 0.0) {
            p.y = 0.0;
        }
        if (p.y >= this.getBattleFieldHeight()) {
            p.y = this.getBattleFieldHeight() - 1.0;
        }
        return p;
    }

    public void estimateTargetPosition(TargetInfo t) {
        double estTime0;
        if (t == null) {
            return;
        }
        if (t.estPos == null) {
            t.estPos = new Pos[EST_MAX + 1];
        }
        double myX = this.getX();
        double myY = this.getY();
        double distanceX = t.pos.x - myX;
        double distanceY = t.pos.y - myY;
        double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
        double estTime = estTime0 = (double)(this.lastScanTime - t.time);
        t.estFirePower = this.recommendedFirePower(distance, t.energy);
        int i = 0;
        while (i <= EST_MAX) {
            t.estPos[i] = this.estimateTargetPosition(t.pos, t.heading, t.velocity, estTime);
            distanceX = t.estPos[i].x - myX;
            distanceY = t.estPos[i].y - myY;
            distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
            estTime = estTime0 + distance / Rules.getBulletSpeed((double)t.estFirePower);
            if (i < EST_MAX) {
                t.estFirePower = this.recommendedFirePower(distance, t.energy);
            }
            ++i;
        }
        t.lost = estTime0 * 45.0 > 720.0;
    }

    public void think() {
        double dY;
        this.lastScanTime = this.getTime();
        double myX = this.getX();
        double myY = this.getY();
        int closest = -1;
        int disabled = -1;
        int newest = -1;
        double closestDist = Double.MAX_VALUE;
        double disabledDist = Double.MAX_VALUE;
        long newestAge = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.Targets.length) {
            if (this.Targets[i] != null) {
                this.estimateTargetPosition(this.Targets[i]);
                double distanceX = this.Targets[i].estPos[Dancer.EST_MAX].x - myX;
                double distanceY = this.Targets[i].estPos[Dancer.EST_MAX].y - myY;
                double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
                long age = this.lastScanTime - this.Targets[i].time;
                if (distance < disabledDist && !this.Targets[i].lost && this.Targets[i].energy <= 0.0) {
                    disabled = i;
                    disabledDist = distance;
                }
                if (distance < closestDist && !this.Targets[i].lost && this.Targets[i].energy > 0.0) {
                    closest = i;
                    closestDist = distance;
                }
                if (age < newestAge && !this.Targets[i].lost) {
                    newest = i;
                    newestAge = age;
                }
            }
            ++i;
        }
        if (closest < 0 && disabled >= 0) {
            closest = disabled;
        }
        if (this.currentTarget < 0 && disabled >= 0) {
            this.currentTarget = disabled;
        }
        if (this.currentTarget < 0 && closest >= 0) {
            this.currentTarget = closest;
        }
        if (this.currentTarget >= 0 && !this.aiming) {
            double dX = this.Targets[this.currentTarget].estPos[Dancer.EST_MAX].x - myX;
            dY = this.Targets[this.currentTarget].estPos[Dancer.EST_MAX].y - myY;
            double direction = this.computeDirection(dX, dY, this.getGunHeadingRadians());
            this.aiming = true;
            this.setTurnGunRightRadians(direction);
        }
        this.currentThreat = -1;
        if (closest >= 0) {
            this.currentThreat = closest;
        } else if (newest >= 0) {
            this.currentThreat = newest;
        }
        if (this.currentThreat >= 0 && !this.movementOverride) {
            double dX = this.Targets[this.currentThreat].estPos[0].x - myX;
            dY = this.Targets[this.currentThreat].estPos[0].y - myY;
            double desiredBearing = 1.5707963267948966;
            double direction = this.computeDirection(dX, dY, this.getHeadingRadians(), desiredBearing);
            if (Math.abs(direction) > 1.5707963267948966) {
                direction = Utils.normalRelativeAngle((double)(direction + Math.PI));
            }
            this.setTurnRightRadians(direction);
        }
        this.execute();
    }

    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition() == this.MoveComplete) {
            this.onMoveComplete(e);
        } else if (e.getCondition() == this.RadarTurnComplete) {
            this.onRadarTurnComplete(e);
        } else if (e.getCondition() == this.GunTurnComplete) {
            this.onGunTurnComplete(e);
        } else {
            System.out.println("onCustomEvent(<unexpected>)");
        }
    }

    public void onMoveComplete(CustomEvent e) {
        this.direction -= this.direction;
        if (this.direction > 0) {
            this.setAhead(this.direction);
        } else if (this.direction < 0) {
            this.setBack(-this.direction);
        }
    }

    public void onRadarTurnComplete(CustomEvent e) {
        this.setTurnRadarRight(360.0);
    }

    public void onGunTurnComplete(CustomEvent e) {
        if (this.aiming && this.currentTarget >= 0 && this.getGunHeat() == 0.0 && this.Targets[this.currentTarget].time == this.lastScanTime) {
            if (this.getOthers() == 1) {
                if (this.getEnergy() > this.Targets[this.currentTarget].estFirePower) {
                    this.setFire(this.Targets[this.currentTarget].estFirePower);
                    this.currentTarget = -1;
                }
            } else if (this.getEnergy() > this.Targets[this.currentTarget].estFirePower) {
                this.setFire(this.Targets[this.currentTarget].estFirePower);
                this.currentTarget = -1;
            }
        }
        this.aiming = false;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double bearingRad = e.getBearingRadians() + this.getHeadingRadians();
        double distance = e.getDistance();
        TargetInfo target = new TargetInfo();
        target.name = e.getName();
        target.time = this.getTime();
        target.pos = new Pos(this.getX() + distance * Math.sin(bearingRad), this.getY() + distance * Math.cos(bearingRad));
        target.heading = e.getHeadingRadians();
        target.velocity = e.getVelocity();
        target.energy = e.getEnergy();
        TargetInfo lastInfo = null;
        int i = 0;
        while (i < this.Targets.length) {
            if (this.Targets[i] != null && this.Targets[i].name.equals(target.name)) {
                lastInfo = this.Targets[i];
                this.Targets[i] = target;
                break;
            }
            ++i;
        }
        if (lastInfo == null) {
            i = 0;
            while (i < this.Targets.length) {
                if (this.Targets[i] == null) {
                    this.Targets[i] = target;
                    break;
                }
                ++i;
            }
        }
        this.estimateTargetPosition(target);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.movementOverride) {
            return;
        }
        double bearing = (e.getBearing() + 360.0) % 360.0;
        if (bearing < -90.0) {
            this.setAhead(this.direction);
            this.execute();
        } else if (bearing < 0.0) {
            this.setAhead(this.direction);
            this.execute();
        } else if (bearing < 90.0) {
            this.setAhead(this.direction);
            this.execute();
        } else {
            this.setAhead(this.direction);
            this.execute();
        }
    }

    public void onHitWall(HitWallEvent e) {
        System.out.println("onHitWall");
    }

    public void onRobotDeath(RobotDeathEvent e) {
        int i = 0;
        while (i < this.Targets.length) {
            if (this.Targets[i] != null && this.Targets[i].name.equals(e.getName())) {
                this.Targets[i] = null;
                if (this.currentTarget == i) {
                    this.currentTarget = -1;
                }
                if (this.currentThreat != i) break;
                this.currentThreat = -1;
                break;
            }
            ++i;
        }
    }

    public void onPaint(Graphics2D g) {
        double myX = this.getX();
        double myY = this.getY();
        if (this.moveTo != null) {
            g.setPaint(Color.BLUE);
            g.draw(new Line2D.Double(myX, myY, this.moveTo.x, this.moveTo.y));
            g.draw(new Ellipse2D.Double(this.moveTo.x - 10.0, this.moveTo.y - 10.0, 20.0, 20.0));
        }
        if (this.currentTarget >= 0 && this.Targets[this.currentTarget].estPos != null) {
            g.setPaint(Color.RED);
            g.draw(new Line2D.Double(myX, myY, this.Targets[this.currentTarget].estPos[Dancer.EST_MAX].x, this.Targets[this.currentTarget].estPos[Dancer.EST_MAX].y));
            g.draw(new Ellipse2D.Double(this.Targets[this.currentTarget].estPos[Dancer.EST_MAX].x - 32.0, this.Targets[this.currentTarget].estPos[Dancer.EST_MAX].y - 32.0, 64.0, 64.0));
        }
        if (this.currentThreat >= 0 && this.Targets[this.currentThreat].estPos != null) {
            g.setPaint(Color.YELLOW);
            g.draw(new Ellipse2D.Double(this.Targets[this.currentThreat].estPos[0].x - 32.0, this.Targets[this.currentThreat].estPos[0].y - 32.0, 64.0, 64.0));
        }
        int i = 0;
        while (i < this.Targets.length) {
            if (this.Targets[i] != null && this.Targets[i].estPos != null) {
                g.setPaint(Color.CYAN);
                g.draw(new Rectangle2D.Double(this.Targets[i].estPos[0].x - 16.0, this.Targets[i].estPos[0].y - 16.0, 32.0, 32.0));
                if (this.Targets[i].time == this.getTime()) {
                    g.draw(new Rectangle2D.Double(this.Targets[i].estPos[0].x - 12.0, this.Targets[i].estPos[0].y - 12.0, 24.0, 24.0));
                }
            }
            ++i;
        }
        if (this.getGunHeat() > 0.0) {
            g.setPaint(Color.RED);
        } else {
            g.setPaint(Color.GREEN);
        }
        g.draw(new Rectangle2D.Double(myX - 16.0, myY - 16.0, 32.0, 32.0));
        g.draw(new Rectangle2D.Double(myX - 12.0, myY - 12.0, 24.0, 24.0));
        g.draw(new Rectangle2D.Double(myX - 8.0, myY - 8.0, 16.0, 16.0));
    }

    private class Pos {
        public double x;
        public double y;

        public Pos(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    private class TargetInfo {
        public String name;
        public long time;
        public Pos pos;
        public double heading;
        public double velocity;
        public double energy;
        public Pos[] estPos;
        public double estFirePower;
        public boolean lost;

        private TargetInfo() {
        }
    }
}

