/*
 * Decompiled with CFR 0.152.
 */
package ara;

import ara.Util;
import java.awt.geom.Point2D;

public class VBullet {
    private double X;
    private double Y;
    private long Time;
    private double Power;
    public int Index;
    private int Stop;
    private double Distance;
    private boolean Melee;
    public double Weight;
    private double DX;
    private double DY;
    public long Expire;
    public boolean Cheaked;

    public VBullet(double x, double y, double px, double py, double power, long time, int index, int stop, double weight, boolean melee) {
        this.X = x;
        this.Y = y;
        this.Power = power;
        this.Time = time;
        this.Index = index;
        this.Stop = stop;
        this.Weight = weight;
        this.Distance = Util.Dist(x, y, px, py);
        double bv = 20.0 - 3.0 * power;
        double ba = Util.Deg(x, y, px, py);
        this.DX = bv * Util.cosDeg(ba);
        this.DY = bv * Util.sinDeg(ba);
        this.Melee = melee;
        this.Expire = this.Time + (long)(this.Distance * 1.2 / bv);
        this.Cheaked = false;
    }

    boolean isHit(long t, double ex, double ey) {
        long dt = t - this.Time;
        double x = this.X + (double)dt * this.DX;
        double y = this.Y + (double)dt * this.DY;
        return Util.Dist(x, y, ex, ey) < 13.0;
    }

    public Point2D.Double GetBulPos(long t) {
        long dt = t - this.Time;
        double x = this.X + (double)dt * this.DX;
        double y = this.Y + (double)dt * this.DY;
        return new Point2D.Double(x, y);
    }

    public int GetNumber() {
        return VBullet.GetNumber(this.Stop, this.Distance, this.Melee);
    }

    public static int GetNumber(int stop, double dist, boolean melee) {
        int n = dist < 200.0 ? 0 : (dist < 400.0 ? 1 : (dist < 600.0 ? 2 : 3));
        if (stop == 1) {
            n += 4;
        }
        if (melee) {
            n += 8;
        }
        return n;
    }
}

