/*
 * Decompiled with CFR 0.152.
 */
package agd.radar;

import agd.radar.HeadingComparator;
import agd.radar.RadarStrategy;
import agd.util.AdvancedRobotAdapter;
import agd.util.AdvancedRobotListener;
import agd.util.AngularDir;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Enemy;
import agd.util.RobotInformation;
import java.util.Arrays;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;

public class MultipleTargetRadarLock
extends AdvancedRobotAdapter
implements RadarStrategy,
AdvancedRobotListener {
    AdvancedRobot robot = null;
    RobotInformation robotinfo = null;
    Enemy target = null;
    int maxTargets = 0;
    long timeLast360 = 0L;
    static final int FULL_SCAN_PERIOD = 100;
    AngularDir lastSweep = AngularDir.CLOCKWISE;

    public MultipleTargetRadarLock(RobotInformation ourrobot) {
        this(ourrobot, 0);
    }

    public MultipleTargetRadarLock(RobotInformation ourrobot, int max) {
        this.robot = ourrobot.getAdvancedRobot();
        this.robotinfo = ourrobot;
        this.maxTargets = max;
        ourrobot.addListener(this);
    }

    public void setPrimaryTarget(Enemy e) {
        this.target = e;
    }

    public void onRobotDeath(RobotDeathEvent rde) {
        if (this.target != null && rde.getName() == this.target.getName()) {
            this.target = null;
        }
    }

    public double getRadarBearing() {
        RadarTurnCompleteCondition radarStationary = new RadarTurnCompleteCondition(this.robot);
        double bearing = 0.0;
        if (radarStationary.test()) {
            if (this.target == null) {
                bearing = 360.0;
                this.timeLast360 = this.robot.getTime();
                this.lastSweep = AngularDir.CLOCKWISE;
            } else if (this.robot.getOthers() > 1 && this.robot.getTime() - this.timeLast360 > 100L) {
                bearing = 360.0;
                this.timeLast360 = this.robot.getTime();
                this.lastSweep = AngularDir.CLOCKWISE;
            } else {
                Enemy[] relativeDistribution = this.assessTargets();
                if (this.lastSweep == AngularDir.CLOCKWISE) {
                    Coord sweepTo = relativeDistribution[0].getLastSighting().getTheirPosition();
                    Compass desiredHeading = this.robotinfo.getPosition().headingTo(sweepTo);
                    bearing = new Compass(this.robot.getRadarHeading()).bearingTo(desiredHeading);
                    if ((bearing -= 10.0) > 0.0) {
                        bearing -= 360.0;
                    }
                    this.lastSweep = AngularDir.ANTICLOCKWISE;
                } else {
                    Coord sweepTo = relativeDistribution[relativeDistribution.length - 1].getLastSighting().getTheirPosition();
                    Compass desiredHeading = this.robotinfo.getPosition().headingTo(sweepTo);
                    bearing = new Compass(this.robot.getRadarHeading()).bearingTo(desiredHeading);
                    if (bearing < 0.0) {
                        bearing += 360.0;
                    }
                    bearing += 10.0;
                    this.lastSweep = AngularDir.CLOCKWISE;
                }
            }
        }
        return bearing;
    }

    Enemy[] assessTargets() {
        List enemies = this.robotinfo.getClosestEnemies(this.maxTargets);
        Enemy[] enemyDistribution = enemies.toArray(new Enemy[enemies.size()]);
        Arrays.sort(enemyDistribution, new HeadingComparator(this.robotinfo, this.target));
        return enemyDistribution;
    }

    static {
        FULL_SCAN_PERIOD = 100;
    }
}

