/*
 * Decompiled with CFR 0.152.
 */
package eem.motion;

import eem.EvBot;
import eem.misc.logger;
import eem.misc.math;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class basicMotion {
    protected EvBot myBot;
    protected double battleFieldHeight = 0.0;
    protected double battleFieldWidth = 0.0;
    protected int robotHalfSize;
    protected double dangerForPointTouchingTheWall = 1000000.0;
    protected double dangerLevelWall = 50.0;
    protected double dangerLevelCorner = 10000.0;
    protected double safe_distance_from_wall;

    public void initTic() {
    }

    public basicMotion() {
    }

    public basicMotion(EvBot evBot) {
        this.myBot = evBot;
        this.battleFieldWidth = evBot.BattleField.x;
        this.battleFieldHeight = evBot.BattleField.y;
        this.robotHalfSize = evBot.robotHalfSize;
        this.safe_distance_from_wall = this.robotHalfSize + 2;
    }

    public double bearingTo(Point2D.Double double_) {
        return math.shortest_arc(math.cortesian2game_angles(Math.atan2(double_.y - this.myBot.myCoord.y, double_.x - this.myBot.myCoord.x) * 180.0 / Math.PI));
    }

    public void moveToPoint(Point2D.Double double_) {
        double d = math.shortest_arc(this.bearingTo(double_) - this.myBot.getHeading());
        double d2 = this.myBot.myCoord.distance(double_);
        if (Math.abs(d) > 90.0) {
            d = d > 90.0 ? (d -= 180.0) : (d += 180.0);
            d2 = -d2;
        }
        this.myBot.setTurnRight(d);
        this.myBot.setAhead(d2);
    }

    public void makeMove() {
    }

    public void onPaint(Graphics2D graphics2D) {
    }

    public double maxRotationPerTurnInDegrees(double d) {
        return 10.0 - 0.75 * Math.abs(d);
    }

    public double stopDistance(double d) {
        double d2 = Math.abs(d);
        int n = 0;
        for (d2 = -2.0; d2 > 0.0; d2 -= 2.0) {
            n = (int)((double)n + d2);
        }
        return n;
    }

    public double stopDistanceVector(double d) {
        return -this.stopDistance(d) * (double)math.sign(d);
    }

    public double pointDangerFromCorners(Point2D.Double double_, double d) {
        double d2 = 0.0;
        double d3 = 100.0;
        Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
        double d4 = double_2.distance(double_);
        d2 += math.gaussian(d4, this.dangerLevelCorner, 2.0 * this.safe_distance_from_wall);
        double_2 = new Point2D.Double(this.myBot.BattleField.x, this.myBot.BattleField.y);
        d4 = double_2.distance(double_);
        d2 += math.gaussian(d4, this.dangerLevelCorner, 2.0 * this.safe_distance_from_wall);
        double_2 = new Point2D.Double(this.myBot.BattleField.x, 0.0);
        d4 = double_2.distance(double_);
        d2 += math.gaussian(d4, this.dangerLevelCorner, 2.0 * this.safe_distance_from_wall);
        double_2 = new Point2D.Double(0.0, this.myBot.BattleField.y);
        d4 = double_2.distance(double_);
        return d2 += math.gaussian(d4, this.dangerLevelCorner, 2.0 * this.safe_distance_from_wall);
    }

    public double pointDangerFromWalls(Point2D.Double double_, double d) {
        double d2 = 0.0;
        double d3 = this.dist2LeftOrRightWall(double_);
        double d4 = this.dist2BottomOrTopWall(double_);
        if (this.shortestDist2wall(double_) <= (double)this.robotHalfSize + this.stopDistance(d) + 2.0) {
            d2 += this.dangerForPointTouchingTheWall;
        }
        d2 += math.gaussian(d3, this.dangerLevelWall, this.safe_distance_from_wall);
        return d2 += math.gaussian(d4, this.dangerLevelWall, this.safe_distance_from_wall);
    }

    public double dist2LeftOrRightWall(Point2D.Double double_) {
        double d = double_.x;
        double d2 = this.battleFieldWidth - double_.x;
        if (d <= 0.0 || d2 <= 0.0) {
            return 0.0;
        }
        return Math.min(d, d2);
    }

    public double dist2BottomOrTopWall(Point2D.Double double_) {
        double d = double_.y;
        double d2 = this.battleFieldHeight - double_.y;
        if (d2 <= 0.0 || d <= 0.0) {
            return 0.0;
        }
        return Math.min(d, d2);
    }

    public double shortestDist2wall(Point2D.Double double_) {
        return Math.min(this.dist2LeftOrRightWall(double_), this.dist2BottomOrTopWall(double_));
    }

    public double angleToClosestCorner() {
        double d = this.myBot.myCoord.x;
        double d2 = this.myBot.myCoord.y;
        double d3 = 0.0;
        double d4 = 0.0;
        d3 = d <= this.myBot.BattleField.x / 2.0 ? 0.0 : this.myBot.BattleField.x;
        d4 = d2 <= this.myBot.BattleField.y / 2.0 ? 0.0 : this.myBot.BattleField.y;
        logger.noise("the closest corner is at " + d3 + ", " + d4);
        return this.bearingTo(new Point2D.Double(d3, d4));
    }

    public double shortestTurnRadiusVsSpeed() {
        return 115.0;
    }

    public String whichWallAhead() {
        return math.whichWallAhead(this.myBot.myCoord, this.myBot.getVelocity(), this.myBot.getHeadingRadians());
    }

    public double distanceToWallAhead() {
        return math.distanceToWallAhead(this.myBot.myCoord, this.myBot.getVelocity(), this.myBot.getHeadingRadians());
    }

    public double distanceToTheClosestWallFrom(double d, double d2) {
        double[] dArray = new double[]{d, this.myBot.BattleField.x - d, d2, this.myBot.BattleField.y - d2};
        Arrays.sort(dArray);
        return dArray[0];
    }

    public double whichWayToRotateAwayFromWall() {
        double d = this.myBot.getHeading();
        String string = this.whichWallAhead();
        if (this.myBot.getVelocity() < 0.0) {
            d += 180.0;
        }
        d = math.shortest_arc(d);
        double d2 = this.myBot.myCoord.x;
        double d3 = this.myBot.myCoord.y;
        boolean bl = true;
        double d4 = 0.0;
        logger.noise("heading angle = " + d);
        if (string.equals("left")) {
            d4 = -90.0 <= d && d <= 0.0 ? -d : -180.0 - d;
        }
        if (string.equals("right")) {
            d4 = 0.0 <= d && d <= 90.0 ? -d : 180.0 - d;
        }
        if (string.equals("bottom")) {
            d4 = 90.0 <= d && d <= 180.0 ? 90.0 - d : -90.0 - d;
        }
        if (string.equals("top")) {
            d4 = 0.0 <= d && d <= 90.0 ? 90.0 - d : -90.0 - d;
        }
        logger.noise("body heading = " + d);
        logger.noise("rotation from wall is " + d4);
        return d4;
    }
}

